/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.scene;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.Gradient;
import com.ibm.vis.engine.internal.GradientType;
import com.ibm.vis.engine.internal.ImageStyle;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.ColorOffsetSpec;
import com.ibm.vis.spec.internal.EffectSpec;
import com.ibm.vis.spec.internal.FillSpec;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class StyleBuilder {
    public static final String TRANSPARENT = "transparent";
    public static final String FILL = "fill";
    public static final String IMAGE = "image";
    public static final String INSIDE_OUTLINE_METHOD = "inside";
    public static final String LOCATION_INSIDE = "inside";
    public static final String LOCATION_STRETCH = "stretch";
    public static final String LOCATION_FIT = "fit";
    public static final String LOCATION_OUTWARD = "outward";
    public static final String LOCATION_OUTSIDE = "outside";
    public static final String LOCATION_CALLOUT = "callout";
    public static final String ALIGNEDGE_VERTICAL = "vertical";
    public static final String ALIGNEDGE_HORIZONTAL = "horizontal";

    public static double getPreferredSize(PreferredSizeSpec preferredSizeSpec, double d, boolean bl, double d2) {
        double d3 = d;
        if (preferredSizeSpec != null) {
            Double d4 = UnitConverter.convertLength(preferredSizeSpec.preferred, d, d2);
            Double d5 = UnitConverter.convertLength(preferredSizeSpec.max, d, d2);
            Double d6 = UnitConverter.convertLength(preferredSizeSpec.min, d, d2);
            if (d4 != null) {
                d3 = bl ? Math.max(d4, d) : d4;
            }
            if (d5 != null) {
                d3 = Math.min(d3, d5);
            }
            if (d6 != null) {
                d3 = Math.max(d3, d6);
            }
        }
        return Math.min(d3, d2);
    }

    public static void modifyFillColor(Shape shape, ColorNew colorNew) {
        Fill fill = shape.getFill();
        if (fill == null) {
            shape.setFill(Fill.makeSolid(colorNew));
        } else if (fill.getGradient() == null) {
            shape.setFill(Fill.makeSolid(ColorUtil.makeCombinedColor(colorNew, fill.getSolid())));
        } else {
            Gradient gradient = fill.getGradient();
            gradient = Gradient.modifyGradientWithSolid(gradient, colorNew);
            shape.setFill(Fill.makeGradient(gradient));
        }
    }

    public static void modifyPaletteFill(Shape shape, StyleSpec styleSpec) {
        if (styleSpec.fill instanceof FillSpec) {
            FillSpec fillSpec = (FillSpec)styleSpec.fill;
            Gradient gradient = Gradient.makeFromSpec(fillSpec, ColorUtil.getDefaultFillColor());
            if (shape.getFill() != null && shape.getFill().getSolid() != null) {
                gradient = Gradient.modifySolidWithGradient(gradient, shape.getFill().getSolid());
            }
            shape.setFill(Fill.makeGradient(gradient));
        } else {
            ColorNew colorNew = ColorUtil.toCanonicalColor(styleSpec.fill);
            StyleBuilder.modifyFillColor(shape, colorNew);
        }
    }

    public static void modifyMainColor(Shape shape, ColorNew colorNew) {
        if (shape.getColorAestheticOnlyChangesOutline() || shape.getFill() == null) {
            shape.setOutline(ColorUtil.makeCombinedColor(colorNew, shape.getOutline()));
        } else {
            StyleBuilder.modifyFillColor(shape, colorNew);
        }
    }

    public static void modifyStrokeColor(Shape shape, ColorNew colorNew) {
        shape.setOutline(colorNew);
        if (!shape.isFilled()) {
            shape.setFill(Fill.makeSolid(colorNew));
        }
    }

    public static void setDefaultFillStyle(Shape shape) {
        shape.setFill(Fill.getDefaultFill());
        shape.setOutline(ColorUtil.getDefaultStrokeColor());
    }

    public static void setDefaultStrokeStyle(Shape shape) {
        shape.setFill(Fill.getDefaultStrokeFill());
    }

    public static void setDefaultTextStyle(Text text) {
        text.setFill(Fill.getDefaultStrokeFill());
    }

    public static void setFilled(Shape shape, StyleSpec styleSpec) {
        StyleBuilder.addFill(shape, styleSpec, ColorUtil.getDefaultFillColor());
        StyleBuilder.addStroke(shape, styleSpec, false);
        if (styleSpec != null) {
            StyleBuilder.addEffect(shape, styleSpec.effect);
            if ("inside".equals(styleSpec.outlineMethod)) {
                shape.setInsideStroke(true);
            }
        }
    }

    public static void setUnfilled(Shape shape, StyleSpec styleSpec, Double d) {
        StyleBuilder.addFill(shape, styleSpec, ColorUtil.getDefaultStrokeColor());
        if (d != null) {
            StyleBuilder.scaleStrokeSize(shape, d);
        }
        StyleBuilder.addStroke(shape, styleSpec, false);
        StyleBuilder.addEffect(shape, styleSpec.effect);
    }

    public static void scaleStrokeSize(Shape shape, double d) {
        Stroke stroke = shape.getStroke();
        if (stroke == null) {
            stroke = Stroke.DEFAULT_STROKE;
        }
        shape.setStroke(stroke.createStrokeOfWidth(stroke.getWidth() * d));
    }

    public static void setStrokeSize(Shape shape, double d) {
        Stroke stroke = shape.getStroke();
        if (stroke == null) {
            stroke = Stroke.DEFAULT_STROKE;
        }
        shape.setStroke(stroke.createStrokeOfWidth(d));
    }

    public static Stroke makeStroke(Shape shape, StrokeSpec strokeSpec) {
        Object object;
        Stroke stroke = shape.getStroke();
        if (stroke == null) {
            stroke = Stroke.DEFAULT_STROKE;
        }
        double d = stroke.getWidth();
        if (strokeSpec.width != null && (object = UnitConverter.convertLength(strokeSpec.width, 1.0, 1.0)) != null) {
            d = ((Number)object).doubleValue();
        }
        object = strokeSpec.style != null ? strokeSpec.style : stroke.getDashing();
        Object object2 = strokeSpec.join != null ? strokeSpec.join : stroke.getJoin();
        String string = strokeSpec.cap != null ? strokeSpec.cap : stroke.getCap();
        return new Stroke(d, (String)object, object2, string, stroke.getColor());
    }

    public static void modifyStrokeStyle(Shape shape, String string) {
        Stroke stroke = shape.getStroke();
        if (stroke == null) {
            stroke = Stroke.DEFAULT_STROKE;
        }
        shape.setStroke(stroke.createStrokeWithDashing(string));
    }

    public static void addEffect(Shape shape, EffectSpec effectSpec) {
        shape.setEffect(RenderEffects.makeFromStyle(effectSpec));
    }

    public static double getStrokeWidth(StyleSpec styleSpec) {
        if (styleSpec != null && styleSpec.stroke != null && !"inside".equals(styleSpec.outlineMethod)) {
            Double d = UnitConverter.convertLength(styleSpec.stroke.width, 1.0, 1.0);
            return d == null ? 1.0 : d;
        }
        return 1.0;
    }

    public static boolean getSnap(StyleSpec styleSpec) {
        return styleSpec != null && styleSpec.snap != null ? styleSpec.snap : false;
    }

    public static Shape modifyShapeStyle(Shape shape, StyleSpec styleSpec) {
        if (styleSpec == null) {
            return shape;
        }
        if (styleSpec.fill != null) {
            StyleBuilder.modifyPaletteFill(shape, styleSpec);
        }
        if (styleSpec.outline != null) {
            ColorNew colorNew = ColorUtil.toCanonicalColor(styleSpec.outline);
            shape.setOutline(ColorUtil.makeCombinedColor(colorNew, shape.getOutline()));
        }
        if (styleSpec.effect != null) {
            StyleBuilder.addEffect(shape, styleSpec.effect);
        }
        if (styleSpec.stroke != null) {
            shape.setStroke(StyleBuilder.makeStroke(shape, styleSpec.stroke));
        }
        if (styleSpec.startArrow != null) {
            shape.setStartArrowByName(styleSpec.startArrow);
        }
        if (styleSpec.endArrow != null) {
            shape.setEndArrowByName(styleSpec.endArrow);
        }
        if (styleSpec.image != null) {
            shape.setImage(new ImageStyle(styleSpec.image));
        }
        return shape;
    }

    public static void expandStroke(StyleSpec styleSpec, double d) {
        Double d2;
        if (styleSpec.stroke == null && styleSpec.outline == null) {
            return;
        }
        if (styleSpec.stroke == null) {
            styleSpec.stroke = new StrokeSpec();
        }
        if ((d2 = UnitConverter.convertLength(styleSpec.stroke.width, 1.0, 1.0)) == null) {
            d2 = 1.0;
        }
        styleSpec.stroke.width = d2 + d;
    }

    public static double getDefaultStrokeWidth() {
        return 1.0;
    }

    public static double getRectangleCornerRadius(StyleSpec styleSpec, double d, double d2, boolean bl) {
        double d3 = 0.0;
        if (styleSpec != null && styleSpec.cornerRadius != null) {
            d3 = UnitConverter.convertLength(styleSpec.cornerRadius, 1.0, 1.0);
            d3 = d3 < 0.0 ? 0.0 : d3;
            d3 = bl ? Math.min(d3, Math.min(d / 2.0, d2 / 2.0)) : Math.min(d3, 1.0);
        }
        return d3;
    }

    public static void modifyThresholdStyleSpec(StyleSpec styleSpec, Scale[] scaleArray) {
        if (StyleBuilder.isThresholdStyleSpec(styleSpec)) {
            Scale scale = StyleBuilder.getFillSpecScale(styleSpec, scaleArray);
            StyleBuilder.modifyColorStopOffset(styleSpec, scale);
        }
    }

    public static boolean isThresholdStyleSpec(StyleSpec styleSpec) {
        if (styleSpec != null && styleSpec.fill != null && styleSpec.fill instanceof FillSpec) {
            FillSpec fillSpec = (FillSpec)styleSpec.fill;
            String string = fillSpec.type;
            int n = GradientType.getByName(string);
            if (1001 == n || 1002 == n) {
                if (fillSpec.global == null || !fillSpec.global.booleanValue()) {
                    throw new SpecException("Invalid value for fill.global, should be \"true\" when gradient type is either \"linearByYDimension\" or \"linearByXDimension\" ", ErrorCode.SPEC_INVALID_VALUE, null);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean hasTransparentFill(StyleSpec styleSpec) {
        ColorNew colorNew;
        double[] dArray;
        boolean bl = false;
        if (styleSpec != null && styleSpec.fill != null && !(styleSpec.fill instanceof FillSpec) && MathUtil.r3((dArray = (colorNew = ColorUtil.toCanonicalColor(styleSpec.fill)).getRGBA())[3]).doubleValue() == 0.0) {
            bl = true;
        }
        return bl;
    }

    private static void addFill(Shape shape, StyleSpec styleSpec, ColorNew colorNew) {
        if (styleSpec == null || styleSpec.fill == null) {
            shape.setFill(Fill.makeSolid(colorNew));
        } else if (styleSpec.fill instanceof FillSpec) {
            FillSpec fillSpec = (FillSpec)styleSpec.fill;
            Gradient gradient = Gradient.makeFromSpec(fillSpec, colorNew);
            shape.setFill(Fill.makeGradient(gradient));
        } else {
            ColorNew colorNew2 = ColorUtil.toCanonicalColor(styleSpec.fill);
            shape.setFill(Fill.makeSolid(colorNew2));
        }
        if (styleSpec != null && styleSpec.image != null && shape.isFilled()) {
            shape.setImage(new ImageStyle(styleSpec.image));
        }
    }

    private static void addStroke(Shape shape, StyleSpec styleSpec, boolean bl) {
        if (styleSpec.outline != null) {
            shape.setOutline(ColorUtil.toCanonicalColor(styleSpec.outline));
        } else if (bl) {
            shape.setOutline(ColorUtil.createColor());
        }
        if (styleSpec.stroke != null) {
            shape.setStroke(StyleBuilder.makeStroke(shape, styleSpec.stroke));
        }
    }

    private static Scale getFillSpecScale(StyleSpec styleSpec, Scale[] scaleArray) {
        Scale scale = null;
        FillSpec fillSpec = (FillSpec)styleSpec.fill;
        assert (fillSpec != null);
        String string = fillSpec.type;
        int n = GradientType.getByName(string);
        if (1001 == n) {
            scale = scaleArray[0];
        } else if (1002 == n) {
            scale = scaleArray[1];
        }
        return scale;
    }

    private static void modifyColorStopOffset(StyleSpec styleSpec, Scale scale) {
        FillSpec fillSpec = (FillSpec)styleSpec.fill;
        assert (fillSpec != null);
        assert (scale != null);
        ColorOffsetSpec[] colorOffsetSpecArray = fillSpec.colors;
        for (int i = 0; i < colorOffsetSpecArray.length; ++i) {
            ColorOffsetSpec colorOffsetSpec = colorOffsetSpecArray[i];
            Number number = colorOffsetSpec.offset;
            if (number == null) continue;
            colorOffsetSpec.offset = scale.toZeroOneClamped(number, null);
        }
    }

    public static StyleSpec mergeStyles(StyleSpec styleSpec, StyleSpec styleSpec2) {
        if (styleSpec == null && styleSpec2 == null) {
            return null;
        }
        if (styleSpec == null && styleSpec2 != null) {
            return (StyleSpec)styleSpec2.copy();
        }
        if (styleSpec != null && styleSpec2 == null) {
            return (StyleSpec)styleSpec.copy();
        }
        StyleSpec styleSpec3 = (StyleSpec)styleSpec.copy();
        StyleSpec styleSpec4 = (StyleSpec)styleSpec2.copy();
        StyleSpec styleSpec5 = new StyleSpec();
        styleSpec5.size = styleSpec4.size != null ? styleSpec4.size : styleSpec3.size;
        styleSpec5.outline = styleSpec4.outline != null ? styleSpec4.outline : styleSpec3.outline;
        styleSpec5.alignEdge = styleSpec4.alignEdge != null ? styleSpec4.alignEdge : styleSpec3.alignEdge;
        styleSpec5.fill = styleSpec4.fill != null ? styleSpec4.fill : styleSpec3.fill;
        styleSpec5.outlineMethod = styleSpec4.outlineMethod != null ? styleSpec4.outlineMethod : styleSpec3.outlineMethod;
        styleSpec5.align = styleSpec4.align != null ? styleSpec4.align : styleSpec3.align;
        styleSpec5.width = styleSpec4.width != null ? styleSpec4.width : styleSpec3.width;
        styleSpec5.height = styleSpec4.height != null ? styleSpec4.height : styleSpec3.height;
        styleSpec5.startArrow = styleSpec4.startArrow != null ? styleSpec4.startArrow : styleSpec3.startArrow;
        styleSpec5.cornerRadius = styleSpec4.cornerRadius != null ? styleSpec4.cornerRadius : styleSpec3.cornerRadius;
        styleSpec5.snap = styleSpec4.snap != null ? styleSpec4.snap : styleSpec3.snap;
        styleSpec5.accessibility = styleSpec4.accessibility != null ? styleSpec4.accessibility : styleSpec3.accessibility;
        styleSpec5.endArrow = styleSpec4.endArrow != null ? styleSpec4.endArrow : styleSpec3.endArrow;
        styleSpec5.font = styleSpec4.font != null ? styleSpec4.font : styleSpec3.font;
        styleSpec5.valign = styleSpec4.valign != null ? styleSpec4.valign : styleSpec3.valign;
        styleSpec5.padding = styleSpec4.padding != null ? styleSpec4.padding : styleSpec3.padding;
        styleSpec5.effect = styleSpec4.effect != null ? styleSpec4.effect : styleSpec3.effect;
        styleSpec5.angle = styleSpec4.angle != null ? styleSpec4.angle : styleSpec3.angle;
        styleSpec5.location = styleSpec4.location != null ? styleSpec4.location : styleSpec3.location;
        styleSpec5.symbol = styleSpec4.symbol != null ? styleSpec4.symbol : styleSpec3.symbol;
        styleSpec5.stroke = styleSpec4.stroke != null ? styleSpec4.stroke : styleSpec3.stroke;
        styleSpec5.image = styleSpec4.image != null ? styleSpec4.image : styleSpec3.image;
        return styleSpec5;
    }

    public static StyleSpec mergeStylesForSymbols(StyleSpec styleSpec, StyleSpec styleSpec2) {
        if (styleSpec == null && styleSpec2 == null) {
            return null;
        }
        if (styleSpec == null && styleSpec2 != null) {
            return styleSpec2;
        }
        if (styleSpec != null && styleSpec2 == null) {
            StyleSpec styleSpec3 = styleSpec;
            StyleSpec styleSpec4 = new StyleSpec();
            styleSpec4.size = styleSpec3.size;
            styleSpec4.outline = styleSpec3.outline;
            styleSpec4.fill = styleSpec3.fill;
            styleSpec4.outlineMethod = styleSpec3.outlineMethod;
            styleSpec4.width = styleSpec3.width;
            styleSpec4.height = styleSpec3.height;
            styleSpec4.font = styleSpec3.font;
            styleSpec4.stroke = styleSpec3.stroke;
            return styleSpec4;
        }
        StyleSpec styleSpec5 = styleSpec;
        StyleSpec styleSpec6 = (StyleSpec)styleSpec2.copy();
        styleSpec6.size = styleSpec6.size != null ? styleSpec6.size : styleSpec5.size;
        styleSpec6.outline = styleSpec6.outline != null ? styleSpec6.outline : styleSpec5.outline;
        styleSpec6.fill = styleSpec6.fill != null ? styleSpec6.fill : styleSpec5.fill;
        styleSpec6.outlineMethod = styleSpec6.outlineMethod != null ? styleSpec6.outlineMethod : styleSpec5.outlineMethod;
        styleSpec6.width = styleSpec6.width != null ? styleSpec6.width : styleSpec5.width;
        styleSpec6.height = styleSpec6.height != null ? styleSpec6.height : styleSpec5.height;
        styleSpec6.font = styleSpec6.font != null ? styleSpec6.font : styleSpec5.font;
        styleSpec6.stroke = styleSpec6.stroke != null ? styleSpec6.stroke : styleSpec5.stroke;
        return styleSpec6;
    }

    public static Dim modifySizeByStyle(Dim dim, Dim dim2, StyleSpec styleSpec) {
        Double d;
        double d2 = dim.getWidth();
        double d3 = dim.getHeight();
        if (styleSpec == null) {
            return new Dim(d2, d3);
        }
        Object object = styleSpec.size;
        Object object2 = styleSpec.size;
        if (styleSpec.width != null) {
            object = styleSpec.width;
        }
        if (styleSpec.height != null) {
            object2 = styleSpec.height;
        }
        if ((d = UnitConverter.convertLength(object, d2, dim2 != null ? dim2.getWidth() : d2)) != null) {
            d2 = d;
        }
        if ((d = UnitConverter.convertLength(object2, d3, dim2 != null ? dim2.getHeight() : d2)) != null) {
            d3 = d;
        }
        return new Dim(d2, d3);
    }

    public static boolean isCornerRadiusFixed(StyleSpec styleSpec) {
        boolean bl = styleSpec == null ? true : (BasicFactory.isString(styleSpec.cornerRadius) ? !((String)styleSpec.cornerRadius).endsWith("%") : true);
        return bl;
    }
}

