/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.scene;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SymbolBuilder {
    public static final String SQUARE_NAME = "square";
    public static final String RECT_NAME = "rect";
    public static final String CIRCLE_NAME = "circle";
    public static final String POLY_NAME = "poly";
    public static final String TRIANGLE_NAME = "tri";
    public static final String STAR_NAME = "star";
    public static final String PLUS_NAME = "plus";
    public static final String CROSS_NAME = "cross";
    public static final String IBEAM_NAME = "i-beam";
    public static final String TBEAM_NAME = "t-beam";
    private static final String LETTER_PREFIX = "letter-";
    public static final String LETTER_A_NAME = "letter-A";
    public static final double FONT_ADJUSTMENT = 0.85;

    public static Shape makeSymbol(String string, double d, double d2, double d3, double d4, StyleSpec styleSpec, VisContext visContext) {
        Shape shape;
        double d5 = Math.min(d3, d4) / 2.0;
        StyleSpec styleSpec2 = null;
        if (styleSpec != null && styleSpec.cornerRadius != null) {
            styleSpec2 = new StyleSpec();
            styleSpec2.cornerRadius = styleSpec.cornerRadius;
        }
        if (CIRCLE_NAME.equals(string)) {
            shape = ShapeFactory2.CreateCircle(d, d2, d5);
        } else if (SQUARE_NAME.equals(string)) {
            double d6 = Math.min(d3, d4);
            shape = ItemBuilder.makeRectangle(d - d6 / 2.0, d2 - d6 / 2.0, d6, d6, styleSpec2);
        } else if (string.startsWith(RECT_NAME)) {
            shape = ItemBuilder.makeRectangle(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4, styleSpec2);
        } else if (IBEAM_NAME.equals(string)) {
            shape = SymbolBuilder.buildIBeam(d, d2, d3, d4);
        } else if (TBEAM_NAME.equals(string)) {
            shape = SymbolBuilder.buildTBeam(d, d2, d3, d4);
        } else if (string.startsWith(POLY_NAME)) {
            shape = SymbolBuilder.buildPolygon(d, d2, d5, SymbolBuilder.getSuffixNumber(string));
        } else if (string.startsWith(STAR_NAME)) {
            shape = SymbolBuilder.buildStar(d, d2, d5, SymbolBuilder.getSuffixNumber(string));
        } else if (CROSS_NAME.equals(string)) {
            shape = SymbolBuilder.buildCross(d, d2, d5);
        } else if (PLUS_NAME.equals(string)) {
            shape = SymbolBuilder.buildPlus(d, d2, d5);
        } else if (string.startsWith(TRIANGLE_NAME)) {
            shape = SymbolBuilder.buildTriangle(d, d2, d5);
        } else if (string.startsWith(LETTER_PREFIX)) {
            shape = SymbolBuilder.buildLetter(d, d2, d3, SymbolBuilder.adjustFontHeight(d4), string, styleSpec, visContext);
        } else {
            throw new IllegalStateException("unknown symbol " + string);
        }
        shape.setGlyphLike();
        shape.setActualDim(new Dim(d3, d4));
        shape.setSnap(StyleBuilder.getSnap(styleSpec));
        return shape;
    }

    private static int getSuffixNumber(String string) {
        int n = string.indexOf("-");
        if (n > 0) {
            double d = Double.parseDouble(string.substring(n + 1, string.length()));
            return Math.max(2, Math.min((int)Math.round(d), 16));
        }
        return 5;
    }

    public static void scaleSymbol(Shape shape, String string, double d, double d2) {
        if (SymbolBuilder.isScalable(string)) {
            shape.scale(d / shape.getBounds().getWidth(), d2 / shape.getBounds().getHeight());
        }
    }

    public static double adjustFontHeight(double d) {
        return d * 0.85;
    }

    private static boolean isScalable(String string) {
        return string != null && !TBEAM_NAME.equals(string) && !IBEAM_NAME.equals(string) && !string.startsWith(LETTER_PREFIX);
    }

    private static Shape buildPolygon(double d, double d2, double d3, int n) {
        double d4 = SymbolBuilder.calcHeightAdjust(n);
        if (n == 4) {
            double d5 = d3 * (1.0 + d4) / Math.sqrt(2.0);
            return ItemBuilder.makeRectangle(d - d5, d2 - d5, d5 * 2.0, d5 * 2.0, null);
        }
        if (n % 2 == 1) {
            d2 += 2.0 * d3 * d4;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d7 = (double)i * 2.0 * Math.PI / (double)n;
            if ((double)Math.round((double)n / 2.0) == (double)n / 2.0) {
                d7 -= Math.PI / (double)n;
            }
            dArray[i] = d + d3 * (1.0 + d4) * Math.sin(d7);
            dArray2[i] = d2 - d3 * (1.0 + d4) * Math.cos(d7);
            d6 = Math.max(d6, dArray2[i] - d2);
        }
        return new ShapePoly(dArray, dArray2, true, null);
    }

    private static Shape buildTriangle(double d, double d2, double d3) {
        double d4 = SymbolBuilder.calcHeightAdjust(3);
        double d5 = d2 + 2.0 * d3 * d4;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double d6 = 0.0;
        for (int i = 0; i < 3; ++i) {
            double d7 = (double)i * 2.0 * Math.PI / 3.0;
            if ((double)Math.round(1.5) == 1.5) {
                d7 -= 1.0471975511965976;
            }
            dArray[i] = d + d3 * (1.0 + d4) * Math.sin(d7);
            dArray2[i] = d5 - d3 * (1.0 + d4) * Math.cos(d7);
            d6 = Math.max(d6, dArray2[i] - d5);
        }
        return new ShapePoly(dArray, dArray2, true, null);
    }

    private static double calcHeightAdjust(int n) {
        return 1.0 - Math.cos(Math.PI / (double)n / 2.0);
    }

    private static Shape buildCross(double d, double d2, double d3) {
        double d4 = d3 / 4.0;
        double d5 = (d3 + d4) / Math.sqrt(2.0);
        double d6 = d3 * d3 / d5;
        double[] dArray = new double[12];
        double[] dArray2 = new double[12];
        double d7 = 0.7853981633974483;
        for (int i = 0; i < 12; i += 3) {
            double d8 = Math.cos(d7);
            double d9 = Math.sin(d7);
            dArray[i] = d4;
            dArray2[i] = -d4;
            dArray[i + 1] = d6;
            dArray2[i + 1] = -d4;
            dArray[i + 2] = d6;
            dArray2[i + 2] = d4;
            for (int j = i; j < i + 3; ++j) {
                double d10 = dArray[j];
                double d11 = dArray2[j];
                dArray[j] = d + d8 * d10 - d9 * d11;
                dArray2[j] = d2 + d9 * d10 + d8 * d11;
            }
            d7 += 1.5707963267948966;
        }
        return new ShapePoly(dArray, dArray2, true, null);
    }

    private static Shape buildPlus(double d, double d2, double d3) {
        double d4 = d3 / 4.0;
        double[] dArray = new double[12];
        double[] dArray2 = new double[12];
        double d5 = 0.0;
        for (int i = 0; i < 12; i += 3) {
            double d6 = Math.cos(d5);
            double d7 = Math.sin(d5);
            dArray[i] = d4;
            dArray2[i] = -d4;
            dArray[i + 1] = d3;
            dArray2[i + 1] = -d4;
            dArray[i + 2] = d3;
            dArray2[i + 2] = d4;
            for (int j = i; j < i + 3; ++j) {
                double d8 = dArray[j];
                double d9 = dArray2[j];
                dArray[j] = d + d6 * d8 - d7 * d9;
                dArray2[j] = d2 + d7 * d8 + d6 * d9;
            }
            d5 += 1.5707963267948966;
        }
        return new ShapePoly(dArray, dArray2, true, null);
    }

    private static Shape buildStar(double d, double d2, double d3, int n) {
        double d4 = SymbolBuilder.calcHeightAdjust(n);
        double d5 = d2;
        if (n % 2 == 1) {
            d5 += 2.0 * d3 * d4;
        }
        double[] dArray = new double[2 * n];
        double[] dArray2 = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            double d6 = (double)(i * 2) * Math.PI / (double)n;
            if ((double)Math.round((double)n / 2.0) == (double)n / 2.0) {
                d6 -= Math.PI / (double)n;
            }
            double d7 = d6 + Math.PI / (double)n;
            dArray[2 * i] = d + d3 * (1.0 + d4) * Math.sin(d6);
            dArray2[2 * i] = d5 - d3 * (1.0 + d4) * Math.cos(d6);
            dArray[2 * i + 1] = d + (1.0 + d4) * d3 / 2.5 * Math.sin(d7);
            dArray2[2 * i + 1] = d5 - (1.0 + d4) * d3 / 2.5 * Math.cos(d7);
        }
        return new ShapePoly(dArray, dArray2, true, null);
    }

    private static Shape buildIBeam(double d, double d2, double d3, double d4) {
        double d5 = d - d3 / 2.0;
        double d6 = d2 - d4 / 2.0;
        double d7 = d5 + d3;
        double d8 = d6 + d4;
        double[] dArray = new double[]{d5, d7, d, d, d5, d7};
        double[] dArray2 = new double[]{d6, d6, d6, d8, d8, d8};
        char[] cArray = new char[]{'M', 'L', 'M', 'L', 'M', 'L'};
        Path path = new Path(dArray, dArray2, false, cArray);
        path.setSymbol(IBEAM_NAME);
        path.setUseBoundsForLabel(true);
        return path;
    }

    private static Shape buildTBeam(double d, double d2, double d3, double d4) {
        boolean bl = d4 < 0.0;
        double d5 = d4;
        if (bl) {
            d5 = -d5;
        }
        double d6 = d - d3 / 2.0;
        double d7 = d2 - d5 / 2.0;
        double d8 = d6 + d3;
        double d9 = d7 + d5;
        char[] cArray = new char[]{'M', 'L', 'M', 'L'};
        double[] dArray = new double[]{d6, d8, d, d};
        double[] dArray2 = bl ? new double[]{d9, d9, d9, d7} : new double[]{d7, d7, d7, d9};
        Path path = new Path(dArray, dArray2, false, cArray);
        path.setSymbol(TBEAM_NAME);
        path.setUseBoundsForLabel(true);
        return path;
    }

    private static Shape buildLetter(double d, double d2, double d3, double d4, String string, StyleSpec styleSpec, VisContext visContext) {
        String string2 = string.substring(LETTER_PREFIX.length());
        if (string2.length() < 1) {
            throw new SpecException("Letter symbols must have a letter after 'letter-'", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        FontSpec fontSpec = styleSpec != null && styleSpec.font != null ? styleSpec.font : new FontSpec();
        if (fontSpec.size == null) {
            fontSpec.size = d4;
            fontSpec.setCachedObject(null);
        }
        Font font = FontHelper.makeFromSpec(fontSpec, visContext.getMinimumFontSize(), visContext.usesFractionalMetrics());
        return Text.createTextWithShapedValue(string2, d, d2, "middle", "middle", font, styleSpec, null, null, new Dim(d3, d4), visContext.getTooltipsForTruncatedText());
    }
}

