/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.scenemodifier;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Alignment;
import com.ibm.vis.engine.internal.ImageStyle;
import com.ibm.vis.engine.internal.image.ImageFill;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scenemodifier.SceneModifier;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Point;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class MirrorSceneModifier
extends SceneModifier {
    private double width = 0.0;

    public void setWidth(double d) {
        this.width = d;
    }

    @Override
    public void modifyScene(SceneTree sceneTree) {
        if (sceneTree == null) {
            return;
        }
        for (SceneNode sceneNode : sceneTree.getRoot().getChildren()) {
            this.applyTopLevelMirrorTransform(sceneNode);
            this.unMirrorItems(sceneNode);
        }
    }

    private void applyTopLevelMirrorTransform(SceneNode sceneNode) {
        TransformInfoImpl transformInfoImpl = (TransformInfoImpl)sceneNode.getTransform();
        Affine affine = transformInfoImpl.getAffine();
        if (affine == null) {
            double d = MathUtil.r3(this.width).doubleValue();
            double d2 = -1.0;
            transformInfoImpl.setAffine(new Affine(d2, 0.0, d, 0.0, 1.0, 0.0));
        } else {
            double d = MathUtil.r3(this.width - affine.m02).doubleValue();
            double d3 = -1.0 * affine.m00;
            transformInfoImpl.setAffine(new Affine(d3, affine.m01, d, affine.m10, affine.m11, affine.m12));
        }
    }

    private void unMirrorItems(SceneNode sceneNode) {
        List<SceneNode> list;
        SceneNodeType sceneNodeType = sceneNode.getType();
        Shape shape = (Shape)sceneNode.getShape();
        if (SceneNodeType.MULTI_TEXT_LINE != sceneNodeType) {
            list = sceneNode.getChildren();
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    this.unMirrorItems(((CompositeSceneNode)sceneNode).getChild(i));
                }
            }
        } else {
            list = (TransformInfoImpl)sceneNode.getTransform();
            ((TransformInfoImpl)((Object)list)).mirror();
            double d = shape == null ? 0.0 : shape.getBounds().getX();
            double d2 = shape == null ? 0.0 : shape.getBounds().getWidth();
            ((TransformInfoImpl)((Object)list)).translate(MathUtil.r3(2.0 * d + d2).doubleValue(), 0.0);
        }
        if (shape != null) {
            int n = shape.getType();
            if (1009 == n) {
                Object object;
                String string = shape.getTextInfo().getTextAlign();
                if (string != null) {
                    object = (Text)shape.getTextInfo();
                    ((Text)object).setAlign(Alignment.getReverseAlignment(string));
                }
                object = (TransformInfoImpl)sceneNode.getTransform();
                ((TransformInfoImpl)object).mirror();
                Point point = ((Text)shape).getPoint();
                point.setX(-point.getX());
                ((Text)shape).setPoint(point);
            } else if (shape.getImage() != null) {
                this.unmirrorImage(shape);
            }
        }
    }

    private void unmirrorImage(Shape shape) {
        ImageStyle imageStyle = shape.getImage();
        ImageFill imageFill = imageStyle.getImageFill();
        TransformInfoImpl transformInfoImpl = imageFill.getTransformInfo();
        transformInfoImpl.mirror();
        double d = imageFill.getX();
        double d2 = imageStyle.getWidth();
        transformInfoImpl.translate(MathUtil.r3(2.0 * d + d2).doubleValue(), 0.0);
    }
}

