/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.scenemodifier;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scenemodifier.SceneModifier;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneTree;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisibilitySceneModifier
extends SceneModifier {
    private static final String VISIBLE_FLAG = "visible";
    private static final String CHILDREN = "children";

    @Override
    public void modifyScene(SceneTree sceneTree) {
        if (sceneTree == null) {
            return;
        }
        for (int i = 0; i < sceneTree.getRoot().getChildrenCount(); ++i) {
            SceneNode sceneNode = sceneTree.getRoot().getChild(i);
            SceneNodeType sceneNodeType = sceneNode.getType();
            if (sceneNodeType != SceneNodeType.ELEMENT && sceneNodeType != SceneNodeType.LEGEND) continue;
            VisibilitySceneModifier.hideNonVisibleChildren(sceneNode);
        }
    }

    private static void hideNonVisibleChildren(SceneNode sceneNode) {
        List<SceneNode> list = sceneNode.getChildren();
        if (list != null && list.size() != 0) {
            for (int i = list.size() - 1; i >= 0; --i) {
                SceneNode sceneNode2 = ((CompositeSceneNode)sceneNode).getChild(i);
                if (!sceneNode2.isVisible()) {
                    ((CompositeSceneNode)sceneNode).removeChild(sceneNode2);
                    continue;
                }
                VisibilitySceneModifier.hideNonVisibleChildren(sceneNode2);
            }
        }
    }
}

