/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.spechelper;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.spechelper.ClusterGapSizeSpecHelper;
import com.ibm.vis.engine.internal.spechelper.ClusterWidthSizeSpecHelper;
import com.ibm.vis.engine.internal.spechelper.SpecHelper;
import com.ibm.vis.spec.internal.CategoryStructureSpec;
import com.ibm.vis.spec.internal.PreferredSizeSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CategoryStructureSpecHelper
extends SpecHelper {
    public final CategoryStructureSpec spec;

    public CategoryStructureSpecHelper(CategoryStructureSpec categoryStructureSpec) {
        super(categoryStructureSpec);
        if (categoryStructureSpec == null) {
            categoryStructureSpec = new CategoryStructureSpec();
        }
        this.spec = categoryStructureSpec;
    }

    private final boolean hasGap() {
        return this.spec.gap != null;
    }

    public ClusterGapSizeSpecHelper getGap() {
        PreferredSizeSpec preferredSizeSpec = this.createPreferredSpec(this.spec.gap);
        return new ClusterGapSizeSpecHelper(preferredSizeSpec);
    }

    public ClusterWidthSizeSpecHelper getWidth() {
        PreferredSizeSpec preferredSizeSpec = this.createPreferredSpec(this.spec.width);
        return new ClusterWidthSizeSpecHelper(preferredSizeSpec);
    }

    private PreferredSizeSpec createPreferredSpec(Object object) {
        PreferredSizeSpec preferredSizeSpec = null;
        if (BasicFactory.isString(object) || BasicFactory.isNumber(object)) {
            preferredSizeSpec = new PreferredSizeSpec();
            preferredSizeSpec.preferred = object;
        } else {
            preferredSizeSpec = (PreferredSizeSpec)object;
        }
        return preferredSizeSpec;
    }

    public final boolean getNest() {
        return this.spec.nest;
    }

    public final boolean isNested() {
        return this.spec.nest != null && this.spec.nest == true;
    }

    public final String getAlign() {
        return this.spec.align;
    }

    public final CategoryStructureSpec getSpec() {
        return this.spec;
    }

    @Override
    public final boolean isSpecDefined() {
        return this.specDefined;
    }
}

