/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.spechelper;

import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.spechelper.SpecHelper;
import com.ibm.vis.spec.internal.PreferredSizeSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PreferredSizeSpecHelper
extends SpecHelper {
    private final PreferredSizeSpec spec;

    public PreferredSizeSpecHelper(PreferredSizeSpec preferredSizeSpec) {
        super(preferredSizeSpec);
        if (preferredSizeSpec == null) {
            preferredSizeSpec = new PreferredSizeSpec();
        }
        this.spec = preferredSizeSpec;
    }

    public double getPreferred(double d, double d2) {
        Double d3 = UnitConverter.convertLength(this.spec, d, d2);
        if (d3 == null) {
            return Double.NaN;
        }
        return d3;
    }

    public double getMin(double d, double d2) {
        Double d3 = UnitConverter.convertLength(this.spec.min, d, d2);
        if (d3 == null) {
            return Double.NaN;
        }
        return d3;
    }

    public double getMax(double d, double d2) {
        Double d3 = UnitConverter.convertLength(this.spec.max, d, d2);
        if (d3 == null) {
            return Double.NaN;
        }
        return d3;
    }

    public PreferredSizeSpec getSpec() {
        return this.spec;
    }

    @Override
    public boolean isSpecDefined() {
        return this.specDefined && (this.spec.preferred != null || this.spec.min != null || this.spec.max != null);
    }
}

