/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.ArrowType;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ArrowGeom {
    private ArrowType type;
    private double size = 0.0;
    private double tipSize = 0.0;
    private double x = 0.0;
    private double y = 0.0;
    private double angle = 0.0;

    public ArrowGeom(ArrowType arrowType) {
        this.type = arrowType;
    }

    public void configForStrokeWidth(Stroke stroke) {
        double d = stroke == null ? 1.0 : stroke.getWidth();
        this.setSize(Math.max(d * 3.0, 8.0));
        this.setTipSize((d /= 2.0) * this.type.getMiterFactor());
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setPos(double d, double d2) {
        this.setX(d);
        this.setY(d2);
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getTipSize() {
        return this.tipSize;
    }

    private void setTipSize(double d) {
        this.tipSize = d;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getSize() {
        return this.size;
    }

    private void setSize(double d) {
        this.size = d;
    }

    public double getLength() {
        return this.type.getLength() * this.size + this.tipSize;
    }
}

