/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.ArrowGeom;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Point;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ArrowType {
    private String name;
    private final boolean filled;
    private final double[] x;
    private final double[] y;
    private final char[] t;
    private final double length;
    private final double miterFactor;
    public static String NONE = "none";
    public static String ARROW = "arrow";
    public static String ARROW_CLOSED = "closedArrow";
    public static String ARROW_FILLED = "filledArrow";
    public static String DIAMOND = "diamond";
    public static String DIAMOND_FILLED = "filledDiamond";
    public static String SQUARE = "square";
    public static String SQUARE_FILLED = "filledSquare";
    public static String CIRCLE = "circle";
    public static String CIRCLE_FILLED = "filledCircle";
    private static HashMap<String, ArrowType> arrows = new HashMap();
    private static double[] CIRCLE_XCOORDS = new double[]{1.0, 0.983, 0.933, 0.854, 0.75, 0.629, 0.5, 0.371, 0.25, 0.146, 0.067, 0.017, 0.0, 0.017, 0.067, 0.146, 0.25, 0.371, 0.5, 0.629, 0.75, 0.854, 0.933, 0.983, 0.0};
    private static double[] CIRCLE_YCOORDS = new double[]{0.0, 0.129, 0.25, 0.354, 0.433, 0.483, 0.5, 0.483, 0.433, 0.354, 0.25, 0.129, 0.0, -0.129, -0.25, -0.354, -0.433, -0.483, -0.5, -0.483, -0.433, -0.354, -0.25, -0.129, 0.0};
    private static char[] CIRCLE_TYPES = new char[]{'M', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'Z'};
    public static ArrowType[] ArrowTypes = new ArrowType[]{ArrowType.makeArrowType(ARROW, 2.0, false, 0.9, new double[]{0.86, 0.0, 0.86, 0.0, 0.92}, new double[]{0.5, 0.0, -0.5, 0.0, 0.0}, new char[]{'M', 'L', 'L', 'M', 'L'}), ArrowType.makeArrowType(ARROW_CLOSED, 2.0, false, 0.86, new double[]{0.86, 0.0, 0.86, 0.0}, new double[]{0.5, 0.0, -0.5, 0.0}, new char[]{'M', 'L', 'L', 'Z'}), ArrowType.makeArrowType(ARROW_FILLED, 2.0, true, 0.86, new double[]{0.86, 0.0, 0.86, 0.0}, new double[]{0.5, 0.0, -0.5, 0.0}, new char[]{'M', 'L', 'L', 'Z'}), ArrowType.makeArrowType(DIAMOND, 1.4, false, 1.0, new double[]{0.5, 0.0, 0.5, 1.0, 0.0}, new double[]{0.5, 0.0, -0.5, 0.0, 0.0}, new char[]{'M', 'L', 'L', 'L', 'Z'}), ArrowType.makeArrowType(DIAMOND_FILLED, 1.4, true, 1.0, new double[]{0.5, 0.0, 0.5, 1.0, 0.0}, new double[]{0.5, 0.0, -0.5, 0.0, 0.0}, new char[]{'M', 'L', 'L', 'L', 'Z'}), ArrowType.makeArrowType(SQUARE, 1.0, false, 1.0, new double[]{0.0, 0.0, 1.0, 1.0, 0.0}, new double[]{0.5, -0.5, -0.5, 0.5, 0.0}, new char[]{'M', 'L', 'L', 'L', 'Z'}), ArrowType.makeArrowType(SQUARE_FILLED, 1.0, true, 1.0, new double[]{0.0, 0.0, 1.0, 1.0, 0.0}, new double[]{0.5, -0.5, -0.5, 0.5, 0.0}, new char[]{'M', 'L', 'L', 'L', 'Z'}), ArrowType.makeArrowType(CIRCLE, 1.0, false, 1.0, CIRCLE_XCOORDS, CIRCLE_YCOORDS, CIRCLE_TYPES), ArrowType.makeArrowType(CIRCLE_FILLED, 1.0, true, 1.0, CIRCLE_XCOORDS, CIRCLE_YCOORDS, CIRCLE_TYPES)};

    private static ArrowType makeArrowType(String string, double d, boolean bl, double d2, double[] dArray, double[] dArray2, char[] cArray) {
        return new ArrowType(string, d2, d, bl, dArray, dArray2, cArray);
    }

    public static ArrowType byName(String string) {
        return arrows.get(string);
    }

    private ArrowType(String string, double d, double d2, boolean bl, double[] dArray, double[] dArray2, char[] cArray) {
        this.miterFactor = d2;
        this.name = string;
        this.x = dArray;
        this.y = dArray2;
        this.t = cArray;
        this.length = d;
        this.filled = bl;
        arrows.put(string, this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public double getLength() {
        return this.length;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public double getMiterFactor() {
        return this.miterFactor;
    }

    protected Path createArrowShape(ArrowGeom arrowGeom, Shape shape) {
        Object object;
        int n = this.x.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        char[] cArray = new char[n];
        Affine affine = Affine.makeRotation(arrowGeom.getAngle(), 0.0, 0.0);
        affine = affine.translate(arrowGeom.getX(), arrowGeom.getY());
        affine = affine.scale(arrowGeom.getSize());
        for (int i = 0; i < n; ++i) {
            object = affine.transform(this.x[i], this.y[i]);
            dArray[i] = ((Point)object).getX();
            dArray2[i] = ((Point)object).getY();
            cArray[i] = this.t[i];
        }
        Path path = new Path(dArray, dArray2, this.filled, cArray);
        path.copyInfoFrom(shape);
        path.setKey(shape.getKey());
        path.setEdgeProperties(null, null, null, null);
        object = path.getStroke();
        object = object == null ? Stroke.DEFAULT_STROKE : ((Stroke)object).createStrokeWithDashing(null);
        path.setStroke((Stroke)object);
        ColorNew colorNew = ((Stroke)object).getColor();
        if (colorNew == null) {
            colorNew = shape.getOutline();
        }
        if (colorNew == null && shape.getFill() != null) {
            colorNew = shape.getFill().getSolid();
        }
        path.setOutline(colorNew == null ? ColorUtil.getDefaultStrokeColor() : colorNew);
        if (this.filled || shape.isFilled()) {
            path.setFill(Fill.createFill(colorNew == null ? ColorUtil.getDefaultFillColor() : colorNew, null));
        }
        return path;
    }
}

