/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Bezier {
    private static final double K_TOLERANCE = 1.0E-6;

    public static double[] quadRoots(double d, double d2, double d3) {
        double d4 = Math.pow(d2, 2.0) - 4.0 * d * d3;
        double[] dArray = new double[2];
        if (d4 > 1.0E-6 && Math.abs(d2) > 1.0E-6) {
            int n = d2 > 0.0 ? 1 : -1;
            double d5 = -0.5 * (d2 + (double)n * Math.sqrt(d4));
            dArray[0] = d5 / d;
            dArray[1] = d3 / d5;
        } else if (Math.abs(d4) <= 1.0E-6) {
            dArray[0] = -d2 / 2.0 * d;
            dArray[1] = Double.POSITIVE_INFINITY;
        } else if (Math.abs(d2) <= 1.0E-6 && -d3 / d > 0.0) {
            dArray[0] = Math.sqrt(-d3 / d);
            dArray[1] = -Math.sqrt(-d3 / d);
        }
        return dArray;
    }
}

