/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.PaddingSpec;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Insets {
    public static final Insets NONE = new Insets(0.0, 0.0, 0.0, 0.0);
    public double top;
    public double left;
    public double bottom;
    public double right;

    public static Insets makeForStylePadding(Object object, Dim dim, Dim dim2) {
        if (object == null) {
            return NONE;
        }
        if (BasicFactory.isNumber(object) || BasicFactory.isString(object)) {
            Double d = UnitConverter.convertLength(object, dim.getWidth(), dim2.getWidth());
            Double d2 = UnitConverter.convertLength(object, dim.getHeight(), dim2.getHeight());
            return Insets.makeInsets(d2, d, d2, d);
        }
        if (object instanceof PaddingSpec) {
            PaddingSpec paddingSpec = (PaddingSpec)object;
            return Insets.makeInsets(UnitConverter.convertLength(paddingSpec.top, dim.getHeight(), dim2.getHeight()), UnitConverter.convertLength(paddingSpec.left, dim.getWidth(), dim2.getWidth()), UnitConverter.convertLength(paddingSpec.bottom, dim.getHeight(), dim2.getHeight()), UnitConverter.convertLength(paddingSpec.right, dim.getWidth(), dim2.getWidth()));
        }
        return NONE;
    }

    private static Insets makeInsets(Double d, Double d2, Double d3, Double d4) {
        return new Insets(d == null ? 0.0 : d, d2 == null ? 0.0 : d2, d3 == null ? 0.0 : d3, d4 == null ? 0.0 : d4);
    }

    public Insets(double d, double d2, double d3, double d4) {
        this.top = d;
        this.left = d2;
        this.bottom = d3;
        this.right = d4;
    }

    public double getHorizontal() {
        return this.left + this.right;
    }

    public double getVertical() {
        return this.top + this.bottom;
    }

    public Rect insetRect(Rect rect) {
        return new Rect(rect.getX() + this.left, rect.getY() + this.top, rect.getWidth() - this.left - this.right, rect.getHeight() - this.top - this.bottom);
    }

    public Rect insetRectFromDimension(Dim dim) {
        return new Rect(this.left, this.top, dim.getWidth() - this.getHorizontal(), dim.getHeight() - this.getVertical());
    }

    public static Insets makeForStyleStroke(StrokeSpec strokeSpec, Object object, Dim dim, Dim dim2, String string) {
        if (strokeSpec != null && strokeSpec.width != null) {
            Double d = UnitConverter.convertLength(strokeSpec.width, dim.getHeight(), dim2.getHeight());
            if (d == null) {
                d = 1.0;
            }
            if ("inside".equals(string)) {
                return new Insets(d, d, d, d);
            }
            return new Insets(d / 2.0, d / 2.0, d / 2.0, d / 2.0);
        }
        if (object != null) {
            return new Insets(0.5, 0.5, 0.5, 0.5);
        }
        return NONE;
    }

    public Rect expandRect(Rect rect) {
        return new Rect(rect.getX() - this.left, rect.getY() - this.top, rect.getWidth() + this.getHorizontal(), rect.getHeight() + this.getVertical());
    }

    public Rect insetRectBy(Rect rect) {
        if (this == NONE) {
            return rect;
        }
        return new Rect(rect.getX() + this.left, rect.getY() + this.top, rect.getWidth() - this.getHorizontal(), rect.getHeight() - this.getVertical());
    }

    public Rect expandRectBy(Rect rect) {
        if (this == NONE) {
            return rect;
        }
        return new Rect(rect.getX() - this.left, rect.getY() - this.top, rect.getWidth() + this.getHorizontal(), rect.getHeight() + this.getVertical());
    }

    public static Insets makeForStyle(StyleSpec styleSpec, Dim dim) {
        Insets insets = Insets.makeForStylePadding(styleSpec.padding, dim, dim);
        Insets insets2 = Insets.makeForStyleStroke(styleSpec.stroke, styleSpec.outline, dim, dim, null);
        return Insets.combine(insets, insets2);
    }

    public static Insets combine(Insets insets, Insets insets2) {
        return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
    }

    public static Insets makeUniform(double d) {
        return new Insets(d, d, d, d);
    }
}

