/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.label.TextContentPart;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.struct.MultiPartTextLine;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.spec.internal.PaddingSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class MultiPartText
extends Text {
    private static final String NEWLINE = "\n";
    private static final String SPACE = " ";
    private ArrayList<MultiPartTextLine> lines;
    private boolean clip;

    protected MultiPartText(TextContent textContent, double d, double d2, String string, String string2, Font font, StyleSpec styleSpec, StyleSpec styleSpec2, String string3, Dim dim, boolean bl, boolean bl2) {
        super(textContent, d, d2, string, string2, font, styleSpec, styleSpec2, string3, dim, bl);
        assert (dim != null);
        this.lines = new ArrayList();
        this.clip = bl2;
        this.makeParts(bl2);
        this.updateContent();
        this.createTooltipForTruncated = bl;
    }

    @Override
    public SceneNodeImpl createSceneNode() {
        Shape[] shapeArray;
        this.prepareTruncatedTooltipText();
        if (this.lines.size() == 1 && (shapeArray = this.lines.get(0).getParts()).length == 1 && shapeArray[0].getType() == 1009) {
            Text text = (Text)shapeArray[0];
            text.setID(this.getID());
            text.setKey(this.getKey());
            text.setUsesBackgroundPlaque(this.getUsesBackgroundPlaque());
            text.setBackgroundStyle(this.getBackgroundStyle());
            SceneNodeImpl sceneNodeImpl = text.createSceneNode();
            sceneNodeImpl.setTransform(this.getTransformInfo());
            return sceneNodeImpl;
        }
        shapeArray = (Shape[])SceneNodeFactory.createShapeNode(this);
        for (MultiPartTextLine multiPartTextLine : this.getLines()) {
            SceneNodeImpl sceneNodeImpl = multiPartTextLine.createSceneNode();
            shapeArray.addChild(sceneNodeImpl);
        }
        return this.createSceneNodeBackgroundPlaque((SceneNodeImpl)shapeArray);
    }

    public static MultiPartText createMultiPartTextWithShapedValue(TextContent textContent, double d, double d2, String string, String string2, Font font, StyleSpec styleSpec, StyleSpec styleSpec2, String string3, Dim dim, boolean bl, boolean bl2) {
        return new MultiPartText(textContent, d, d2, string, string2, font, styleSpec, styleSpec2, string3, dim, bl2, bl);
    }

    @Override
    public void prepareTruncatedTooltipText() {
        if (this.createTooltipForTruncated && !this.tooltipDisabled && this.anyPartClipped()) {
            this.setTruncatedTooltipText(this.originalText);
        }
    }

    private boolean anyPartClipped() {
        if (this.wasClipped) {
            return true;
        }
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            if (multiPartTextLine.wasClipped) {
                return true;
            }
            for (Shape shape : multiPartTextLine.parts) {
                if (!(shape instanceof Text) || !((Text)shape).wasClipped) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    void setTruncatedTooltipText(String string) {
        if (!this.tooltipDisabled) {
            this.truncatedTooltipText = string;
            for (MultiPartTextLine multiPartTextLine : this.lines) {
                multiPartTextLine.setTruncatedTooltipText(string);
            }
        }
    }

    @Override
    public void setField(String string) {
        super.setField(string);
        for (Shape shape : this.lines) {
            shape.setField(string);
        }
    }

    @Override
    public void setValue(Object object) {
        super.setValue(object);
        for (Shape shape : this.lines) {
            shape.setValue(object);
        }
    }

    @Override
    public void disableTooltip() {
        super.disableTooltip();
        for (Shape shape : this.lines) {
            if (!(shape instanceof Text)) continue;
            Text text = (Text)shape;
            text.disableTooltip();
        }
    }

    @Override
    public void buildParts(Dim dim) {
        this.size = dim;
        this.makeParts(this.clip);
    }

    @Override
    public int getNumLines() {
        return this.lines.size();
    }

    @Override
    public double getWidth() {
        return this.size.getWidth();
    }

    @Override
    public int getType() {
        return 1007;
    }

    @Override
    public double getHeight() {
        double d = 0.0;
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            d += multiPartTextLine.getHeight();
        }
        return d;
    }

    @Override
    public double calculateTextWidth() {
        double d = 0.0;
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            d = Math.max(multiPartTextLine.getWidth(), d);
        }
        return d;
    }

    @Override
    public void modifyFontSize(double d) {
        this.resetCachedBounds();
        this.font = this.font.modifySize(d);
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            multiPartTextLine.modifyFontSize(d);
        }
    }

    protected void updateContent() {
        if (this.font != null) {
            this.content = new TextContent(this.font.getMinimumSize());
            if (this.lines.size() > 0) {
                for (int i = 0; i < this.lines.size(); ++i) {
                    MultiPartTextLine multiPartTextLine = this.lines.get(i);
                    for (Shape shape : multiPartTextLine.getParts()) {
                        if (MultiPartTextLine.isTextType(shape)) {
                            Text text = (Text)shape;
                            TextContentPart textContentPart = new TextContentPart(text.text, text.style, this.font.getMinimumSize());
                            textContentPart.setFont(text.font);
                            textContentPart.setSourceShape(text);
                            this.content.addPart(textContentPart);
                            continue;
                        }
                        this.content.addShape(shape);
                    }
                    if (i < this.lines.size() - 1) {
                        this.content.addString(NEWLINE, null);
                    }
                    this.text = i == 0 ? multiPartTextLine.text : this.text + NEWLINE + multiPartTextLine.text;
                }
            }
        }
    }

    private void clearForNumericalClipping() {
        Object object;
        this.resetCachedBounds();
        this.lines.clear();
        double d = 0.0;
        String string = "###";
        if (this.style != null && this.style.padding != null) {
            if (BasicFactory.isNumber(this.style.padding)) {
                object = (Number)this.style.padding;
                d = ((Number)object).doubleValue();
            } else {
                try {
                    object = (PaddingSpec)this.style.padding;
                    d = UnitConverter.convertLength(((PaddingSpec)object).top, 1.0, 1.0);
                }
                catch (Exception exception) {
                    d = 0.0;
                }
            }
        }
        object = new MultiPartTextLine(TextContent.makeForString(string, this.font.getMinimumSize()), this.p.getX(), d, this.align, "end", this.font, this.style, this.backgroundStyle, this.clipSymbol, this.size, this.clip);
        ((MultiPartTextLine)object).tickLabelOrientation = this.tickLabelOrientation;
        Text text = Text.createTextWithShapedValue(string, this.p.getX(), d, this.align, "end", this.font, this.style, this.backgroundStyle, this.clipSymbol, this.size, this.createTooltipForTruncated);
        text.clipToFit(this.size.getWidth());
        this.text = text.text;
        ((MultiPartTextLine)object).addPart(text);
        ((MultiPartTextLine)object).updateContent();
        this.lines.add((MultiPartTextLine)object);
    }

    private void makeParts(boolean bl) {
        this.resetCachedBounds();
        this.lines = new ArrayList();
        ArrayList<MultiPartTextLine> arrayList = new ArrayList<MultiPartTextLine>();
        this.splitLines(this.targetContent(), 0.0, arrayList, bl);
        for (MultiPartTextLine multiPartTextLine : arrayList) {
            this.wasClipped = multiPartTextLine.wasClipped ? true : this.wasClipped;
            multiPartTextLine.copyInfoFrom(this);
            this.lines.add(multiPartTextLine);
        }
        if (this.wasClipped && this.clipSymbol.equals("#")) {
            this.clearForNumericalClipping();
        }
        if (this.getID() != null) {
            this.setID(this.getID());
        }
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            multiPartTextLine.offsetX();
            multiPartTextLine.offsetY(this.getTextBounds().getY());
        }
    }

    @Override
    public boolean isReductionNeeded(TextContent textContent) {
        this.resetCachedBounds();
        this.lines = new ArrayList();
        ArrayList<MultiPartTextLine> arrayList = new ArrayList<MultiPartTextLine>();
        ArrayList<TextContentPart> arrayList2 = new ArrayList<TextContentPart>();
        for (TextContentPart object : textContent.getContent()) {
            arrayList2.add(object);
        }
        this.splitLines(arrayList2, 0.0, arrayList, true);
        for (MultiPartTextLine multiPartTextLine : arrayList) {
            this.wasClipped = multiPartTextLine.wasClipped ? true : this.wasClipped;
            multiPartTextLine.copyInfoFrom(this);
            this.lines.add(multiPartTextLine);
        }
        return this.wasClipped;
    }

    private ArrayList<TextContentPart> targetContent() {
        ArrayList<TextContentPart> arrayList = new ArrayList<TextContentPart>();
        ArrayList<TextContentPart> arrayList2 = this.content.getContent();
        if (arrayList2 != null) {
            for (TextContentPart textContentPart : arrayList2) {
                arrayList.add(textContentPart);
            }
        }
        return arrayList;
    }

    private void splitLines(ArrayList<TextContentPart> arrayList, double d, ArrayList<MultiPartTextLine> arrayList2, boolean bl) {
        double d2 = d;
        this.resetCachedBounds();
        ArrayList<TextContentPart> arrayList3 = new ArrayList<TextContentPart>();
        while (arrayList.size() > 0) {
            double d3 = this.size.getWidth();
            MultiPartTextLine multiPartTextLine = new MultiPartTextLine(new TextContent(this.font.getMinimumSize()), this.p.getX(), d2, this.align, "end", this.font, this.style, this.backgroundStyle, this.clipSymbol, this.size, this.clip);
            multiPartTextLine.tickLabelOrientation = this.tickLabelOrientation;
            boolean bl2 = true;
            for (int i = 0; i < arrayList.size() && bl2; ++i) {
                TextContentPart textContentPart = arrayList.get(i);
                if (textContentPart.getValue() == null) {
                    arrayList3.add(textContentPart);
                }
                if (BasicFactory.isString(textContentPart.getValue())) {
                    int n = multiPartTextLine.getNumParts();
                    bl2 = this.splitLinesForString(textContentPart, multiPartTextLine, arrayList3, d2, d3, arrayList, i, bl);
                    if (n >= multiPartTextLine.getNumParts()) continue;
                    d3 -= ((Text)multiPartTextLine.getParts()[n]).getWidth();
                    continue;
                }
                if (!(textContentPart.getValue() instanceof Shape)) continue;
                this.splitLinesForShape(textContentPart, multiPartTextLine, arrayList3, d2, d3 -= ((Shape)textContentPart.getValue()).getBounds().getWidth(), arrayList2, i == 0);
                if (!(d3 < 0.0) || i != 0) continue;
                this.wasClipped = true;
                return;
            }
            for (TextContentPart textContentPart : arrayList3) {
                arrayList.remove(textContentPart);
            }
            if (d2 + multiPartTextLine.getHeight() > this.size.getHeight() && bl) {
                if (arrayList2.size() > 0) {
                    this.clipLastLine(arrayList2, d2);
                }
                arrayList.clear();
            } else if (multiPartTextLine.getNumParts() > 0) {
                multiPartTextLine.updateContent();
                arrayList2.add(multiPartTextLine);
            }
            d2 += multiPartTextLine.getHeight();
        }
    }

    private void clipLastLine(ArrayList<MultiPartTextLine> arrayList, double d) {
        int n = arrayList.size() - 1;
        MultiPartTextLine multiPartTextLine = arrayList.get(n);
        arrayList.set(n, this.clipLine(multiPartTextLine, d - multiPartTextLine.getHeight()));
    }

    private static String trimLine(String string, int n, int n2) {
        String string2 = string;
        if (string2.equals("\r")) {
            return "";
        }
        if (!SPACE.equals(string2)) {
            if (n == 0 && !string.equals("") && string.charAt(n) == ' ') {
                string2 = string.replaceAll("^\\s+", "");
            } else if (n == n2 - 1) {
                string2 = string.replaceAll("\\s+$", "");
            }
        }
        return string2;
    }

    private boolean splitLinesForString(TextContentPart textContentPart, MultiPartTextLine multiPartTextLine, ArrayList<TextContentPart> arrayList, double d, double d2, ArrayList<TextContentPart> arrayList2, int n, boolean bl) {
        Font font;
        String[] stringArray;
        String string = (String)textContentPart.getValue();
        String string2 = "";
        int n2 = string.indexOf(NEWLINE);
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1);
            string = string.substring(0, n2);
        }
        if ((stringArray = this.splitString(string = MultiPartText.trimLine(string, n, arrayList2.size()), d2, d, bl, font = textContentPart.getFont() == null ? this.font : textContentPart.getFont())) == null && n == 0) {
            arrayList2.clear();
            return false;
        }
        if ((stringArray == null || stringArray[0].indexOf(this.clipSymbol) > 0) && n > 0) {
            return false;
        }
        string = stringArray[0];
        string2 = stringArray[1].length() > 0 && n2 > 0 ? stringArray[1] + NEWLINE + string2 : stringArray[1] + string2;
        if (n == 0 || string.length() > 0) {
            Text text = this.createTextPart(string, d, textContentPart);
            multiPartTextLine.addPart(text);
        }
        if (string2.length() > 0) {
            arrayList2.set(n, new TextContentPart(string2, textContentPart.getStyle(), this.font.getMinimumSize()));
            return false;
        }
        arrayList.add(textContentPart);
        if (n2 >= 0) {
            if (arrayList2.size() == 1) {
                arrayList.clear();
                arrayList2.set(n, new TextContentPart(string2, textContentPart.getStyle(), this.font.getMinimumSize()));
            }
            return false;
        }
        return true;
    }

    private void splitLinesForShape(TextContentPart textContentPart, MultiPartTextLine multiPartTextLine, ArrayList<TextContentPart> arrayList, double d, double d2, ArrayList<MultiPartTextLine> arrayList2, boolean bl) {
        Shape shape = (Shape)textContentPart.getValue();
        if (d2 < 0.0) {
            if (bl && arrayList2.size() > 0) {
                this.clipLastLine(arrayList2, d);
            }
        } else {
            shape.setX(this.p.getX());
            shape.setY(d);
            multiPartTextLine.addPart(shape);
            arrayList.add(textContentPart);
        }
    }

    private Text createTextPart(String string, double d, TextContentPart textContentPart) {
        StyleSpec styleSpec = null;
        Font font = textContentPart.getFont() == null ? this.font : textContentPart.getFont();
        styleSpec = this.style != null ? this.style : new StyleSpec();
        if (textContentPart.getStyle() != null) {
            if (this.style != null) {
                styleSpec = (StyleSpec)this.style.copy();
            }
            styleSpec.fill = textContentPart.getStyle().fill;
        }
        Text text = Text.createTextWithShapedValue(string, this.p.getX(), d, this.align, "end", font, styleSpec, null, this.clipSymbol, this.size, this.createTooltipForTruncated);
        if (textContentPart.getSourceShape() != null) {
            text.copyInfoFrom(textContentPart.getSourceShape());
            textContentPart.setSourceShape(null);
        }
        if (this.wasClipped) {
            text.wasClipped = true;
        }
        return text;
    }

    private String[] splitString(String string, double d, double d2, boolean bl, Font font) {
        boolean bl2 = this.clipSymbol.equals("\u2026");
        if (string.length() == 0) {
            return new String[]{"", ""};
        }
        int n = font.getAmountThatFits(string, d);
        if (n == 0 && string.length() > 0) {
            return null;
        }
        String string2 = string;
        String string3 = "";
        if (n < string.length()) {
            int n2;
            string2 = string.substring(0, n);
            boolean bl3 = false;
            for (n2 = n - 1; n2 > 0; --n2) {
                if (!BasicFactory.isWhitespace(string2.charAt(n2))) continue;
                n = n2;
                bl3 = true;
                break;
            }
            if (!bl3 && BasicFactory.isWhitespace(string.charAt(n))) {
                bl3 = true;
            }
            string2 = string.substring(0, n);
            string3 = string.substring(n);
            if (!bl3 && bl) {
                n2 = 0;
                if (bl2 && BasicFactory.isPunctuation(string, n - 1)) {
                    n2 = 1;
                } else {
                    Text text = this.clipString(string2 + "...", d, d2, font);
                    string2 = text.text;
                }
                if (n2 == 0 && bl2) {
                    int n3 = string.length();
                    for (int i = n; i < n3; ++i) {
                        if (!BasicFactory.isPunctuation(string, i)) continue;
                        n2 = 1;
                        string3 = string.substring(i + 1);
                        break;
                    }
                }
                if (n2 == 0) {
                    string3 = "";
                }
            } else if (!bl3 && !bl) {
                for (n2 = 0; n2 < string.length(); ++n2) {
                    if (!BasicFactory.isWhitespace(string.charAt(n2))) continue;
                    string2 = string.substring(0, n2);
                    string3 = string.substring(n2);
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    string2 = string;
                    string3 = "";
                }
            }
        }
        if (string3.length() > 0 && d2 + font.getHeight() * 2.0 > this.size.getHeight()) {
            if (bl) {
                Text text = this.clipString(string, d, d2, font);
                text.wasClipped = true;
                string2 = text.text;
                string3 = "";
            } else {
                string2 = string;
                string3 = "";
            }
        }
        return new String[]{string2, string3};
    }

    private MultiPartTextLine clipLine(MultiPartTextLine multiPartTextLine, double d) {
        int n;
        Shape[] shapeArray = multiPartTextLine.getParts();
        Shape shape = shapeArray[n = shapeArray.length - 1];
        if (1009 == shape.getType()) {
            Text text = (Text)shape;
            Text text2 = this.clipString(text.text + "\u2026", this.size.getWidth(), d, text.font);
            multiPartTextLine.setPart(n, text2);
            multiPartTextLine.updateContent();
        } else {
            double d2 = this.size.getWidth() - shape.getWidth();
            if (d2 > 0.0) {
                Text text = this.clipString("\u2026", d2, d, this.font);
                multiPartTextLine.addPart(text);
            }
        }
        return multiPartTextLine;
    }

    private Text clipString(String string, double d, double d2, Font font) {
        Text text = Text.createTextWithShapedValue(string, this.p.getX(), d2, this.align, "end", font, this.style, this.backgroundStyle, this.clipSymbol, this.size, this.createTooltipForTruncated);
        text.clipToFit(d);
        this.wasClipped = true;
        return text;
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, boolean bl) {
        super.affine(d, d2, d3, d4, bl);
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            multiPartTextLine.affine(d, d2, d3, d4, bl);
        }
        this.updateContent();
        this.makeParts(this.clip);
        if (this.isElement()) {
            this.clipTextElement(this.getSize().getWidth());
        }
    }

    public void clipTextElement(double d) {
        if (this.lines.size() > 1) {
            for (int i = this.lines.size() - 1; i > 0; --i) {
                this.lines.remove(i);
            }
            this.lines.get(0).clipToFit(d);
            this.setNodeBounds(new Rect(this.lines.get(0).getP().getX(), this.lines.get(0).getP().getY(), this.lines.get(0).getWidth(), this.lines.get(0).getHeight()));
        } else {
            this.lines.get(0).clipToFit(d);
        }
    }

    @Override
    public void setRows(int[] nArray) {
        super.setRows(nArray);
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            multiPartTextLine.setRows(nArray, this.getKey());
        }
    }

    @Override
    public void setID(String string) {
        super.setID(string);
        for (int i = 0; i < this.lines.size(); ++i) {
            MultiPartTextLine multiPartTextLine = this.lines.get(i);
            multiPartTextLine.setID(string, i);
        }
    }

    @Override
    public void transpose(Dim dim) {
        this.resetCachedBounds();
        super.transpose(dim);
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            multiPartTextLine.transpose(dim);
        }
    }

    @Override
    public Text fitInside(Dim dim) {
        this.resetCachedBounds();
        Dim dim2 = new Dim(dim.getWidth(), dim.getHeight());
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            multiPartTextLine.fitInside(dim2);
            if (multiPartTextLine.wasClipped) {
                this.wasClipped = true;
            }
            dim2.setHeight(dim2.getHeight() - multiPartTextLine.getHeight());
        }
        this.updateContent();
        return this;
    }

    @Override
    public void clipToFit(double d) {
        this.resetCachedBounds();
        for (MultiPartTextLine multiPartTextLine : this.lines) {
            multiPartTextLine.clipToFit(d);
            if (!multiPartTextLine.wasClipped) continue;
            this.wasClipped = true;
        }
        this.updateContent();
    }

    @Override
    public Text stretchToFit(Dim dim) {
        this.resetCachedBounds();
        Text text = null;
        TextContent textContent = new TextContent(this.font.getMinimumSize());
        for (TextContentPart textContentPart : this.content.getContent()) {
            Object object = textContentPart.getValue();
            if (BasicFactory.isString(object)) {
                String string = (String)object;
                textContent.addString(string.replace(NEWLINE, SPACE), textContentPart.getStyle());
                continue;
            }
            textContent.addShape((Shape)object);
        }
        if (!textContent.hasImages()) {
            text = Text.createTextWithShapedValue(textContent.getText(), this.p.getX(), this.p.getY(), this.align, this.valign, this.font, this.style, null, this.clipSymbol, this.size, this.createTooltipForTruncated);
            text.copyInfoFrom(this);
            text.stretchToFit(dim);
        } else {
            this.font = this.font.modifySize(10.0);
            text = MultiPartText.createMultiPartTextWithShapedValue(textContent, this.p.getX(), this.p.getY(), this.align, this.valign, this.font, this.style, null, this.clipSymbol, this.size, false, this.createTooltipForTruncated);
            text.copyInfoFrom(this);
            ((MultiPartText)text).addScaleTransform(dim);
        }
        return text;
    }

    private void addScaleTransform(Dim dim) {
        double d = dim.getWidth() / this.calculateTextWidth();
        double d2 = dim.getHeight() / this.getHeight();
        Affine affine = new Affine(d, 0.0, this.p.getX() * (1.0 - d), 0.0, d2, this.p.getY() * (1.0 - d2));
        for (MultiPartTextLine multiPartTextLine : this.getLines()) {
            multiPartTextLine.updateTransformTextParts(affine);
        }
    }

    @Override
    public Text sizeToFit(Dim dim, boolean bl) {
        double d = this.font.getSize();
        super.sizeToFit(dim, bl);
        if (d != this.font.getSize() && this.getLines().size() > 1) {
            double d2 = this.getTextBounds().getY();
            for (MultiPartTextLine multiPartTextLine : this.getLines()) {
                multiPartTextLine.rePositionParts(d2);
                d2 += multiPartTextLine.getHeight();
            }
        }
        return this;
    }

    public final List<MultiPartTextLine> getLines() {
        return this.lines;
    }

    @Override
    public Shape[] getParts() {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (MultiPartTextLine multiPartTextLine : this.getLines()) {
            for (Shape shape : multiPartTextLine.getParts()) {
                arrayList.add(shape);
            }
        }
        return arrayList.toArray(new Shape[arrayList.size()]);
    }

    @Override
    public void setSizeAestheticValue(Object object) {
        List<MultiPartTextLine> list = this.getLines();
        for (MultiPartTextLine multiPartTextLine : list) {
            Shape[] shapeArray;
            for (Shape shape : shapeArray = multiPartTextLine.getParts()) {
                if (1009 != shape.getType()) continue;
                ((Text)shape).setSizeAestheticValue(object);
            }
        }
    }

    public double getCalculatedOffsetY() {
        return this.getTextBounds().getY() - this.p.getY();
    }

    @Override
    public boolean hasSingleLine() {
        return this.lines != null && this.lines.size() == 1;
    }

    @Override
    public Text getLine(int n) {
        return this.lines.get(n);
    }
}

