/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.ImageStyle;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.label.TextContentPart;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SchemaSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class MultiPartTextLine
extends Text {
    protected ArrayList<Shape> parts = new ArrayList();

    protected MultiPartTextLine(TextContent textContent, double d, double d2, String string, String string2, Font font, StyleSpec styleSpec, StyleSpec styleSpec2, String string3, Dim dim, boolean bl) {
        super(textContent, d, d2, string, string2, font, styleSpec, styleSpec2, string3, dim, false);
    }

    @Override
    public int getType() {
        return 1008;
    }

    @Override
    public SceneNodeImpl createSceneNode() {
        SchemaSceneNode schemaSceneNode = (SchemaSceneNode)SceneNodeFactory.createShapeNode(this);
        for (Shape shape : this.getParts()) {
            Object object;
            if (shape.getType() == 1009) {
                object = shape.createSceneNode();
                schemaSceneNode.addChild((SceneNode)object);
                continue;
            }
            object = new ArrayList();
            ImageStyle.addImageShape(shape, (List<SceneNode>)object);
            String string = shape.getID();
            for (int i = 0; i < object.size(); ++i) {
                SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)object.get(i);
                sceneNodeImpl.setId(string + "_" + i);
                sceneNodeImpl.setField(schemaSceneNode.getField());
                sceneNodeImpl.setValue(schemaSceneNode.getValue());
                if (i == 1) {
                    sceneNodeImpl.setType(SceneNodeType.IMAGE_HIGHLIGHT);
                }
                schemaSceneNode.addChild(sceneNodeImpl);
            }
        }
        return schemaSceneNode;
    }

    @Override
    void setTruncatedTooltipText(String string) {
        this.truncatedTooltipText = null;
        if (!this.tooltipDisabled) {
            for (Shape shape : this.parts) {
                if (!(shape instanceof Text)) continue;
                ((Text)shape).setTruncatedTooltipText(string);
            }
        }
    }

    @Override
    public void disableTooltip() {
        super.disableTooltip();
        for (Shape shape : this.parts) {
            if (!(shape instanceof Text)) continue;
            Text text = (Text)shape;
            text.disableTooltip();
        }
    }

    public void addPart(Shape shape) {
        this.parts.add(shape);
    }

    public void setPart(int n, Shape shape) {
        if (this.parts != null && n >= 0 && n < this.parts.size()) {
            this.parts.set(n, shape);
        }
    }

    @Override
    public Shape[] getParts() {
        return this.parts.toArray(new Shape[this.parts.size()]);
    }

    public int getNumParts() {
        if (this.parts != null) {
            return this.parts.size();
        }
        return 0;
    }

    @Override
    public TextContent getContent() {
        return this.content;
    }

    public Point getP() {
        return this.p;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public boolean isWasClipped() {
        return this.wasClipped;
    }

    @Override
    public String getAlign() {
        return this.align;
    }

    public String getValign() {
        return this.valign;
    }

    public StyleSpec getStyle() {
        return this.style;
    }

    public String getTickLabelOrientation() {
        return this.tickLabelOrientation;
    }

    @Override
    public void copyInfoFrom(Shape shape) {
        for (Shape shape2 : this.parts) {
            if (!MultiPartTextLine.isTextType(shape2)) continue;
            Fill fill = Fill.makeCopy(shape2.getFill());
            shape2.copyInfoFrom(shape);
            shape2.setFill(fill);
        }
    }

    @Override
    public void modifyFontSize(double d) {
        this.font = this.font.modifySize(d);
        for (Shape shape : this.parts) {
            if (!MultiPartTextLine.isTextType(shape)) continue;
            ((Text)shape).modifyFontSize(d);
        }
    }

    @Override
    public double getWidth() {
        double d = 0.0;
        for (Shape shape : this.parts) {
            if (MultiPartTextLine.isTextType(shape)) {
                d += ((Text)shape).getWidth();
                continue;
            }
            d += shape.getWidth();
        }
        return d;
    }

    @Override
    public double getHeight() {
        double d = this.font.getHeight();
        for (Shape shape : this.parts) {
            if (MultiPartTextLine.isTextType(shape)) {
                d = Math.max(d, ((Text)shape).getHeight());
                continue;
            }
            d = Math.max(d, shape.getBounds().getHeight());
        }
        return d;
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, boolean bl) {
        if (bl && d3 != 1.0) {
            this.font = this.font.modifySize(this.font.getSize() * d3);
        }
        for (Shape shape : this.parts) {
            if (!MultiPartTextLine.isTextType(shape)) continue;
            shape.affine(d, d2, d3, d4, bl);
        }
    }

    @Override
    public void setTransform(Affine affine) {
        for (Shape shape : this.parts) {
            if (MultiPartTextLine.isTextType(shape)) {
                ((Text)shape).setTransform(affine);
                continue;
            }
            shape.setTransform(affine);
        }
    }

    @Override
    public void updateTransform(Affine affine) {
        for (Shape shape : this.parts) {
            if (MultiPartTextLine.isTextType(shape)) {
                ((Text)shape).updateTransform(affine);
                continue;
            }
            shape.transform.preMultiply(affine);
        }
    }

    protected void updateTransformTextParts(Affine affine) {
        for (Shape shape : this.parts) {
            if (!MultiPartTextLine.isTextType(shape)) continue;
            ((Text)shape).updateTransform(affine);
        }
    }

    public void setRows(int[] nArray, String string) {
        for (Shape shape : this.parts) {
            shape.setRows(nArray);
            shape.setKey(string);
        }
    }

    public void setID(String string, int n) {
        super.setID(string + "_" + n);
        for (int i = 0; i < this.parts.size(); ++i) {
            Shape shape = this.parts.get(i);
            shape.setID(this.getID() + "_" + i);
        }
    }

    @Override
    public void setField(String string) {
        super.setField(string);
        for (Shape shape : this.parts) {
            shape.setField(string);
        }
    }

    @Override
    public void transpose(Dim dim) {
        for (Shape shape : this.parts) {
            shape.transpose(dim);
        }
    }

    @Override
    public Text fitInside(Dim dim) {
        double d = dim.getWidth();
        for (Shape shape : this.parts) {
            Shape shape2;
            if (shape == null) {
                this.wasClipped = true;
                continue;
            }
            if (MultiPartTextLine.isTextType(shape)) {
                shape2 = (Text)shape;
                if ((shape2 = ((Text)shape2).fitInside(dim)) == null || ((Text)shape2).wasClipped) {
                    this.wasClipped = true;
                }
                if (shape2 == null) continue;
                d -= ((Text)shape2).getWidth();
                continue;
            }
            shape2 = shape;
            if (shape2.getWidth() > d || shape2.getHeight() > dim.getHeight()) {
                shape = null;
                this.wasClipped = true;
            }
            if (shape == null) continue;
            d -= shape2.getWidth();
        }
        this.updateContent();
        return this;
    }

    @Override
    public void clipToFit(double d) {
        Shape shape;
        int n;
        double d2 = d;
        int n2 = -1;
        double d3 = 0.0;
        boolean bl = false;
        for (n = 0; n < this.getNumParts(); ++n) {
            Shape shape2;
            shape = this.parts.get(n);
            if (MultiPartTextLine.isTextType(shape)) {
                shape2 = (Text)shape;
                double d4 = ((Text)shape2).getWidth();
                ((Text)shape2).clipToFit(d2);
                if (((Text)shape2).wasClipped) {
                    this.wasClipped = true;
                    n2 = n;
                    d3 = d4 - ((Text)shape2).getWidth();
                    break;
                }
                d2 -= ((Text)shape2).getWidth();
                continue;
            }
            shape2 = shape;
            if (shape2.getWidth() > d2) {
                d3 = shape2.getWidth();
                shape = null;
                n2 = n;
                bl = true;
                break;
            }
            d2 -= shape2.getWidth();
        }
        if (n2 > 0) {
            for (n = this.getNumParts() - 1; n > n2; --n) {
                this.parts.remove(n);
            }
            if ("end".equals(this.align)) {
                for (n = 0; n < n2; ++n) {
                    double d5;
                    shape = this.parts.get(n);
                    if (MultiPartTextLine.isTextType(shape)) {
                        d5 = ((Text)shape).p.getX();
                        ((Text)shape).p.setX(d5 + d3);
                        continue;
                    }
                    d5 = shape.getX();
                    shape.setX(d5 + d3);
                }
            }
        } else if (n2 == 0 && bl) {
            this.parts.clear();
        }
        this.updateContent();
    }

    protected void updateContent() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parts.size() > 0) {
            this.content = new TextContent(this.font.getMinimumSize());
            for (int i = 0; i < this.parts.size(); ++i) {
                Shape shape = this.parts.get(i);
                if (MultiPartTextLine.isTextType(shape)) {
                    Text text = (Text)shape;
                    if (i == 0 && this.parts.size() == 1 && "".equals(text.text)) {
                        text.text = " ";
                    }
                    TextContentPart textContentPart = new TextContentPart(text.text, text.style, this.font.getMinimumSize());
                    textContentPart.setFont(text.font);
                    this.content.addPart(textContentPart);
                    stringBuffer.append(text.text);
                    continue;
                }
                this.content.addShape(shape);
            }
        }
        this.text = stringBuffer.toString();
    }

    protected void rePositionParts(double d) {
        for (Shape shape : this.parts) {
            if (1009 == shape.getType()) {
                ((Text)shape).p.setX(this.p.getX());
                ((Text)shape).p.setY(d);
                continue;
            }
            if (1004 != shape.getType()) continue;
            shape.setX(this.p.getX());
            shape.setY(d);
        }
        this.offsetX();
    }

    public void offsetX() {
        block10: {
            double d;
            block11: {
                block9: {
                    d = 0.0;
                    if (this.parts == null) {
                        return;
                    }
                    if (!"end".equals(this.align)) break block9;
                    for (int i = this.parts.size() - 1; i >= 0; --i) {
                        double d2;
                        Shape shape = this.parts.get(i);
                        if (MultiPartTextLine.isTextType(shape)) {
                            d2 = ((Text)shape).p.getX();
                            ((Text)shape).p.setX(d2 - d);
                            d += MultiPartTextLine.getPartWidth(shape);
                            continue;
                        }
                        d2 = shape.getX();
                        shape.setX(d2 - (d += MultiPartTextLine.getPartWidth(shape)));
                    }
                    break block10;
                }
                if (!"start".equals(this.align)) break block11;
                for (int i = 0; i < this.parts.size(); ++i) {
                    double d3;
                    Shape shape = this.parts.get(i);
                    if (MultiPartTextLine.isTextType(shape)) {
                        d3 = ((Text)shape).p.getX();
                        ((Text)shape).p.setX(d3 + d);
                    } else {
                        d3 = shape.getX();
                        shape.setX(d3 + d);
                    }
                    d += MultiPartTextLine.getPartWidth(shape);
                }
                break block10;
            }
            if (!"middle".equals(this.align)) break block10;
            d = 0.0 - this.getWidth() / 2.0;
            for (int i = 0; i < this.parts.size(); ++i) {
                double d4;
                Shape shape = this.parts.get(i);
                if (MultiPartTextLine.isTextType(shape)) {
                    d4 = ((Text)shape).p.getX();
                    ((Text)shape).p.setX(d4 + d + MultiPartTextLine.getPartWidth(shape) / 2.0);
                } else {
                    d4 = shape.getX();
                    shape.setX(d4 + d);
                }
                d += MultiPartTextLine.getPartWidth(shape);
            }
        }
    }

    public void offsetY(double d) {
        this.p.setY(this.p.getY() + d);
        if (this.parts == null) {
            return;
        }
        double d2 = this.getHeight();
        double d3 = this.getBaselineForHeighestTextPart();
        for (Shape shape : this.parts) {
            if (MultiPartTextLine.isTextType(shape)) {
                double d4 = ((Text)shape).p.getY();
                ((Text)shape).p.setY(d4 + d + (d3 - ((Text)shape).getBaseLine()));
                continue;
            }
            Shape shape2 = shape;
            double d5 = shape2.getY();
            shape2.setY(d5 + d);
            if (!(shape2.getHeight() < d2)) continue;
            shape2.setY(shape2.getY() + (d2 - shape2.getHeight()) / 2.0);
        }
    }

    private double getBaselineForHeighestTextPart() {
        double d = 0.0;
        for (Shape shape : this.parts) {
            if (!MultiPartTextLine.isTextType(shape)) continue;
            d = Math.max(((Text)shape).getBaseLine(), d);
        }
        return d;
    }

    @Override
    public boolean hasSinglePart() {
        return this.parts != null && this.parts.size() == 1;
    }

    private static double getPartWidth(Shape shape) {
        double d = 0.0;
        if (shape != null) {
            d = MultiPartTextLine.isTextType(shape) ? (d += ((Text)shape).getWidth()) : (d += shape.getWidth());
        }
        return d;
    }

    protected static boolean isTextType(Shape shape) {
        return 1009 == shape.getType();
    }
}

