/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.geom.GeomBuilder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Path
extends PolyShape {
    private char[] types;

    public Path(double[] dArray, double[] dArray2, boolean bl, char[] cArray) {
        super(dArray, dArray2, bl);
        this.types = cArray;
        if (cArray != null) assert (cArray.length == this.x.length);
    }

    @Override
    public Geom getRenderGeom(double d) {
        if (this.x == null || this.x.length == 0) {
            return null;
        }
        char[] cArray = this.getTypes();
        GeomBuilder geomBuilder = new GeomBuilder();
        int n = 0;
        while (n < this.x.length) {
            if (cArray[n] == 'M') {
                geomBuilder.moveTo(this.x[n], this.y[n]);
                ++n;
                continue;
            }
            if (cArray[n] == 'L') {
                geomBuilder.lineTo(this.x[n], this.y[n]);
                ++n;
                continue;
            }
            if (cArray[n] == 'Q') {
                geomBuilder.quadTo(this.x[n], this.y[n], this.x[n + 1], this.y[n + 1]);
                n += 2;
                continue;
            }
            if (cArray[n] == 'C') {
                geomBuilder.curveTo(this.x[n], this.y[n], this.x[n + 1], this.y[n + 1], this.x[n + 2], this.y[n + 2]);
                n += 3;
                continue;
            }
            if (cArray[n] == 'Z') {
                geomBuilder.closePath();
                ++n;
                continue;
            }
            throw new EngineException("Bad path control character '" + cArray[n] + "'", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        if (this.isFilled()) {
            geomBuilder.closePath();
        }
        return geomBuilder.getGeom();
    }

    @Override
    public int getType() {
        return 1002;
    }

    @Override
    public char[] getTypes() {
        return this.types;
    }

    @Override
    public Shape makeGeometryClone() {
        double[] dArray = new double[this.x.length];
        double[] dArray2 = new double[this.x.length];
        char[] cArray = new char[this.x.length];
        for (int i = 0; i < cArray.length; ++i) {
            dArray[i] = this.x[i];
            dArray2[i] = this.y[i];
            cArray[i] = this.getTypes()[i];
        }
        Path path = new Path(dArray, dArray2, this.isFilled(), cArray);
        path.setSnap(this.getSnap());
        path.setStartArrowByName(this.getStartArrowName());
        path.setEndArrowByName(this.getEndArrowName());
        return path;
    }

    @Override
    public boolean contains(double d, double d2) {
        ShapePoly shapePoly = new ShapePoly(this.x, this.y, true, null);
        return this.isFilled() && shapePoly.contains(d, d2);
    }

    @Override
    public void setDefaultStyle(StyleSpec styleSpec) {
        super.setDefaultStyle(styleSpec);
        if (styleSpec == null) {
            StyleBuilder.setDefaultFillStyle(this);
        } else {
            StyleBuilder.setFilled(this, styleSpec);
        }
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, boolean bl) {
        if (this.getContainingShape() != null && this.isRelativeToParent()) {
            Rect rect = this.getContainingShape().getEnclosedShapeBounds(this.getBoundsSpec());
            double d5 = rect.getWidth();
            double d6 = rect.getHeight();
            double d7 = rect.getTopLeft().getX();
            double d8 = rect.getTopLeft().getY();
            for (int i = 0; i < this.x.length; ++i) {
                this.x[i] = this.getOriginalX()[i] * d5 + d7;
                this.y[i] = this.getOriginalY()[i] * d6 + d8;
            }
        } else {
            super.affine(d, d2, d3, d4, bl);
        }
        this.invalidate();
    }

    public static boolean isBarLike(Shape shape) {
        if (shape instanceof Path) {
            return ((Path)shape).isUseBoundsForLabel();
        }
        return false;
    }
}

