/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.PolyGeom;
import com.ibm.vis.engine.internal.util.MathUtil;
import java.util.ArrayList;
import java.util.List;

@Deprecated
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PathSegmentBuilder {
    private List<Character> types = new ArrayList<Character>();
    private DoublePrimitiveArrayList xList = new DoublePrimitiveArrayList();
    private DoublePrimitiveArrayList yList = new DoublePrimitiveArrayList();
    private static char COMMAND_SEPARATOR = (char)44;

    public void addSegment(char c, double d, double d2) {
        this.types.add(Character.valueOf(c));
        this.xList.add(d);
        this.yList.add(d2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.types.size(); ++i) {
            char c = this.types.get(i).charValue();
            stringBuilder.append(c);
            double d = this.xList.get(i);
            double d2 = this.yList.get(i);
            if (d == d) {
                stringBuilder.append(MathUtil.r3(d));
            }
            if (d2 != d2) continue;
            stringBuilder.append(",");
            stringBuilder.append(MathUtil.r3(d2));
        }
        return stringBuilder.toString();
    }

    private char[] getTypes() {
        char[] cArray = new char[this.types.size()];
        int n = 0;
        for (Character c : this.types) {
            if (c == null) {
                c = Character.valueOf(COMMAND_SEPARATOR);
            }
            cArray[n] = c.charValue();
            ++n;
        }
        return cArray;
    }

    public PolyGeom makePolyGeom() {
        return new PolyGeom(this.xList.toArray(), this.yList.toArray(), this.getTypes());
    }

    public void addPair(double d, double d2) {
        this.types.add(Character.valueOf(COMMAND_SEPARATOR));
        this.xList.add(d);
        this.yList.add(d2);
    }

    public static PathSegmentBuilder makeFromPathString(String string) {
        PathSegmentBuilder pathSegmentBuilder = new PathSegmentBuilder();
        String string2 = "";
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (PathSegmentBuilder.isTypeChar(c2)) {
                if (string2.length() > 0) {
                    PathSegmentBuilder.processCoordString(Character.valueOf(c), string2, pathSegmentBuilder);
                    string2 = "";
                }
                if (c2 == 'Z') {
                    pathSegmentBuilder.addSegment(c2, Double.NaN, Double.NaN);
                }
                c = c2;
                continue;
            }
            string2 = string2 + c2;
        }
        if (string2.length() > 0) {
            PathSegmentBuilder.processCoordString(Character.valueOf(c), string2, pathSegmentBuilder);
        }
        return pathSegmentBuilder;
    }

    private static void processCoordString(Character c, String string, PathSegmentBuilder pathSegmentBuilder) {
        String[] stringArray = string.split(",");
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            double d = Double.parseDouble(stringArray[i]);
            double d2 = Double.NaN;
            if (i + 1 < stringArray.length) {
                d2 = Double.parseDouble(stringArray[++i]);
            }
            if (bl) {
                pathSegmentBuilder.addSegment(c.charValue(), d, d2);
            } else {
                pathSegmentBuilder.addPair(d, d2);
            }
            bl = false;
        }
    }

    private static final boolean isTypeChar(char c) {
        return c == 'M' || c == 'L' || c == 'C' || c == 'Q' || c == 'Z';
    }
}

