/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PathSegmentBuilder;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PolyGeom {
    private final double[] x;
    private final double[] y;
    private final char[] types;
    public static final char FAKE_TYPE = ',';
    private final boolean closed;

    public PolyGeom(double[] dArray, double[] dArray2, char[] cArray) {
        this.x = dArray;
        this.y = dArray2;
        this.types = cArray;
        assert (cArray != null);
        assert (cArray.length == this.x.length);
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != 'Z') continue;
            bl = true;
            break;
        }
        this.closed = bl;
    }

    public static final PolyGeom makeSegmented(double[] dArray, double[] dArray2, char[] cArray, boolean bl) {
        Object object;
        int n;
        Object object2;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Character> arrayList2 = new ArrayList<Character>();
        Object object3 = object2 = new Point(dArray[0], dArray2[0]);
        for (n = 0; n < dArray.length; ++n) {
            double d;
            double d2;
            double d3;
            double d4;
            char c = cArray == null ? (n == 0 ? (char)'M' : 'L') : cArray[n];
            object = new Point(dArray[n], dArray2[n]);
            if (c == 'Z') {
                object = object3;
            }
            if (c == 'M') {
                arrayList2.add(Character.valueOf(c));
                arrayList.add((Point)object);
                object3 = object;
            } else if (c == 'C') {
                double d5 = dArray[n - 1];
                double d6 = dArray2[n - 1];
                d4 = dArray[n];
                d3 = dArray2[n];
                d2 = dArray[++n];
                d = dArray2[n];
                double d7 = dArray[++n];
                double d8 = dArray2[n];
                ArrayList<ShapeLine> arrayList3 = new ArrayList<ShapeLine>();
                PolyGeom.curveTo(d5, d6, d7, d8, d4, d3, d2, d, arrayList3);
                object = PolyGeom.addLineSegmentsIntoList(arrayList, arrayList2, arrayList3);
            } else if (c == 'Q') {
                double d9 = dArray[n - 1];
                double d10 = dArray2[n - 1];
                d4 = dArray[n];
                d3 = dArray2[n];
                d2 = dArray[++n];
                d = dArray2[n];
                ArrayList<ShapeLine> arrayList4 = new ArrayList<ShapeLine>();
                PolyGeom.quadTo(d9, d10, d2, d, d4, d3, arrayList4);
                object = PolyGeom.addLineSegmentsIntoList(arrayList, arrayList2, arrayList4);
            } else if (bl) {
                double d11 = Math.ceil(((Point)object).distance((Point)object2) / 25.0);
                int n2 = 1;
                while ((double)n2 < d11 + 0.5) {
                    Point point = ((Point)object2).interpolateTo((Point)object, (double)n2 / d11);
                    arrayList.add(point);
                    arrayList2.add(Character.valueOf((char)(c == 'Z' && (double)n2 == d11 ? 90 : 76)));
                    ++n2;
                }
            } else if (c == 'L') {
                arrayList2.add(Character.valueOf('L'));
                arrayList.add((Point)object);
            } else if (c == 'Z') {
                arrayList2.add(Character.valueOf('Z'));
                Point point = new Point(Double.NaN, Double.NaN);
                arrayList.add(point);
                object = point;
            }
            object2 = object;
        }
        n = arrayList.size();
        double[] dArray3 = new double[n];
        object = new double[n];
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            Point point = (Point)arrayList.get(i);
            cArray2[i] = ((Character)arrayList2.get(i)).charValue();
            dArray3[i] = point.getX();
            object[i] = point.getY();
        }
        return new PolyGeom(dArray3, (double[])object, cArray2);
    }

    private static Point addLineSegmentsIntoList(List<Point> list, List<Character> list2, List<ShapeLine> list3) {
        Point point = new Point(Double.NaN, Double.NaN);
        for (ShapeLine shapeLine : list3) {
            Point point2 = new Point(shapeLine.x[1], shapeLine.y[1]);
            list.add(point2);
            list2.add(Character.valueOf('L'));
            point = point2;
        }
        return point;
    }

    public static PolyGeom makePolyGeom(String string) {
        return PathSegmentBuilder.makeFromPathString(string).makePolyGeom();
    }

    public String makePath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.x.length; ++i) {
            stringBuilder.append(this.types[i]);
            if (this.types[i] == 'Z') continue;
            stringBuilder.append(MathUtil.r3(this.x[i]) + "," + MathUtil.r3(this.y[i]));
        }
        return stringBuilder.toString();
    }

    public static double area(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 1; i <= dArray.length; ++i) {
            double d2 = i < dArray.length ? dArray[i] : dArray[0];
            double d3 = i < dArray2.length ? dArray2[i] : dArray2[0];
            d += dArray[i - 1] * d3 - d2 * dArray2[i - 1];
        }
        return Math.abs(d / 2.0);
    }

    public static Point centroid(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 1; i <= dArray.length; ++i) {
            double d6 = i < dArray.length ? dArray[i] : dArray[0];
            double d7 = i < dArray2.length ? dArray2[i] : dArray2[0];
            double d8 = dArray[i - 1] * d7 - d6 * dArray2[i - 1];
            d5 += d8;
            d += (dArray[i - 1] + d6) * d8;
            d2 += (dArray2[i - 1] + d7) * d8;
            d3 += dArray[i - 1];
            d4 += dArray2[i - 1];
        }
        if (Math.abs(d5) < 1.0E-8) {
            return new Point(d3 / (double)dArray.length, d4 / (double)dArray2.length);
        }
        return new Point(d / d5 / 3.0, d2 / d5 / 3.0);
    }

    public PolyGeom projectToLine(double d, double d2, double d3, double d4) {
        int n = this.x.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        char[] cArray = new char[n];
        if (d == d3 && d2 == d4) {
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(this.x[i]) || Double.isNaN(this.y[i])) {
                    dArray[i] = Double.NaN;
                    dArray2[i] = Double.NaN;
                    continue;
                }
                dArray[i] = d;
                dArray2[i] = d2;
            }
        } else if (d == d3) {
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(this.x[i]) || Double.isNaN(this.y[i])) {
                    dArray[i] = Double.NaN;
                    dArray2[i] = Double.NaN;
                    continue;
                }
                dArray[i] = d;
                dArray2[i] = this.y[i];
            }
        } else if (d2 == d4) {
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(this.x[i]) || Double.isNaN(this.y[i])) {
                    dArray[i] = Double.NaN;
                    dArray2[i] = Double.NaN;
                    continue;
                }
                dArray[i] = this.x[i];
                dArray2[i] = d2;
            }
        } else {
            double d5 = d3 - d;
            double d6 = d4 - d2;
            double d7 = d5 * d5 + d6 * d6;
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(this.x[i]) || Double.isNaN(this.y[i])) {
                    dArray[i] = Double.NaN;
                    dArray2[i] = Double.NaN;
                    continue;
                }
                double d8 = ((this.x[i] - d) * d5 + (this.y[i] - d2) * d6) / d7;
                dArray[i] = d + d8 * d5;
                dArray2[i] = d2 + d8 * d6;
            }
        }
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.types[i];
        }
        return new PolyGeom(dArray, dArray2, cArray);
    }

    public Rect getBounds() {
        int n = this.x.length;
        if (n == 0) {
            return new Rect(0.0, 0.0, 0.0, 0.0);
        }
        assert (this.types[0] != 'Z');
        double d = this.x[0];
        double d2 = this.y[0];
        double d3 = this.x[0];
        double d4 = this.y[0];
        for (int i = 1; i < n; ++i) {
            if (this.types[i] == 'Z') continue;
            d = Math.min(d, this.x[i]);
            d2 = Math.min(d2, this.y[i]);
            d3 = Math.max(d3, this.x[i]);
            d4 = Math.max(d4, this.y[i]);
        }
        return new Rect(d, d2, d3 - d, d4 - d2);
    }

    public static void curveTo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, List<ShapeLine> list) {
        double d9 = Line.extendedLineDistanceToPoint(d, d2, d3, d4, d5, d6);
        double d10 = Line.extendedLineDistanceToPoint(d, d2, d3, d4, d7, d8);
        double d11 = Double.isNaN(d9) || Double.isNaN(d10) ? 0.0 : Math.max(d9, d10);
        if (d11 <= 0.5) {
            ShapeLine shapeLine = ShapeLine.make(d, d2, d3, d4);
            list.add(shapeLine);
        } else {
            double d12 = 0.125 * d + 0.375 * d5 + 0.375 * d7 + 0.125 * d3;
            double d13 = 0.125 * d2 + 0.375 * d6 + 0.375 * d8 + 0.125 * d4;
            double d14 = 0.5 * (d + d5);
            double d15 = 0.5 * (d2 + d6);
            double d16 = 0.5 * (d5 + d7);
            double d17 = 0.5 * (d6 + d8);
            double d18 = 0.5 * (d7 + d3);
            double d19 = 0.5 * (d8 + d4);
            double d20 = 0.5 * (d14 + d16);
            double d21 = 0.5 * (d15 + d17);
            double d22 = 0.5 * (d16 + d18);
            double d23 = 0.5 * (d17 + d19);
            PolyGeom.curveTo(d, d2, d12, d13, d14, d15, d20, d21, list);
            PolyGeom.curveTo(d12, d13, d3, d4, d22, d23, d18, d19, list);
        }
    }

    public static void quadTo(double d, double d2, double d3, double d4, double d5, double d6, List<ShapeLine> list) {
        double d7 = Line.extendedLineDistanceToPoint(d, d2, d3, d4, d5, d6);
        if (d7 <= 0.5) {
            ShapeLine shapeLine = ShapeLine.make(d, d2, d3, d4);
            list.add(shapeLine);
        } else {
            double d8 = 0.25 * d + 0.5 * d5 + 0.25 * d3;
            double d9 = 0.25 * d2 + 0.5 * d6 + 0.25 * d4;
            double d10 = 0.5 * (d + d5);
            double d11 = 0.5 * (d2 + d6);
            double d12 = 0.5 * (d5 + d3);
            double d13 = 0.5 * (d6 + d4);
            PolyGeom.quadTo(d, d2, d8, d9, d10, d11, list);
            PolyGeom.quadTo(d8, d9, d3, d4, d12, d13, list);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public final double[] getX() {
        return this.x;
    }

    public final double[] getY() {
        return this.y;
    }

    public final char[] getTypes() {
        return this.types;
    }
}

