/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.ArrowGeom;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.PolyGeom;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeNearShape;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class PolyShape
extends Shape {
    protected double[] x;
    protected double[] y;
    private boolean filled;

    public PolyShape(double[] dArray, double[] dArray2, boolean bl) {
        this.shapeType = 1003;
        this.x = dArray;
        this.y = dArray2;
        this.filled = bl;
    }

    @Override
    public SceneNodeImpl createSceneNode() {
        Shape shape;
        boolean bl;
        boolean bl2 = bl = this.getStartArrow() != null || this.getEndArrow() != null;
        if (!bl && (this.getSymbol() == null || "line".equals(this.getSymbol()))) {
            return SceneNodeFactory.createShapeNode(this);
        }
        PolyShape polyShape = this.makeMainPath();
        if (!bl) {
            polyShape.setSymbol(null);
            polyShape.setStartArrow(null);
            polyShape.setEndArrow(null);
            polyShape.setID(this.getID());
            return SceneNodeFactory.createShapeNode(polyShape);
        }
        String string = this.getID();
        String string2 = this.getKey();
        int n = 1 + (this.getStartArrow() != null ? 1 : 0) + (this.getEndArrow() != null ? 1 : 0);
        Shape[] shapeArray = new Shape[n];
        int n2 = 0;
        Rect rect = polyShape.getBounds();
        shapeArray[n2++] = polyShape;
        if (this.getStartArrow() != null) {
            shape = this.getStartArrow().createArrowShape(this.getStartArrowGeom(), polyShape);
            shapeArray[n2++] = shape;
            rect = rect.copy();
            rect.extendToRect(shape.getBounds());
        }
        if (this.getEndArrow() != null) {
            shape = this.getEndArrow().createArrowShape(this.getEndArrowGeom(), polyShape);
            shapeArray[n2++] = shape;
            rect = rect.copy();
            rect.extendToRect(shape.getBounds());
        }
        shape = new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), null, false);
        ((Schema)shape).copyInfoFrom(this);
        ((Schema)shape).setParts(shapeArray);
        ((Schema)shape).setID(string);
        shape.setKey(string2);
        return ((Schema)shape).createSceneNode();
    }

    private PolyShape makeMainPath() {
        Object object;
        int n;
        int n2;
        boolean bl;
        boolean bl2 = bl = this.getStartArrow() != null || this.getEndArrow() != null;
        if (bl) {
            if (this.getStartArrow() != null) {
                this.setStartArrowGeom(new ArrowGeom(this.getStartArrow()));
                this.getStartArrowGeom().configForStrokeWidth(this.getStroke());
            }
            if (this.getEndArrow() != null) {
                this.setEndArrowGeom(new ArrowGeom(this.getEndArrow()));
                this.getEndArrowGeom().configForStrokeWidth(this.getStroke());
            }
        } else {
            this.setStartArrowGeom(null);
            this.setEndArrowGeom(null);
        }
        int n3 = this.x.length;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < this.x.length; ++i) {
            dArray[i] = this.x[i];
            dArray2[i] = this.y[i];
        }
        char[] cArray = new char[n3];
        if (this.getTypes() == null) {
            cArray[0] = 77;
            for (n2 = 1; n2 < n3; ++n2) {
                cArray[n2] = 76;
            }
        } else {
            char[] cArray2 = this.getTypes();
            for (n = 0; n < n3; ++n) {
                cArray[n] = cArray2[n];
            }
        }
        n2 = this.getSymbol() != null && this.getSymbol().indexOf("urved") >= 0 ? 1 : 0;
        int n4 = n = this.getSymbol() != null && this.getSymbol().indexOf("lbow") >= 0 ? 1 : 0;
        if (n2 != 0 || n != 0) {
            object = new ArrayList<Point>();
            ArrayList<Character> arrayList = new ArrayList<Character>();
            PolyShape.makeCurvedElbowSections(dArray, dArray2, cArray, n2 != 0, n != 0, object, arrayList, this.getPreferHorizontal(), this.getStartArrowGeom(), this.getEndArrowGeom());
            n3 = ((ArrayList)object).size();
            dArray = new double[n3];
            dArray2 = new double[n3];
            cArray = new char[n3];
            for (int i = 0; i < n3; ++i) {
                Point point = (Point)((ArrayList)object).get(i);
                dArray[i] = point.getX();
                dArray2[i] = point.getY();
                cArray[i] = arrayList.get(i).charValue();
            }
        }
        PolyShape.setupArrowLocation(this.getStartArrowGeom(), dArray, dArray2, 0, 1);
        PolyShape.setupArrowLocation(this.getEndArrowGeom(), dArray, dArray2, n3 - 1, -1);
        object = new Path(dArray, dArray2, this.isFilled(), cArray);
        ((Shape)object).copyInfoFrom(this);
        ((Shape)object).setKey(this.getKey());
        ((Shape)object).setEdgeProperties(null, null, null, null);
        return object;
    }

    private static void makeCurvedElbowSections(double[] dArray, double[] dArray2, char[] cArray, boolean bl, boolean bl2, List<Point> list, List<Character> list2, Boolean bl3, ArrowGeom arrowGeom, ArrowGeom arrowGeom2) {
        double d;
        int n = dArray.length;
        if (arrowGeom != null && bl3 != null) {
            double d2;
            list.add(new Point(dArray[0], dArray2[0]));
            list2.add(Character.valueOf('M'));
            cArray[0] = 76;
            if (bl3.booleanValue()) {
                d2 = Math.min(arrowGeom.getLength(), Math.abs(dArray[1] - dArray[0]));
                dArray[0] = dArray[0] + (dArray[1] > dArray[0] ? d2 : -d2);
            } else {
                d2 = Math.min(arrowGeom.getLength(), Math.abs(dArray2[1] - dArray2[0]));
                dArray2[0] = dArray2[0] + (dArray2[1] > dArray2[0] ? d2 : -d2);
            }
        }
        Point point = null;
        if (arrowGeom2 != null && bl3 != null) {
            point = new Point(dArray[n - 1], dArray2[n - 1]);
            double d3 = Math.min(arrowGeom2.getLength(), Math.abs(dArray[n - 1] - dArray[n - 2]));
            d = Math.min(arrowGeom2.getLength(), Math.abs(dArray2[n - 1] - dArray2[n - 2]));
            if (bl3.booleanValue() || d == 0.0) {
                int n2 = n - 1;
                dArray[n2] = dArray[n2] - (dArray[n - 1] > dArray[n - 2] ? d3 : -d3);
            } else {
                int n3 = n - 1;
                dArray2[n3] = dArray2[n3] - (dArray2[n - 1] > dArray2[n - 2] ? d : -d);
            }
        }
        for (int i = 0; i < n; ++i) {
            boolean bl4;
            boolean bl5;
            int n4 = cArray[i];
            d = i == 0 ? 0.0 : Math.abs(dArray[i] - dArray[i - 1]);
            double d4 = i == 0 ? 0.0 : Math.abs(dArray2[i] - dArray2[i - 1]);
            boolean bl6 = bl5 = d < 1.0 || d4 < 1.0;
            boolean bl7 = bl3 == null ? d > d4 : (bl4 = bl3.booleanValue());
            if (bl && !bl2 && n4 != 77 && n4 != 90 && n4 == 76 && !bl5) {
                list2.add(Character.valueOf('C'));
                list2.add(Character.valueOf(','));
                n4 = 44;
                if (bl4) {
                    list.add(new Point((dArray[i - 1] + 2.0 * dArray[i]) / 3.0, dArray2[i - 1]));
                    list.add(new Point((2.0 * dArray[i - 1] + dArray[i]) / 3.0, dArray2[i]));
                } else {
                    list.add(new Point(dArray[i - 1], (dArray2[i - 1] + 2.0 * dArray2[i]) / 3.0));
                    list.add(new Point(dArray[i], (2.0 * dArray2[i - 1] + dArray2[i]) / 3.0));
                }
            }
            list.add(new Point(dArray[i], dArray2[i]));
            list2.add(Character.valueOf((char)n4));
        }
        if (point != null) {
            list2.add(Character.valueOf('L'));
            list.add(point);
        }
    }

    @Override
    public boolean isFilled() {
        return this.filled;
    }

    @Override
    public Geom applyPointTransform(PointTransform pointTransform) {
        if (pointTransform.preservesLines() || this.allDistancesSmall()) {
            this.doInPlaceTransform(pointTransform);
            return null;
        }
        Poly poly = this.getTypes() == null ? new Poly(this.x, this.y, this.filled) : new Curve(this.x, this.y, this.convertTypesToBoolean(this.getTypes()), this.filled).asBasic().asPoly();
        return poly.applyPointTransform(pointTransform);
    }

    private boolean[] convertTypesToBoolean(char[] cArray) {
        boolean[] blArray = new boolean[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == 'Q') {
                blArray[i++] = true;
                continue;
            }
            if (cArray[i] != 'C') continue;
            blArray[i++] = true;
            blArray[i++] = true;
        }
        return blArray;
    }

    boolean allDistancesSmall() {
        char[] cArray = this.getTypes();
        for (int i = 1; i < this.x.length; ++i) {
            if (cArray != null && (cArray[i] == 'Z' || cArray[i] == 'M') || !(Math.abs(this.x[i] - this.x[i - 1]) > 25.0) && !(Math.abs(this.y[i] - this.y[i - 1]) > 25.0)) continue;
            return false;
        }
        return true;
    }

    protected void doInPlaceTransform(PointTransform pointTransform) {
        for (int i = 0; i < this.x.length; ++i) {
            Point point = pointTransform.transform(this.x[i], this.y[i]);
            this.x[i] = point.getX();
            this.y[i] = point.getY();
        }
    }

    @Override
    protected Rect calculateBounds() {
        char[] cArray = this.getTypes();
        double d = 0.0;
        double d2 = 0.0;
        if (this.x.length > 0) {
            d = this.x[0];
            d2 = this.x[0];
            for (int i = 1; i < this.x.length; ++i) {
                if (cArray != null && cArray[i] == 'Z' || this.x[i] != this.x[i]) continue;
                d = Math.min(d, this.x[i]);
                d2 = Math.max(d2, this.x[i]);
            }
        }
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.y.length > 0) {
            d3 = this.y[0];
            d4 = this.y[0];
            for (int i = 1; i < this.y.length; ++i) {
                if (cArray != null && cArray[i] == 'Z' || this.y[i] != this.y[i]) continue;
                d3 = Math.min(d3, this.y[i]);
                d4 = Math.max(d4, this.y[i]);
            }
        }
        return new Rect(d, d3, d2 - d, d4 - d3);
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.getContainingShape() != null && this.isRelativeToParent() && 1001 != this.getType()) {
            Rect rect = this.getContainingShape().getEnclosedShapeBounds(this.getBoundsSpec());
            Rect rect2 = this.getBounds();
            d = rect.getWidth() / rect2.getWidth();
            d3 = rect.getHeight() / rect2.getHeight();
            d2 = rect.getX() - rect2.getX();
            d4 = rect.getY() - rect2.getY();
            d5 = rect2.getX();
            d6 = rect2.getY();
        }
        double d7 = d;
        double d8 = d3;
        if (!bl) {
            if (!this.canScaleX()) {
                d7 = 1.0;
            }
            if (!this.canScaleY()) {
                d8 = 1.0;
            }
        }
        d5 *= 1.0 - d7;
        d6 *= 1.0 - d8;
        for (int i = 0; i < this.x.length; ++i) {
            this.x[i] = this.x[i] * d7 + d2 + d5;
            this.y[i] = this.y[i] * d8 + d4 + d6;
        }
        this.invalidate();
    }

    @Override
    public Point getCenter() {
        return this.getBounds().getCenter();
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        for (int i = 0; i < this.x.length; ++i) {
            if (bl) {
                this.y[i] = dim.getHeight() - this.y[i];
                continue;
            }
            this.x[i] = dim.getWidth() - this.x[i];
        }
        this.invalidate();
    }

    @Override
    public void transpose(Dim dim) {
        for (int i = 0; i < this.x.length; ++i) {
            double d = dim.getWidth() - dim.getWidth() * this.y[i] / dim.getHeight();
            this.y[i] = dim.getHeight() * (1.0 - this.x[i] / dim.getWidth());
            this.x[i] = d;
        }
        this.invalidate();
        if ("semiCircle".equals(this.getSymbol())) {
            Rect rect = this.getBounds();
            if (rect.area() > 0.0) {
                for (int i = 0; i < this.x.length; ++i) {
                    this.x[i] = rect.getX() + (this.x[i] - rect.getX()) * rect.getHeight() / rect.getWidth() / 2.0;
                }
            }
            this.invalidate();
        }
    }

    @Override
    public Shape getLabelShape(String string, String string2, String string3) {
        if (this.isUseBoundsForLabel()) {
            return Shape.toShapeRect(this.getBounds());
        }
        if (this.isGlyphLike()) {
            return this;
        }
        if (!this.isFilled()) {
            return this.getLabelShapeForPath(string, string3);
        }
        if ("outside".equals(string3)) {
            return ShapeNearShape.makeShapeOutsidePoly(this, string, string2);
        }
        return ShapeNearShape.makeShapeInsidePoly(this, true);
    }

    Shape getLabelShapeForPath(String string, String string2) {
        Shape shape;
        int n;
        double d;
        double d2;
        double d3;
        double d4;
        int n2 = this.x.length;
        if (this.x.length == 1) {
            d4 = this.x[0];
            d3 = this.y[0];
            d2 = 1.0;
            d = 1.0;
        } else if (this.x[0] != this.x[n2 - 1] || this.y[0] != this.y[n2 - 1]) {
            if ("start".equals(string)) {
                d4 = this.x[0];
                d3 = this.y[0];
                d2 = Math.abs(this.x[0] - this.x[1]);
                d = Math.abs(this.y[0] - this.y[1]);
            } else if ("end".equals(string)) {
                d4 = this.x[n2 - 1];
                d3 = this.y[n2 - 1];
                d2 = Math.abs(this.x[n2 - 1] - this.x[n2 - 2]);
                d = Math.abs(this.y[n2 - 1] - this.y[n2 - 2]);
            } else {
                int n3 = (int)Math.floor((double)(n2 - 1) / 2.0);
                n = (int)Math.ceil((double)n2 / 2.0);
                d4 = (this.x[n3] + this.x[n]) / 2.0;
                d3 = (this.y[n3] + this.y[n]) / 2.0;
                d2 = Math.abs(this.x[n] - this.x[n3]);
                d = Math.abs(this.y[n] - this.y[n3]);
            }
        } else if ("start".equals(string)) {
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                if (!(this.x[n] < this.x[n4])) continue;
                n4 = n;
            }
            d4 = this.x[n4];
            d3 = this.y[n4];
            if (n4 == n2 - 1) {
                d2 = Math.abs(this.x[n4] - this.x[n4 - 1]);
                d = Math.abs(this.y[n4] - this.y[n4 - 1]);
            } else {
                d2 = Math.abs(this.x[n4] - this.x[n4 + 1]);
                d = Math.abs(this.y[n4] - this.y[n4 + 1]);
            }
        } else if ("end".equals(string)) {
            int n5 = 0;
            for (n = 0; n < n2; ++n) {
                if (!(this.x[n] > this.x[n5])) continue;
                n5 = n;
            }
            d4 = this.x[n5];
            d3 = this.y[n5];
            if (n5 == n2 - 1) {
                d2 = Math.abs(this.x[n5] - this.x[n5 - 1]);
                d = Math.abs(this.y[n5] - this.y[n5 - 1]);
            } else {
                d2 = Math.abs(this.x[n5] - this.x[n5 + 1]);
                d = Math.abs(this.y[n5] - this.y[n5 + 1]);
            }
        } else {
            int n6;
            int n7;
            double d5 = this.x[0];
            double d6 = this.x[0];
            for (n7 = 1; n7 < n2 - 1; ++n7) {
                if (this.x[n7] < d6) {
                    d6 = this.x[n7];
                }
                if (!(this.x[n7] > d5)) continue;
                d5 = this.x[n7];
            }
            double d7 = (d6 + d5) / 2.0;
            n7 = 0;
            for (n6 = 1; n6 < n2 - 1; ++n6) {
                if (!(Math.abs(this.x[n6] - d7) < Math.abs(this.x[n7] - d7))) continue;
                n7 = n6;
            }
            n6 = (n7 + (n2 - 1) + 1) % (n2 - 1);
            int n8 = (n7 + (n2 - 1) - 1) % (n2 - 1);
            int n9 = Math.abs(this.x[n6] - d7) < Math.abs(this.x[n8] - d7) ? n6 : n8;
            d4 = (this.x[n7] + this.x[n9]) / 2.0;
            d3 = (this.y[n7] + this.y[n9]) / 2.0;
            d2 = Math.abs(this.x[n7] - this.x[n9]);
            d = Math.abs(this.y[n7] - this.y[n9]);
        }
        if ("inside".equals(string2)) {
            double d8;
            double d9;
            ArrowGeom arrowGeom;
            double d10 = 0.0;
            if (this.getStartArrow() != null) {
                arrowGeom = new ArrowGeom(this.getStartArrow());
                arrowGeom.configForStrokeWidth(this.getStroke());
                d10 = Math.max(d10, arrowGeom.getLength());
            }
            if (this.getEndArrow() != null) {
                arrowGeom = new ArrowGeom(this.getEndArrow());
                arrowGeom.configForStrokeWidth(this.getStroke());
                d10 = Math.max(d10, arrowGeom.getLength());
            }
            d10 *= 2.0;
            if (d < 2.0) {
                d9 = d2;
                d8 = d2;
                if (d10 < d9) {
                    d9 -= d10;
                }
            } else if (d2 < 2.0) {
                d9 = 2.0 * d;
                d8 = d;
                if (d10 < d8) {
                    d8 -= d10;
                }
            } else {
                d9 = d2;
                d8 = d;
                if (d10 < d9) {
                    d9 -= d10;
                }
                if (d10 < d8) {
                    d8 -= d10;
                }
            }
            shape = ShapeFactory2.CreateRect(d4 - d9 / 2.0, d3 - d8 / 2.0, d9, d8);
        } else {
            shape = ShapeFactory2.CreateCircle(d4, d3, 1.0);
        }
        shape.setSnap(this.getSnap());
        shape.setGlyphLike();
        return shape;
    }

    public final int length() {
        return this.x.length;
    }

    @Override
    public double getTangentAngle(String string, String string2) {
        int n = this.x.length - 1;
        if ("start".equals(string)) {
            return Math.atan2(this.y[1] - this.y[0], this.x[1] - this.x[0]);
        }
        if ("end".equals(string)) {
            return Math.atan2(this.y[n] - this.y[n - 1], this.x[n] - this.x[n - 1]);
        }
        int n2 = (int)Math.floor(n / 2);
        return Math.atan2(this.y[n2 + 1] - this.y[n2], this.x[n2 + 1] - this.x[n2]);
    }

    @Override
    public boolean contains(double d, double d2) {
        if (!this.filled || !this.getBounds().containsPt(d, d2)) {
            return false;
        }
        return PolyShape.testContains(this.x, this.y, d, d2);
    }

    public static boolean testContains(double[] dArray, double[] dArray2, double d, double d2) {
        int n = 0;
        int n2 = dArray.length - 1;
        for (int i = 0; i < dArray.length; ++i) {
            double d3;
            double d4;
            double d5 = (dArray2[n2] - dArray2[i]) / (dArray[n2] - dArray[i]);
            if (Double.isNaN(d5)) {
                n2 = i;
                continue;
            }
            if (d5 != 0.0 && !Double.isInfinite(Math.abs(d5))) {
                d4 = dArray2[i] - d5 * dArray[i];
                d3 = (d2 - d4) / d5;
                if ((d3 >= dArray[i] && d3 <= dArray[n2] || d3 >= dArray[n2] && d3 <= dArray[i]) && d3 < d) {
                    if (d2 == dArray2[i]) {
                        if (dArray2[n2] > d2) {
                            ++n;
                        }
                    } else if (d2 == dArray2[n2]) {
                        if (dArray2[i] > d2) {
                            ++n;
                        }
                    } else {
                        ++n;
                    }
                }
            } else {
                if (d5 == 0.0) {
                    n2 = i;
                    continue;
                }
                d4 = dArray[i];
                d3 = d2;
                if ((d3 >= dArray2[i] && d3 <= dArray2[n2] || d3 >= dArray2[n2] && d3 <= dArray2[i]) && d4 < d) {
                    if (d3 == dArray2[i]) {
                        if (dArray2[n2] > d2) {
                            ++n;
                        }
                    } else if (d3 == dArray2[n2]) {
                        if (dArray2[i] > d2) {
                            ++n;
                        }
                    } else {
                        ++n;
                    }
                }
            }
            n2 = i;
        }
        return n % 2 > 0;
    }

    public char[] getTypes() {
        return null;
    }

    @Deprecated
    static String makeModifiedPath(double[] dArray, double[] dArray2, char[] cArray, boolean bl, boolean bl2, Boolean bl3, ArrowGeom arrowGeom, ArrowGeom arrowGeom2) {
        double d;
        char[] cArray2;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ArrayList<Character> arrayList2 = new ArrayList<Character>();
        int n = dArray.length;
        if (cArray == null) {
            cArray2 = new char[n];
            cArray2[0] = 77;
            for (int i = 1; i < n; ++i) {
                cArray2[i] = 76;
            }
        } else {
            cArray2 = cArray;
        }
        if (arrowGeom != null && bl3 != null) {
            arrayList.add(new Point(dArray[0], dArray2[0]));
            arrayList2.add(Character.valueOf('M'));
            cArray2[0] = 76;
            if (bl3.booleanValue()) {
                double d2 = Math.min(arrowGeom.getLength(), Math.abs(dArray[1] - dArray[0]));
                dArray[0] = dArray[0] + (dArray[1] > dArray[0] ? d2 : -d2);
            } else {
                double d3 = Math.min(arrowGeom.getLength(), Math.abs(dArray2[1] - dArray2[0]));
                dArray2[0] = dArray2[0] + (dArray2[1] > dArray2[0] ? d3 : -d3);
            }
        }
        Point point = null;
        if (arrowGeom2 != null && bl3 != null) {
            point = new Point(dArray[n - 1], dArray2[n - 1]);
            double d4 = Math.min(arrowGeom2.getLength(), Math.abs(dArray[n - 1] - dArray[n - 2]));
            d = Math.min(arrowGeom2.getLength(), Math.abs(dArray2[n - 1] - dArray2[n - 2]));
            if (bl3.booleanValue() || d == 0.0) {
                int n2 = n - 1;
                dArray[n2] = dArray[n2] - (dArray[n - 1] > dArray[n - 2] ? d4 : -d4);
            } else {
                int n3 = n - 1;
                dArray2[n3] = dArray2[n3] - (dArray2[n - 1] > dArray2[n - 2] ? d : -d);
            }
        }
        for (int i = 0; i < n; ++i) {
            boolean bl4;
            boolean bl5;
            int n4 = cArray2 == null ? (arrayList2.size() == 0 ? 77 : 76) : cArray2[i];
            d = i == 0 ? 0.0 : Math.abs(dArray[i] - dArray[i - 1]);
            double d5 = i == 0 ? 0.0 : Math.abs(dArray2[i] - dArray2[i - 1]);
            boolean bl6 = bl5 = d < 1.0 || d5 < 1.0;
            boolean bl7 = bl3 == null ? d > d5 : (bl4 = bl3.booleanValue());
            if (bl && !bl2 && n4 != 77 && n4 != 90 && n4 == 76 && !bl5) {
                arrayList2.add(Character.valueOf('C'));
                arrayList2.add(Character.valueOf(','));
                n4 = 44;
                if (bl4) {
                    arrayList.add(new Point((dArray[i - 1] + 2.0 * dArray[i]) / 3.0, dArray2[i - 1]));
                    arrayList.add(new Point((2.0 * dArray[i - 1] + dArray[i]) / 3.0, dArray2[i]));
                } else {
                    arrayList.add(new Point(dArray[i - 1], (dArray2[i - 1] + 2.0 * dArray2[i]) / 3.0));
                    arrayList.add(new Point(dArray[i], (2.0 * dArray2[i - 1] + dArray2[i]) / 3.0));
                }
            }
            arrayList.add(new Point(dArray[i], dArray2[i]));
            arrayList2.add(Character.valueOf((char)n4));
        }
        if (point != null) {
            arrayList2.add(Character.valueOf('L'));
            arrayList.add(point);
        }
        n = arrayList.size();
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        char[] cArray3 = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray3[i] = ((Character)arrayList2.get(i)).charValue();
            Point point2 = (Point)arrayList.get(i);
            dArray3[i] = point2.getX();
            dArray4[i] = point2.getY();
        }
        return PolyShape.makeGeneralPath(dArray3, dArray4, cArray3, arrowGeom, arrowGeom2);
    }

    public static void setupArrowLocation(ArrowGeom arrowGeom, double[] dArray, double[] dArray2, int n, int n2) {
        if (arrowGeom != null) {
            double d = PolyShape.getAngleAtLocation(dArray, dArray2, n, n2);
            arrowGeom.setAngle(d);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = arrowGeom.getTipSize();
            int n3 = n;
            dArray[n3] = dArray[n3] + d2 * d4;
            int n4 = n;
            dArray2[n4] = dArray2[n4] + d3 * d4;
            arrowGeom.setPos(dArray[n], dArray2[n]);
            double d5 = arrowGeom.getLength() - d4;
            int n5 = n;
            dArray[n5] = dArray[n5] + d2 * d5;
            int n6 = n;
            dArray2[n6] = dArray2[n6] + d3 * d5;
        }
    }

    private static double getAngleAtLocation(double[] dArray, double[] dArray2, int n, int n2) {
        return Math.atan2(dArray2[n + n2] - dArray2[n], dArray[n + n2] - dArray[n]);
    }

    @Deprecated
    static String makeGeneralPath(double[] dArray, double[] dArray2, char[] cArray, ArrowGeom arrowGeom, ArrowGeom arrowGeom2) {
        int n = dArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        PolyShape.setupArrowLocation(arrowGeom, dArray, dArray2, 0, 1);
        PolyShape.setupArrowLocation(arrowGeom2, dArray, dArray2, n - 1, -1);
        for (int i = 0; i < n; ++i) {
            if (cArray == null) {
                stringBuilder.append(i == 0 ? "M" : "L");
            } else {
                stringBuilder.append(cArray[i]);
            }
            if (cArray != null && cArray[i] == 'Z') continue;
            stringBuilder.append(MathUtil.r3(dArray[i]) + "," + MathUtil.r3(dArray2[i]));
        }
        return stringBuilder.toString();
    }

    @Override
    public double area() {
        return PolyGeom.area(this.x, this.y);
    }

    public Point centroid() {
        return PolyGeom.centroid(this.x, this.y);
    }

    @Override
    public final double[] getXArray() {
        return this.x;
    }

    @Override
    public final double[] getYArray() {
        return this.y;
    }
}

