/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

public class PotentialRect {
    static final PotentialRect NONE = new PotentialRect(null, null);
    private final int[] fittingHeightGivenWidth;
    private final int fittingAcross;
    private int bestWidth;

    PotentialRect(PotentialRect potentialRect, PotentialRect potentialRect2) {
        if (potentialRect == null) {
            this.fittingHeightGivenWidth = new int[]{0};
            this.fittingAcross = 0;
            this.bestWidth = 0;
        } else {
            this.bestWidth = 1;
            this.fittingAcross = 1 + potentialRect.fittingAcross;
            this.fittingHeightGivenWidth = new int[this.fittingAcross + 1];
            for (int i = 1; i <= this.fittingAcross; ++i) {
                this.fittingHeightGivenWidth[i] = 1 + potentialRect2.getMaxHeightForWidth(i);
                if (i * this.fittingHeightGivenWidth[i] <= this.bestWidth * this.fittingHeightGivenWidth[this.bestWidth]) continue;
                this.bestWidth = i;
            }
        }
    }

    private int getMaxHeightForWidth(int n) {
        return n < this.fittingHeightGivenWidth.length ? this.fittingHeightGivenWidth[n] : 0;
    }

    int getBestWidth() {
        return this.bestWidth;
    }

    int getBestHeight() {
        return this.fittingHeightGivenWidth[this.bestWidth];
    }
}

