/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SchemaSceneNode;
import com.ibm.vis.spec.internal.BoundsSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Schema
extends Shape {
    public static final String META_KEY_PART = "part";
    private Shape[] parts;
    private boolean filled;

    public Schema(double d, double d2, double d3, double d4, Shape[] shapeArray, boolean bl) {
        this.shapeType = 1010;
        this.setParts(shapeArray);
        this.geom = new Rect(d, d2, d3, d4);
        this.filled = bl;
    }

    @Override
    public SceneNodeImpl createSceneNode() {
        SchemaSceneNode schemaSceneNode = (SchemaSceneNode)SceneNodeFactory.createShapeNode(this);
        for (Shape shape : this.getParts()) {
            SceneNodeImpl sceneNodeImpl = shape.createSceneNode();
            schemaSceneNode.addChild(sceneNodeImpl);
        }
        return schemaSceneNode;
    }

    @Override
    public Geom getRenderGeom(double d) {
        return null;
    }

    @Override
    public int getType() {
        return 1010;
    }

    @Override
    public Geom asBasic() {
        return this.getBounds();
    }

    @Override
    public Shape makeGeometryClone() {
        return new Schema(((Rect)this.geom).getX(), ((Rect)this.geom).getY(), ((Rect)this.geom).getWidth(), ((Rect)this.geom).getHeight(), this.getParts(), this.filled);
    }

    @Override
    public boolean isFilled() {
        return this.filled;
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, boolean bl) {
        super.affine(d, d2, d3, d4, bl);
        double d5 = d;
        double d6 = d3;
        if (!bl) {
            if (!this.canScaleX()) {
                d5 = 1.0;
            }
            if (!this.canScaleY()) {
                d6 = 1.0;
            }
        }
        for (Shape shape : this.getParts()) {
            shape.affine(d5, d2, d6, d4, false);
        }
    }

    @Override
    public void copyInfoFrom(Shape shape) {
        super.copyInfoFrom(shape);
        for (Shape shape2 : this.getParts()) {
            shape2.copyInfoFrom(shape);
        }
    }

    @Override
    protected Rect calculateBounds() {
        Rect rect = null;
        if (this.getParts().length == 0) {
            rect = this.geom.getBounds();
        } else {
            Rect rect2 = this.getParts()[0].getBounds();
            double d = rect2.getX();
            double d2 = rect2.getY();
            double d3 = rect2.getX() + rect2.getWidth();
            double d4 = rect2.getY() + rect2.getHeight();
            for (int i = 1; i < this.getParts().length; ++i) {
                Shape shape = this.getParts()[i];
                Rect rect3 = shape.getBounds();
                d = d > rect3.getX() ? rect3.getX() : d;
                d2 = d2 > rect3.getY() ? rect3.getY() : d2;
                double d5 = rect3.getX() + rect3.getWidth();
                double d6 = rect3.getY() + rect3.getHeight();
                d3 = d3 < d5 ? d5 : d3;
                d4 = d4 < d6 ? d6 : d4;
            }
            rect = new Rect(d, d2, d3 - d, d4 - d2);
        }
        return rect;
    }

    @Override
    public void setRows(int[] nArray) {
        super.setRows(nArray);
        for (Shape shape : this.getParts()) {
            shape.setRows(nArray);
            shape.setKey(this.getKey());
        }
    }

    @Override
    public void setID(String string) {
        super.setID(string);
        int n = 0;
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        this.getAllChildShapes(arrayList, this.getParts());
        for (Shape shape : arrayList) {
            if (shape instanceof Schema) {
                shape.setID(string + "_" + n);
            } else {
                shape.setID(string + "_" + n);
            }
            ++n;
        }
    }

    private void getAllChildShapes(List<Shape> list, Shape[] shapeArray) {
        if (shapeArray == null) {
            return;
        }
        for (int i = 0; i < shapeArray.length; ++i) {
            list.add(shapeArray[i]);
            if (!(shapeArray[i] instanceof Schema)) continue;
            this.getAllChildShapes(list, ((Schema)shapeArray[i]).getParts());
        }
    }

    @Override
    public Shape[] getParts() {
        return this.parts;
    }

    @Override
    public void transpose(Dim dim) {
        super.transpose(dim);
        for (Shape shape : this.getParts()) {
            shape.transpose(dim);
        }
    }

    public Shape fetchPartByName(String string) {
        if (this.getParts() != null) {
            for (Shape shape : this.getParts()) {
                assert (shape != null);
                String string2 = shape.getMeta(META_KEY_PART);
                if (string2 == null || !string2.equals(string)) continue;
                return shape;
            }
        }
        return null;
    }

    public void setParts(Shape[] shapeArray) {
        for (Shape shape : this.parts = shapeArray == null ? new Shape[]{} : shapeArray) {
            if (shape.getContainingShape() != null) continue;
            shape.setContainingShape(this);
        }
        this.invalidate();
    }

    public void recalcuateBounds() {
        Rect rect = this.getParts()[0].getBounds().copy();
        for (int i = 1; i < this.getParts().length; ++i) {
            rect.extendToRect(this.getParts()[i].getBounds());
        }
        this.geom = rect.copy();
    }

    @Override
    protected Rect getEnclosedShapeBounds(BoundsSpec boundsSpec) {
        this.getBounds();
        Rect rect = (Rect)this.geom.copy();
        Bounds bounds = new Bounds(boundsSpec, null);
        return bounds.getRectWithinParent(rect);
    }

    @Override
    protected void invalidate() {
        if (this.getCachedBounds() == null) {
            return;
        }
        super.invalidate();
        if (this.parts != null) {
            for (Shape shape : this.parts) {
                shape.invalidate();
            }
        }
    }
}

