/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.ImageStyle;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.geom.GeomInternalUtilities;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.ArrowGeom;
import com.ibm.vis.engine.internal.struct.ArrowType;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.ShapeBoundsInfo;
import com.ibm.vis.engine.internal.struct.ShapeEdgeInfo;
import com.ibm.vis.engine.internal.struct.ShapeElementInfo;
import com.ibm.vis.engine.internal.struct.ShapeStyle;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.geom.RoundedRect;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.ElementInfo;
import com.ibm.vis.scenetree.provisional.FieldInfo;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.scenetree.provisional.StyleInfo;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Shape
implements ShapeInfo {
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String SHAPE = "shape";
    public static final String STROKE = "stroke";
    public static final String TYPE = "type";
    Geom geom;
    int shapeType = -1;
    private ShapeStyle styleInfo;
    private ShapeElementInfo elementInfo;
    private FieldInfo fieldInfo;
    protected ShapeBoundsInfo boundsInfo;
    private AccessibleInfo a11y;
    protected TransformInfoImpl transform = new TransformInfoImpl();
    private ShapeEdgeInfo edgeInfo;
    private String id;
    protected boolean tooltipSet;
    private String tooltip;
    private String formattedTooltip;
    private boolean useBoundsForLabel;
    private Geom globalGradientGeometry;
    private Dim actualDim;
    protected Rect cachedBounds = null;
    private String reversed = null;
    private Rect nodeBounds;
    private boolean _isElement = false;
    public static final String BOTH = "both";
    public static final String Y = "y";
    public static final String X = "x";

    @Override
    public int type() {
        Geom geom = this.getRenderGeom(0.0);
        return geom == null ? -1 : geom.type();
    }

    public final void setColorAestheticOnlyChangesOutline(boolean bl) {
        this.ensureElement().colorAestheticOnlyChangesOutline = bl;
    }

    public final boolean getColorAestheticOnlyChangesOutline() {
        return this.elementInfo == null ? false : this.elementInfo.colorAestheticOnlyChangesOutline;
    }

    protected Shape() {
        this.setAestheticGroup(0);
        this.tooltipSet = false;
        this.shapeType = 0;
    }

    public SceneNodeImpl createSceneNode() {
        return SceneNodeFactory.createShapeNode(this);
    }

    public Geom getRenderGeom(double d) {
        if (this.geom == null) {
            return null;
        }
        return GeomInternalUtilities.getRendererGeom(this.getGeom(), d, this.getSnap());
    }

    public int getType() {
        return this.shapeType;
    }

    public final boolean isPrimaryTextType() {
        return this.getType() == 1009 || this.getType() == 1007;
    }

    public boolean isGlyphLike() {
        return this.getScaleDimensions() == 0;
    }

    public void setGlyphLike() {
        this.setScaleDimensions(0);
    }

    public boolean canScaleBoth() {
        return this.getScaleDimensions() == 3;
    }

    public boolean canScaleX() {
        return (this.getScaleDimensions() & 1) > 0;
    }

    public boolean canScaleY() {
        return (this.getScaleDimensions() & 2) > 0;
    }

    public final int getScaleDimensions() {
        return this.boundsInfo == null ? 3 : this.boundsInfo.scaleDimensions;
    }

    public final void setScaleDimensions(int n) {
        this.ensureBoundsInfo().scaleDimensions = n;
        this.invalidate();
    }

    public final Position getPosition() {
        return this.elementInfo == null ? null : this.elementInfo.getPosition();
    }

    public final Position[] getPositions() {
        return this.elementInfo == null ? null : this.elementInfo.getPositions();
    }

    public final void setPosition(Position position) {
        this.ensureElement().setPosition(position);
    }

    public final void setPositions(Position[] positionArray) {
        this.ensureElement().setPositions(positionArray);
    }

    public final void setRow(int n) {
        this.setRows(new int[]{n});
    }

    public void setRows(int[] nArray) {
        this.ensureElement().rows = nArray;
    }

    public void setStructuralRows(int[] nArray) {
        this.ensureElement().setStructuralRows(nArray);
    }

    public int[] getStructuralRows() {
        return this.ensureElement().getStructuralRows();
    }

    public final void setOriginalRows(int[] nArray) {
        this.ensureElement().setOriginalRows(nArray);
    }

    public final int[] getOriginalRows() {
        return this.ensureElement().getOriginalRows();
    }

    public TransformInfoImpl getTransformInfo() {
        return this.transform;
    }

    public Affine getTransform() {
        return this.transform.getAffine();
    }

    public void setTransform(Affine affine) {
        this.transform.setAffine(affine);
    }

    public final String getMeta(String string) {
        return this.elementInfo == null || this.elementInfo.meta == null ? null : this.elementInfo.meta.get(string);
    }

    public final Map<String, String> getMetaMap() {
        return this.elementInfo == null ? null : this.elementInfo.meta;
    }

    private Map<String, String> getAllMeta() {
        if (this.elementInfo == null || this.elementInfo.meta == null || this.elementInfo.meta.size() == 0) {
            return null;
        }
        return this.elementInfo.meta;
    }

    public final void setMeta(String string, Object object) {
        this.ensureElement().setMeta(string, object);
    }

    public String getElementPart() {
        return this.getMeta("part");
    }

    public final void addMeta(Shape shape) {
        if (this == shape || shape.getAllMeta() == null) {
            return;
        }
        this.ensureElement().setAllMeta(shape.getAllMeta());
    }

    public AccessibleInfo getA11yInfo() {
        if (this.a11y == null) {
            this.a11y = new AccessibleInfo();
        }
        return this.a11y;
    }

    public void reflect(Dim dim, boolean bl) {
        this.geom.reflect(dim, bl);
    }

    public void transpose(Dim dim) {
        this.ensureBoundsInfo();
        this.boundsInfo.scaleDimensions = this.geom.transpose(dim, this.boundsInfo.scaleDimensions);
        this.invalidate();
    }

    public boolean isFilled() {
        return this.geom.filled();
    }

    public final void scale(double d, double d2) {
        Point point = this.getScalingAnchor();
        this.affine(d, point.getX() * (1.0 - d), d2, point.getY() * (1.0 - d2), true);
        this.modifyActualDim(d, d2);
        this.invalidate();
    }

    protected Point getScalingAnchor() {
        return this.getCenter();
    }

    public Point getCenter() {
        return this.geom.getCenter();
    }

    private void modifyActualDim(double d, double d2) {
        if (this.actualDim != null) {
            this.actualDim.setWidth(this.actualDim.getWidth() * d);
            this.actualDim.setHeight(this.actualDim.getHeight() * d2);
        }
    }

    public void affine(double d, double d2, double d3, double d4, boolean bl) {
        int n = this.getScaleDimensions();
        Rect rect = null;
        String string = null;
        if (bl) {
            n = 3;
        }
        if (this.getContainingShape() != null && this.isRelativeToParent()) {
            if (this.geom.type() == 1002) {
                string = this.getMeta(TYPE);
            }
            if (!(this.geom.type() == 1003 && 1001 == this.getType() || this.geom.type() == 1002 && string == null)) {
                rect = this.getContainingShape().getEnclosedShapeBounds(this.getBoundsSpec());
            }
        }
        this.geom.affine(d, d2, d3, d4, rect, n);
        this.invalidate();
    }

    public Shape makeGeometryClone() {
        Shape shape = new Shape();
        shape.shapeType = this.shapeType;
        shape.geom = this.geom.copy();
        shape.setSnap(this.getSnap());
        return shape;
    }

    protected boolean hasRenderStroke() {
        Stroke stroke = this.getStroke();
        boolean bl = stroke != null && stroke.getWidth() == 0.0;
        Stroke stroke2 = stroke = bl ? null : stroke;
        if (stroke != null) {
            return true;
        }
        Fill fill = this.getFill();
        return this.isFilled() ? this.getOutline() != null && !bl : fill != null && !bl;
    }

    public void copyInfoFrom(Shape shape) {
        if (this == shape) {
            return;
        }
        this.styleInfo = ShapeStyle.makeCopy(shape.styleInfo);
        this.transform.setAffine(shape.transform.getAffine());
        this.a11y = AccessibleInfo.makeCopy(shape.a11y);
        this.setRows(shape.getRows());
        this.tooltip = shape.tooltip;
        this.formattedTooltip = shape.formattedTooltip;
        this.tooltipSet = shape.tooltipSet;
        this.setStartArrowByName(shape.getStartArrowName());
        this.setEndArrowByName(shape.getEndArrowName());
        if (shape.globalGradientGeometry != null) {
            this.globalGradientGeometry = shape.globalGradientGeometry;
        }
        this.addMeta(shape);
        this.setKey(shape.getKey());
        this.setNeedsConsistentLabels(shape.getNeedsConsistentLabels());
        this.setTemporaryTreeMapNodeInfo(shape.getTemporaryTreeMapNodeInfo());
    }

    public void setGlobalGradient(Geom geom) {
        this.globalGradientGeometry = geom;
    }

    public void setGlobalGradientFromRect(double d, double d2, double d3, double d4) {
        this.globalGradientGeometry = new Rect(d, d2, d3, d4);
    }

    public void setGlobalGradientFromCircle(double d, double d2, double d3) {
        this.globalGradientGeometry = new Circle(d, d2, d3);
    }

    public Geom getGlobalGradientGeometry() {
        return this.globalGradientGeometry;
    }

    public Geom getLocalGradientGeometry() {
        if (this.shapeType == 1000) {
            return this.geom.copy();
        }
        Shape shape = this.getContainingShape();
        Rect rect = this.getBounds();
        if (shape != null && rect.getWidth() <= 1.0 && rect.getHeight() <= 1.0) {
            Bounds bounds = new Bounds(this.getBoundsSpec(), null);
            Rect rect2 = shape.getBounds();
            rect = bounds.getRectWithinParent(rect2);
        }
        return new Rect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public final String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public double getStrokeWidth() {
        Rect rect;
        double d;
        if (this.getStroke() == null) {
            return this.getOutline() != null ? 1.0 : 0.0;
        }
        double d2 = this.getStroke().getWidth();
        if (d2 == 0.0) {
            return 0.0;
        }
        if (this.isInsideStroke() && d2 >= (d = Math.min((rect = this.getBounds()).getWidth(), rect.getHeight()) / 2.0)) {
            d2 = d2 > 1.0 ? d + 1.0 : d;
        }
        return d2;
    }

    @Deprecated
    public static Shape toShapeRect(Object object) {
        Rect rect = Shape.toRect(object);
        if (rect != null) {
            Shape shape = new Shape();
            shape.shapeType = 1004;
            shape.setGeom(rect, 1004);
            return shape;
        }
        return null;
    }

    @Deprecated
    public static Rect toRect(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Rect) {
            return (Rect)object;
        }
        Number number = (Number)BasicFactory.getItem(object, X);
        Number number2 = (Number)BasicFactory.getItem(object, Y);
        Number number3 = (Number)BasicFactory.getItem(object, WIDTH);
        Number number4 = (Number)BasicFactory.getItem(object, HEIGHT);
        if (number == null || number2 == null || number3 == null || number4 == null) {
            return null;
        }
        return new Rect(number.doubleValue(), number2.doubleValue(), number3.doubleValue(), number4.doubleValue());
    }

    public Shape getLabelShape(String string, String string2, String string3) {
        return this;
    }

    public double getTangentAngle(String string, String string2) {
        if ("start".equals(string)) {
            return -1.5707963267948966;
        }
        if ("end".equals(string)) {
            return 1.5707963267948966;
        }
        return 0.0;
    }

    public int[] getRows() {
        return this.elementInfo == null ? null : this.elementInfo.rows;
    }

    public Geom applyPointTransform(PointTransform pointTransform) {
        Geom geom;
        if (this.geom != null && (geom = this.geom.applyPointTransform(pointTransform)) != this.geom) {
            return geom;
        }
        return null;
    }

    public Shape getPart(int n) {
        Shape[] shapeArray = this.getParts();
        if (shapeArray == null || n < 0 || n > shapeArray.length) {
            return null;
        }
        return shapeArray[n];
    }

    public Shape getPartByName(String string) {
        if (string == null || string.equals(this.getElementPart())) {
            return this;
        }
        Shape[] shapeArray = this.getParts();
        if (shapeArray != null) {
            for (Shape shape : shapeArray) {
                Shape shape2 = shape.getPartByName(string);
                if (shape2 == null) continue;
                return shape2;
            }
        }
        return null;
    }

    public final Shape getContainingShape() {
        return this.boundsInfo == null ? null : this.boundsInfo.containingShape;
    }

    public Shape[] getParts() {
        return null;
    }

    public Point getOuterPoint() {
        Point point = this.getCenter();
        if (this.getContainingShape() == null) {
            return point;
        }
        Point point2 = this.getContainingShape().getCenter();
        return new Point(point2.getX() + 2.0 * (point.getX() - point2.getX()), point2.getY() + 2.0 * (point.getY() - point2.getY()));
    }

    public String getFacetKey() {
        int n;
        String string = "";
        if (this.getPosition() != null && this.getPosition().base != null && this.getPosition().length() > 2) {
            string = string + this.getPosition().get(2);
            n = this.getPosition().length();
            for (int i = 3; i < n; ++i) {
                string = string + "|" + this.getPosition().get(i);
            }
        }
        if (this.getPosition() != null && this.getPosition().facet != null) {
            for (n = 0; n < this.getPosition().facet.length; ++n) {
                string = string + "|" + this.getPosition().facet[n];
            }
        }
        return string;
    }

    public String getStartArrowName() {
        if (this.getStartArrow() == null) {
            return null;
        }
        return this.getStartArrow().getName();
    }

    public String getEndArrowName() {
        if (this.getEndArrow() == null) {
            return null;
        }
        return this.getEndArrow().getName();
    }

    public void setStartArrowByName(String string) {
        this.setStartArrow(ArrowType.byName(string));
    }

    public void setEndArrowByName(String string) {
        this.setEndArrow(ArrowType.byName(string));
    }

    public boolean contains(double d, double d2) {
        return this.geom.containsPt(d, d2);
    }

    public final Rect getBounds() {
        if (this.cachedBounds == null) {
            this.cachedBounds = this.calculateBounds();
        }
        return this.cachedBounds;
    }

    protected Rect calculateBounds() {
        return this.geom.getBounds().copy();
    }

    public Dim getActualDim() {
        return this.actualDim;
    }

    public void setActualDim(Dim dim) {
        this.actualDim = dim;
        this.invalidate();
    }

    public Geom asBasic() {
        return this.geom.asBasic();
    }

    public final boolean isElement() {
        return this._isElement;
    }

    public final void setIsElement(boolean bl) {
        this._isElement = bl;
    }

    public final boolean getSnap() {
        return this.styleInfo == null ? false : this.styleInfo.snap;
    }

    public final void setSnap(boolean bl) {
        if (this.styleInfo != null || bl) {
            this.ensureStyle().snap = bl;
        }
    }

    public final Stroke getStroke() {
        return this.styleInfo == null ? null : this.styleInfo.stroke;
    }

    public double getOutsideStrokeWidth() {
        double d = this.getStrokeWidth();
        if (this.isInsideStroke()) {
            d = 0.0;
        }
        return d / 2.0;
    }

    public final void setStroke(Stroke stroke) {
        this.ensureStyle().setStroke(stroke);
        this.invalidate();
    }

    public final boolean isInsideStroke() {
        return this.styleInfo == null ? false : this.styleInfo.insideStroke;
    }

    public final void setInsideStroke(boolean bl) {
        this.ensureStyle().insideStroke = bl;
        this.invalidate();
    }

    public final boolean isVisible() {
        return this.styleInfo == null ? true : !this.styleInfo.hidden;
    }

    public final void setVisible(boolean bl) {
        this.ensureStyle().hidden = !bl;
    }

    public final boolean isRelativeToParent() {
        return this.boundsInfo == null ? false : this.boundsInfo.scaleRelativeToParent;
    }

    public void setRelativeToParent(boolean bl) {
        this.ensureBoundsInfo().scaleRelativeToParent = bl;
        this.invalidate();
    }

    protected Rect getEnclosedShapeBounds(BoundsSpec boundsSpec) {
        Rect rect = this.getBounds();
        Bounds bounds = new Bounds(boundsSpec, null);
        return bounds.getRectWithinParent(rect);
    }

    public void setDefaultStyle(StyleSpec styleSpec) {
        this.setSnap(StyleBuilder.getSnap(styleSpec));
        if (this.shapeType == 1004 && !StyleBuilder.isThresholdStyleSpec(styleSpec)) {
            if (styleSpec == null) {
                StyleBuilder.setDefaultFillStyle(this);
            } else {
                StyleBuilder.setFilled(this, styleSpec);
            }
        }
    }

    public void setNeedsConsistentLabels(boolean bl) {
        this.ensureElement().needsConsistentLabels = bl;
    }

    public boolean getNeedsConsistentLabels() {
        return this.ensureElement().needsConsistentLabels;
    }

    public void setTemporaryTreeMapNodeInfo(Object object) {
        this.ensureElement().temporaryTreeMapNodeInfo = object;
    }

    public Object getTemporaryTreeMapNodeInfo() {
        return this.ensureElement().temporaryTreeMapNodeInfo;
    }

    public boolean hasTooltip() {
        return this.tooltipSet;
    }

    public String getDisplayTooltip() {
        return this.formattedTooltip != null ? this.formattedTooltip : this.tooltip;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    public String getFormattedTooltip() {
        return this.formattedTooltip;
    }

    public void setTooltip(String string) {
        this.tooltipSet = true;
        this.tooltip = string;
    }

    public void setFormattedTooltip(String string) {
        this.tooltipSet = true;
        this.formattedTooltip = string;
    }

    public double area() {
        return this.geom.area();
    }

    public final Rect getSpanClipBounds() {
        return this.elementInfo == null ? null : this.elementInfo.spanClipBounds;
    }

    public final void setSpanClipBounds(Rect rect) {
        this.ensureElement().spanClipBounds = rect;
        this.invalidate();
    }

    public Fill getFill() {
        return this.styleInfo == null ? null : this.styleInfo.fill;
    }

    public void setFill(Fill fill) {
        this.ensureStyle().fill = fill;
    }

    public ImageStyle getImage() {
        return this.styleInfo == null ? null : this.styleInfo.image;
    }

    public void setImage(ImageStyle imageStyle) {
        this.ensureStyle().image = imageStyle;
    }

    public ColorNew getOutline() {
        return this.styleInfo == null ? null : this.styleInfo.outline;
    }

    public void setOutline(ColorNew colorNew) {
        this.ensureStyle().outline = colorNew;
    }

    public RenderEffects getEffect() {
        return this.styleInfo == null ? null : this.styleInfo.effect;
    }

    public void setEffect(RenderEffects renderEffects) {
        this.ensureStyle().setEffect(renderEffects);
    }

    private final ShapeStyle ensureStyle() {
        if (this.styleInfo == null) {
            this.styleInfo = new ShapeStyle();
        }
        return this.styleInfo;
    }

    private final ShapeElementInfo ensureElement() {
        if (this.elementInfo == null) {
            this.elementInfo = new ShapeElementInfo();
        }
        return this.elementInfo;
    }

    private final ShapeBoundsInfo ensureBoundsInfo() {
        if (this.boundsInfo == null) {
            this.boundsInfo = new ShapeBoundsInfo(this.getXArray(), this.getYArray());
        }
        return this.boundsInfo;
    }

    public int getIndex() {
        return this.elementInfo == null ? null : Integer.valueOf(this.elementInfo.index);
    }

    public void setIndex(int n) {
        this.ensureElement().index = n;
    }

    public double getRowValue() {
        return this.elementInfo.getValue();
    }

    public void setRowValue(double d) {
        this.ensureElement().setValue(d);
    }

    public int getAestheticGroup() {
        return this.elementInfo == null ? null : Integer.valueOf(this.elementInfo.aestheticGroup);
    }

    public void setAestheticGroup(int n) {
        this.ensureElement().aestheticGroup = n;
    }

    @Override
    public String getKey() {
        return this.elementInfo == null ? null : this.elementInfo.key;
    }

    @Override
    public void setKey(String string) {
        this.ensureElement().key = string;
    }

    public final BoundsSpec getBoundsSpec() {
        return this.boundsInfo == null ? null : this.boundsInfo.boundsSpec;
    }

    public final void setBoundsSpec(BoundsSpec boundsSpec) {
        if (this.boundsInfo != null || boundsSpec != null) {
            this.ensureBoundsInfo().boundsSpec = boundsSpec;
            this.invalidate();
        }
    }

    public final Insets getInsets() {
        return this.boundsInfo == null ? null : this.boundsInfo.insets;
    }

    public final void setInsets(Insets insets) {
        if (this.boundsInfo != null || insets != null && insets != Insets.NONE) {
            this.ensureBoundsInfo().insets = insets;
            this.invalidate();
        }
    }

    public final void setContainingShape(Shape shape) {
        if (shape != null) {
            this.ensureBoundsInfo().containingShape = shape;
            this.invalidate();
        }
    }

    public double[] getXArray() {
        return null;
    }

    public double[] getYArray() {
        return null;
    }

    protected void invalidate() {
        this.cachedBounds = null;
        if (this.boundsInfo != null && this.boundsInfo.containingShape != null) {
            this.boundsInfo.containingShape.invalidate();
        }
    }

    protected final Rect getCachedBounds() {
        return this.cachedBounds;
    }

    protected final void setCachedBounds(Rect rect) {
        this.cachedBounds = rect;
    }

    public void setReversed(String string) {
        this.reversed = string;
    }

    public String getReversed() {
        return this.reversed;
    }

    @Override
    public Geom getGeom() {
        return this.geom;
    }

    @Override
    public void setGeom(Geom geom, Integer n) {
        this.geom = geom;
        if (n != null) {
            this.shapeType = n;
        }
        this.cachedBounds = null;
    }

    @Override
    public final StyleInfo getStyleInfo() {
        return this.styleInfo;
    }

    @Override
    public final ElementInfo getElementInfo() {
        return this.elementInfo;
    }

    @Override
    public TextInfo getTextInfo() {
        return null;
    }

    @Override
    public final FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public final String getField() {
        return this.fieldInfo == null ? null : this.fieldInfo.getId();
    }

    public final Object getValue() {
        return this.fieldInfo == null ? null : this.fieldInfo.getValue();
    }

    private FieldInfo ensureFieldInfo() {
        if (this.fieldInfo == null) {
            this.fieldInfo = new FieldInfo();
        }
        return this.fieldInfo;
    }

    public void setField(String string) {
        this.ensureFieldInfo().setId(string);
    }

    public void setValue(Object object) {
        this.ensureFieldInfo().setValue(object);
    }

    @Override
    public Rect getNodeBounds() {
        if (this.nodeBounds != null) {
            return this.nodeBounds;
        }
        return this.getBounds();
    }

    public void setNodeBounds(Rect rect) {
        this.nodeBounds = rect;
    }

    public static Rect transformBounds(Rect rect, Affine affine) {
        if (rect == null || affine == null) {
            return rect;
        }
        Point point = affine.transform(rect.getX(), rect.getY());
        Point point2 = affine.transform(rect.getX() + rect.getWidth(), rect.getY());
        Point point3 = affine.transform(rect.getX(), rect.getY() + rect.getHeight());
        Point point4 = affine.transform(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight());
        double d = Math.min(Math.min(point.getX(), point2.getX()), Math.min(point3.getX(), point4.getX()));
        double d2 = Math.min(Math.min(point.getY(), point2.getY()), Math.min(point3.getY(), point4.getY()));
        double d3 = Math.max(Math.max(point.getX(), point2.getX()), Math.max(point3.getX(), point4.getX()));
        double d4 = Math.max(Math.max(point.getY(), point2.getY()), Math.max(point3.getY(), point4.getY()));
        return new Rect(d, d2, d3 - d, d4 - d2);
    }

    public double getX() {
        if (this.geom.type() == 1002) {
            return ((Rect)this.geom).getX();
        }
        if (this.geom.type() == 1001) {
            return ((Circle)this.geom).getX();
        }
        if (this.geom.type() == 1005) {
            return ((RoundedRect)this.geom).getX();
        }
        assert (false);
        return 0.0;
    }

    public double getY() {
        if (this.geom.type() == 1002) {
            return ((Rect)this.geom).getY();
        }
        if (this.geom.type() == 1001) {
            return ((Circle)this.geom).getY();
        }
        if (this.geom.type() == 1005) {
            return ((RoundedRect)this.geom).getY();
        }
        assert (false);
        return 0.0;
    }

    public double getR() {
        if (this.geom.type() == 1001) {
            return ((Circle)this.geom).getR();
        }
        if (this.geom.type() == 1005) {
            return ((RoundedRect)this.geom).getCornerRadius();
        }
        assert (false);
        return 0.0;
    }

    public double getWidth() {
        if (this.geom.type() == 1002) {
            return ((Rect)this.geom).getWidth();
        }
        if (this.geom.type() == 1005) {
            return ((RoundedRect)this.geom).getWidth();
        }
        assert (false);
        return 0.0;
    }

    public double getHeight() {
        if (this.geom.type() == 1002) {
            return ((Rect)this.geom).getHeight();
        }
        if (this.geom.type() == 1005) {
            return ((RoundedRect)this.geom).getHeight();
        }
        assert (false);
        return 0.0;
    }

    public void setX(double d) {
        if (this.geom.type() == 1002) {
            ((Rect)this.geom).setX(d);
        }
        if (this.geom.type() == 1005) {
            ((RoundedRect)this.geom).setX(d);
        }
        if (this.geom.type() == 1001) {
            ((Circle)this.geom).setX(d);
        }
        this.invalidate();
    }

    public void setY(double d) {
        if (this.geom.type() == 1002) {
            ((Rect)this.geom).setY(d);
        }
        if (this.geom.type() == 1005) {
            ((RoundedRect)this.geom).setY(d);
        }
        if (this.geom.type() == 1001) {
            ((Circle)this.geom).setY(d);
        }
        this.invalidate();
    }

    public void setWidth(double d) {
        if (this.geom.type() == 1002) {
            ((Rect)this.geom).setWidth(d);
        }
        if (this.geom.type() == 1005) {
            ((RoundedRect)this.geom).setWidth(d);
        }
        this.invalidate();
    }

    public void setHeight(double d) {
        if (this.geom.type() == 1002) {
            ((Rect)this.geom).setHeight(d);
        }
        if (this.geom.type() == 1005) {
            ((RoundedRect)this.geom).setHeight(d);
        }
        this.invalidate();
    }

    public final String getSymbol() {
        return this.edgeInfo == null ? null : this.edgeInfo.symbol;
    }

    public Boolean getPreferHorizontal() {
        return this.edgeInfo == null ? null : this.edgeInfo.preferHorizontal;
    }

    public final void setSymbol(String string) {
        if (this.lazyCreateEdgeInfo(string)) {
            this.edgeInfo.symbol = string;
        }
        this.invalidate();
    }

    private boolean lazyCreateEdgeInfo(Object object) {
        if (this.edgeInfo == null && object != null) {
            this.edgeInfo = new ShapeEdgeInfo();
        }
        return this.edgeInfo != null;
    }

    public ArrowType getStartArrow() {
        return this.edgeInfo == null ? null : this.edgeInfo.startArrow;
    }

    public void setStartArrow(ArrowType arrowType) {
        if (this.lazyCreateEdgeInfo(arrowType)) {
            this.edgeInfo.startArrow = arrowType;
        }
    }

    protected ArrowGeom getStartArrowGeom() {
        return this.edgeInfo == null ? null : this.edgeInfo.startArrowGeom;
    }

    protected void setStartArrowGeom(ArrowGeom arrowGeom) {
        if (this.lazyCreateEdgeInfo(arrowGeom)) {
            this.edgeInfo.startArrowGeom = arrowGeom;
        }
    }

    public ArrowType getEndArrow() {
        return this.edgeInfo == null ? null : this.edgeInfo.endArrow;
    }

    public void setEndArrow(ArrowType arrowType) {
        if (this.lazyCreateEdgeInfo(arrowType)) {
            this.edgeInfo.endArrow = arrowType;
        }
    }

    protected ArrowGeom getEndArrowGeom() {
        return this.edgeInfo == null ? null : this.edgeInfo.endArrowGeom;
    }

    protected void setEndArrowGeom(ArrowGeom arrowGeom) {
        if (this.lazyCreateEdgeInfo(arrowGeom)) {
            this.edgeInfo.endArrowGeom = arrowGeom;
        }
    }

    protected void setPreferHorizontal(Boolean bl) {
        if (this.lazyCreateEdgeInfo(bl)) {
            this.edgeInfo.preferHorizontal = bl;
        }
    }

    public void setEdgeProperties(Boolean bl, String string, String string2, String string3) {
        this.setPreferHorizontal(bl);
        this.setSymbol(string);
        this.setStartArrowByName(string2);
        this.setEndArrowByName(string3);
    }

    public final double[] getOriginalX() {
        return this.boundsInfo == null ? null : this.boundsInfo.originalX;
    }

    public final double[] getOriginalY() {
        return this.boundsInfo == null ? null : this.boundsInfo.originalY;
    }

    public boolean isUseBoundsForLabel() {
        return this.useBoundsForLabel;
    }

    public void setUseBoundsForLabel(boolean bl) {
        this.useBoundsForLabel = bl;
    }
}

