/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PathSegmentBuilder;
import com.ibm.vis.engine.internal.struct.PolyGeom;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Point;

@Deprecated
@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ShapeFactory {
    public static boolean areEqualAngles(double d, double d2, double d3) {
        double d4 = Math.abs(d - d2) % (Math.PI * 2);
        return d4 <= d3 || d4 >= Math.PI * 2 - d3;
    }

    public static String makeArcPath(double d, double d2, double d3, double d4, double d5) {
        StringBuilder stringBuilder = new StringBuilder();
        ShapeFactory.addCoord(stringBuilder, 'M', d + d3 * Math.cos(d4), d2 + d3 * Math.sin(d4));
        ShapeFactory.addArc(stringBuilder, d, d2, d3, d4, d5);
        return stringBuilder.toString();
    }

    public static double[] isArcPath(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = 0.125 * d + 0.375 * d3 + 0.375 * d5 + 0.125 * d7;
        double d10 = 0.125 * d2 + 0.375 * d4 + 0.375 * d6 + 0.125 * d8;
        double d11 = 0.5 * ((d7 - d9) * (d - d9) - (d8 - d10) * (d10 - d2));
        double d12 = (d - d7) * (d10 - d2) - (d8 - d2) * (d - d9);
        if (d12 == 0.0) {
            return null;
        }
        double d13 = d11 / d12;
        double d14 = 0.5 * (d + d7) + d13 * (d8 - d2);
        double d15 = 0.5 * (d2 + d8) + d13 * (d - d7);
        Point point = new Point(d14, d15);
        Point point2 = new Point(d, d2);
        Point point3 = new Point(d7, d8);
        double d16 = point.distance(point2);
        double d17 = 0.001 * d16;
        if (Math.abs(point.distance(point3) - d16) > d17) {
            return null;
        }
        Point point4 = new Point(d9, d10);
        if (Math.abs(point.distance(point4) - d16) > d17) {
            return null;
        }
        d9 = 0.421875 * d + 0.421875 * d3 + 0.140625 * d5 + 0.015625 * d7;
        d10 = 0.421875 * d2 + 0.421875 * d4 + 0.140625 * d6 + 0.015625 * d8;
        Point point5 = new Point(d9, d10);
        if (Math.abs(point.distance(point5) - d16) > d17) {
            return null;
        }
        d9 = 0.015625 * d + 0.140625 * d3 + 0.421875 * d5 + 0.421875 * d7;
        d10 = 0.015625 * d2 + 0.140625 * d4 + 0.421875 * d6 + 0.421875 * d8;
        Point point6 = new Point(d9, d10);
        if (Math.abs(point.distance(point6) - d16) > d17) {
            return null;
        }
        double d18 = point.angle(point2);
        double d19 = point.angle(point3);
        if (Math.abs(d19 - d18) > 1.6207963267948966) {
            d19 = d18 < d19 ? (d19 -= Math.PI * 2) : (d19 += Math.PI * 2);
        }
        return new double[]{d14, d15, d16, d18, d19};
    }

    public static String makePolyPath(double[] dArray, double[] dArray2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 77;
        for (int i = 0; i < dArray.length; ++i) {
            if (Math.abs(dArray[i]) < 1.0E20 && Math.abs(dArray2[i]) < 1.0E20) {
                ShapeFactory.addCoord(stringBuilder, (char)n, dArray[i], dArray2[i]);
                n = 76;
                continue;
            }
            if (bl && n == 76) {
                stringBuilder.append('Z');
            }
            n = 77;
        }
        if (bl && n == 76) {
            stringBuilder.append('Z');
        }
        return stringBuilder.toString();
    }

    public static String makeToroidSectionPath(double d, double d2, double d3, double d4, double d5, double d6) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = bl = Math.abs(d6 - d5) > 6.282185307179586;
        if (bl) {
            d6 = d6 > d5 ? d5 + Math.PI * 2 : d5 - Math.PI * 2;
        }
        ShapeFactory.addCoord(stringBuilder, 'M', d + d3 * Math.cos(d5), d2 + d3 * Math.sin(d5));
        ShapeFactory.addArc(stringBuilder, d, d2, d3, d5, d6);
        if (bl) {
            ShapeFactory.addCoord(stringBuilder, 'M', d + d4 * Math.cos(d6), d2 + d4 * Math.sin(d6));
        } else {
            ShapeFactory.addCoord(stringBuilder, 'L', d + d4 * Math.cos(d6), d2 + d4 * Math.sin(d6));
        }
        ShapeFactory.addArc(stringBuilder, d, d2, d4, d6, d5);
        if (!bl) {
            stringBuilder.append('Z');
        }
        return stringBuilder.toString();
    }

    public static String makeInsetToroidSectionPath(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        boolean bl;
        if (d7 <= 0.0) {
            return ShapeFactory.makeToroidSectionPath(d, d2, d3, d4, d5, d6);
        }
        d3 += d7;
        d4 -= d7;
        boolean bl2 = bl = Math.abs(d6 - d5) > 6.282185307179586;
        if (bl) {
            return ShapeFactory.makeToroidSectionPath(d, d2, d3, d4, d5, d6);
        }
        StringBuilder stringBuilder = new StringBuilder();
        double d8 = Math.abs(d6 - d5) / 2.0;
        double d9 = Math.min(Math.asin(d7 / d3), d8);
        double d10 = Math.min(Math.asin(d7 / d4), d8);
        if (d6 < d5) {
            d9 = -d9;
            d10 = -d10;
        }
        ShapeFactory.addCoord(stringBuilder, 'M', d + d3 * Math.cos(d5 + d9), d2 + d3 * Math.sin(d5 + d9));
        ShapeFactory.addArc(stringBuilder, d, d2, d3, d5 + d9, d6 - d9);
        ShapeFactory.addCoord(stringBuilder, 'L', d + d4 * Math.cos(d6 - d10), d2 + d4 * Math.sin(d6 - d10));
        ShapeFactory.addArc(stringBuilder, d, d2, d4, d6 - d10, d5 + d10);
        stringBuilder.append('Z');
        return stringBuilder.toString();
    }

    public static double[] isWedgePath(String string) {
        boolean bl;
        int n;
        boolean bl2;
        PolyGeom polyGeom = PolyGeom.makePolyGeom(string);
        int n2 = polyGeom.getTypes().length;
        if (n2 < 3 || polyGeom.getTypes()[0] != 'M') {
            return null;
        }
        if (n2 == 3) {
            if (polyGeom.getTypes()[1] == 'L' && polyGeom.getTypes()[2] == 'Z') {
                Point point = new Point(polyGeom.getX()[0], polyGeom.getY()[0]);
                Point point2 = new Point(polyGeom.getX()[1], polyGeom.getY()[1]);
                double d = point.distance(point2);
                double d2 = point.angle(point2);
                return new double[]{point.getX(), point.getY(), 0.0, d, d2, d2};
            }
            return null;
        }
        boolean bl3 = bl2 = polyGeom.getTypes()[n2 - 1] == 'Z';
        if (bl2) {
            --n2;
        }
        if (polyGeom.getTypes()[1] != 'M' && polyGeom.getTypes()[1] != 'L' && polyGeom.getTypes()[1] != 'C') {
            return null;
        }
        for (n = 1; n < n2 && polyGeom.getTypes()[n] == 'C'; n += 3) {
        }
        if (n >= n2 || polyGeom.getTypes()[n] != 'M' && polyGeom.getTypes()[n] != 'L') {
            return null;
        }
        if (bl2 != (polyGeom.getTypes()[n] == 'L')) {
            return null;
        }
        if (n2 - n != 4 && n2 - n != 7 && n2 - n != 10 && n2 - n != 13) {
            return null;
        }
        int n3 = (n2 - n - 1) / 3;
        double[][] dArrayArray = new double[n3][];
        for (int i = 0; i < n3; ++i) {
            int n4 = n + 1 + 3 * i;
            if (polyGeom.getTypes()[n4] != 'C') {
                return null;
            }
            dArrayArray[i] = ShapeFactory.isArcPath(polyGeom.getX()[n4 - 1], polyGeom.getY()[n4 - 1], polyGeom.getX()[n4], polyGeom.getY()[n4], polyGeom.getX()[n4 + 1], polyGeom.getY()[n4 + 1], polyGeom.getX()[n4 + 2], polyGeom.getY()[n4 + 2]);
            if (dArrayArray[i] != null) continue;
            return null;
        }
        double[] dArray = ShapeFactory.areWedgeArcs(dArrayArray);
        if (dArray == null) {
            return null;
        }
        double d = new Point(dArray[0], dArray[1]).distance(new Point(polyGeom.getX()[0], polyGeom.getY()[0]));
        double d3 = dArray[4];
        double d4 = dArray[3];
        boolean bl4 = bl = dArrayArray[n3 - 1][4] - dArrayArray[n3 - 1][3] < 0.0;
        if (!bl2) {
            if (!ShapeFactory.areEqualAngles(d3, d4, 0.01)) {
                return null;
            }
            d4 = bl ? d3 + Math.PI * 2 : d3 - Math.PI * 2;
        } else if (bl) {
            if (d4 < d3) {
                d4 += Math.PI * 2;
            }
        } else if (d4 > d3) {
            d4 -= Math.PI * 2;
        }
        return new double[]{dArray[0], dArray[1], d, dArray[2], d3, d4};
    }

    private static double[] areWedgeArcs(double[][] dArray) {
        int n = dArray.length;
        assert (n > 0);
        if (n == 1) {
            return dArray[0];
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == null) {
                return null;
            }
            d += dArray[i][0];
            d2 += dArray[i][1];
            d3 += dArray[i][2];
        }
        d3 /= (double)n;
        Point point = new Point(d /= (double)n, d2 /= (double)n);
        for (int i = 0; i < n; ++i) {
            if (!(point.distance(new Point(dArray[i][0], dArray[i][1])) > 1.0) && !(Math.abs(d3 - dArray[i][2]) > 1.0)) continue;
            return null;
        }
        return new double[]{d, d2, d3, dArray[0][3], dArray[n - 1][4]};
    }

    public static double[] isRoundedRectanglePath(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        char[] cArray;
        PolyGeom polyGeom = PolyGeom.makePolyGeom(string);
        if (polyGeom.getTypes().length == 5) {
            if (polyGeom.getX().length != 5 || polyGeom.getY().length != 5) {
                return null;
            }
            cArray = new char[]{'M', 'L', 'L', 'L', 'Z'};
            n4 = 0;
            n3 = 1;
            n2 = 2;
            n = 3;
        } else if (polyGeom.getTypes().length == 17) {
            if (polyGeom.getX().length != 17 || polyGeom.getY().length != 17) {
                return null;
            }
            cArray = new char[]{'M', 'C', ',', ',', 'L', 'C', ',', ',', 'L', 'C', ',', ',', 'L', 'C', ',', ',', 'Z'};
            n4 = 0;
            n3 = 4;
            n2 = 8;
            n = 12;
        } else {
            return null;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == polyGeom.getTypes()[i]) continue;
            return null;
        }
        double d = polyGeom.getX()[n4];
        double d2 = polyGeom.getY()[n3];
        double d3 = polyGeom.getX()[n2] - d;
        double d4 = polyGeom.getY()[n] - d2;
        double d5 = polyGeom.getY()[n4] - d2;
        if (d5 < 0.0) {
            return null;
        }
        double d6 = d + d3 - polyGeom.getX()[n3];
        if (Math.abs(d5 - d6) > 0.002) {
            return null;
        }
        d6 = d2 + d4 - polyGeom.getY()[n2];
        if (Math.abs(d5 - d6) > 0.002) {
            return null;
        }
        d6 = polyGeom.getX()[n] - d;
        if (Math.abs(d5 - d6) > 0.002) {
            return null;
        }
        return new double[]{d, d2, d3, d4, d5};
    }

    public static void addArc(StringBuilder stringBuilder, double d, double d2, double d3, double d4, double d5) {
        PathSegmentBuilder pathSegmentBuilder = new PathSegmentBuilder();
        ShapeFactory.addArcToPath(pathSegmentBuilder, d, d2, d3, d4, d5);
        stringBuilder.append(pathSegmentBuilder.toString());
    }

    public static void addArcToPath(PathSegmentBuilder pathSegmentBuilder, double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.abs(d4 - d5);
        if (d3 < 0.001 || d6 < 0.001) {
            return;
        }
        int n = (int)Math.ceil((d6 - 0.01) / 1.5707963267948966);
        if (n < 1) {
            n = 1;
        }
        if (n > 4) {
            n = 4;
        }
        double d7 = (d4 - d5) / (2.0 * (double)n);
        double d8 = Math.cos(d7);
        double d9 = Math.sin(d7);
        double[][] dArrayArray = new double[][]{{(4.0 - d8) / 3.0, (1.0 - d8) * (3.0 - d8) / (3.0 * d9)}, {(4.0 - d8) / 3.0, -(1.0 - d8) * (3.0 - d8) / (3.0 * d9)}, {d8, -d9}};
        double d10 = d4;
        for (int i = 0; i < n; ++i) {
            double d11 = Math.cos(d7 - d10);
            double d12 = Math.sin(d7 - d10);
            for (int j = 0; j < 3; ++j) {
                double d13;
                double d14;
                if (i == n - 1 && j == 2) {
                    d14 = d + d3 * Math.cos(d5);
                    d13 = d2 + d3 * Math.sin(d5);
                } else {
                    d14 = d + d3 * (d11 * dArrayArray[j][0] + d12 * dArrayArray[j][1]);
                    d13 = d2 + d3 * (-d12 * dArrayArray[j][0] + d11 * dArrayArray[j][1]);
                }
                ShapeFactory.addCoordToPath(pathSegmentBuilder, Character.valueOf(j == 0 ? (char)'C' : ','), d14, d13);
            }
            d10 -= 2.0 * d7;
        }
    }

    public static void addCoord(StringBuilder stringBuilder, char c, double d, double d2) {
        stringBuilder.append(c);
        stringBuilder.append(MathUtil.r3(d));
        stringBuilder.append(',');
        stringBuilder.append(MathUtil.r3(d2));
    }

    public static void addCoordToPath(PathSegmentBuilder pathSegmentBuilder, Character c, double d, double d2) {
        pathSegmentBuilder.addSegment(c.charValue(), d, d2);
    }
}

