/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyPathMaker;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.SmoothAreaPathMaker;
import com.ibm.vis.engine.internal.struct.SmoothPolyPathMaker;
import com.ibm.vis.engine.internal.struct.WedgeShape;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.geom.RoundedRect;
import com.ibm.vis.geom.Wedge;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class ShapeFactory2 {
    private ShapeFactory2() {
    }

    public static Shape CreateRect(double d, double d2, double d3, double d4) {
        Shape shape = new Shape();
        shape.shapeType = 1004;
        shape.geom = new Rect(d, d2, d3, d4);
        return shape;
    }

    public static Shape CreateArc(double d, double d2, double d3, double d4, double d5) {
        Shape shape = new Shape();
        shape.shapeType = 1005;
        shape.geom = new Wedge(new Point(d, d2), Double.NaN, d3, d4, d5);
        return shape;
    }

    public static Shape CreateRoundedRect(double d, double d2, double d3, double d4, double d5, boolean bl) {
        Shape shape = new Shape();
        shape.shapeType = 1004;
        shape.geom = new RoundedRect(d, d2, d3, d4, d5);
        ((RoundedRect)shape.geom).setRadiusFixed(bl);
        return shape;
    }

    public static Shape CreateCircle(double d, double d2, double d3) {
        Shape shape = new Shape();
        shape.shapeType = 1000;
        shape.geom = new Circle(d, d2, d3);
        return shape;
    }

    public static WedgeShape createWedge(double d, double d2, double d3, double d4, double d5, double d6) {
        return new WedgeShape(d, d2, d3, d4, d5, d6);
    }

    public static PolyPathMaker createPolyPathMakerFromType(int n) {
        switch (n) {
            case 1001: {
                return new SmoothAreaPathMaker();
            }
            case 1000: {
                return new SmoothPolyPathMaker();
            }
        }
        return null;
    }
}

