/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ShapeLine
extends PolyShape {
    public static ShapeLine make(double d, double d2, double d3, double d4) {
        return new ShapeLine(new double[]{d, d3}, new double[]{d2, d4}, false);
    }

    public ShapeLine(double[] dArray, double[] dArray2, boolean bl) {
        super(dArray, dArray2, bl);
        assert (dArray.length == 2 && dArray2.length == 2);
        this.shapeType = 1001;
    }

    @Override
    public Geom getRenderGeom(double d) {
        double d2 = this.x[0];
        double d3 = this.x[1];
        double d4 = this.y[0];
        double d5 = this.y[1];
        if (this.getSnap()) {
            boolean bl;
            boolean bl2 = d4 == d5;
            boolean bl3 = bl = d2 == d3;
            if (bl2 || bl) {
                d2 = Math.round(d2);
                d3 = Math.round(d3);
                d4 = Math.round(d4);
                d5 = Math.round(d5);
            }
            if (bl2) {
                d4 += 0.5;
                d5 += 0.5;
            }
            if (bl) {
                d2 += 0.5;
                d3 += 0.5;
            }
        }
        return new Line(d2, d4, d3, d5);
    }

    @Override
    public int getType() {
        return 1001;
    }

    @Override
    public boolean contains(double d, double d2) {
        return false;
    }

    @Override
    protected Rect calculateBounds() {
        return new Rect(Math.min(this.x[0], this.x[1]), Math.min(this.y[0], this.y[1]), Math.abs(this.x[0] - this.x[1]), Math.abs(this.y[0] - this.y[1]));
    }

    @Override
    public Shape makeGeometryClone() {
        ShapeLine shapeLine = ShapeLine.make(this.x[0], this.y[0], this.x[1], this.y[1]);
        shapeLine.setSnap(this.getSnap());
        shapeLine.setStartArrowByName(this.getStartArrowName());
        shapeLine.setEndArrowByName(this.getEndArrowName());
        shapeLine.setFill(Fill.makeSolid(ColorUtil.getDefaultStrokeColor()));
        return shapeLine;
    }

    public double getLength() {
        return Math.sqrt((this.x[0] - this.x[1]) * (this.x[0] - this.x[1]) + (this.y[0] - this.y[1]) * (this.y[0] - this.y[1]));
    }
}

