/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.Alignment;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyGeom;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.PotentialRect;
import com.ibm.vis.engine.internal.struct.RasterEdgeData;
import com.ibm.vis.engine.internal.struct.RasterEdgeDataXComparator;
import com.ibm.vis.engine.internal.struct.RasterEdgeDataYComparator;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class ShapeNearShape {
    public static final int PREFERRED_GRID_POINTS = 300;

    public static Shape getLabelShape(Shape shape, String string, String string2, String string3, String string4) {
        Shape shape2;
        if (shape.getParts() != null && !shape.isGlyphLike()) {
            shape = ShapeNearShape.getBestPartForLabel(shape, string, string2);
        }
        if ((shape2 = shape.getLabelShape(string, string2, string3)) == null && shape.getContainingShape() != null) {
            shape2 = shape.getContainingShape().getLabelShape(string, string2, string3);
        }
        if (shape2 == null) {
            shape2 = shape;
        }
        if (1000 == shape2.getType()) {
            shape2 = ShapeNearShape.getReducedBoundsWhenNeededForCircle(shape2.getBounds(), string, string2, "inside".equals(string3) && "fit".equals(string4));
        }
        return shape2;
    }

    public static Shape getReducedBoundsWhenNeededForCircle(Rect rect, String string, String string2, boolean bl) {
        boolean bl2;
        boolean bl3 = string == null || string.equals("middle");
        boolean bl4 = bl2 = string2 == null || string2.equals("middle");
        if (bl || !bl3 && !bl2) {
            double d = rect.getWidth() / 2.82842712;
            double d2 = rect.getHeight() / 2.82842712;
            return ShapeFactory2.CreateRect(rect.getX() + rect.getWidth() / 2.0 - d, rect.getY() + rect.getHeight() / 2.0 - d2, 2.0 * d, 2.0 * d2);
        }
        return ShapeFactory2.CreateRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static Shape makeShapeOutsidePoly(PolyShape polyShape, String string, String string2) {
        Point point = ShapeNearShape.getPointOutsidePolyShape(polyShape, string, string2);
        if (point == null) {
            return null;
        }
        return ShapeFactory2.CreateCircle(point.getX(), point.getY(), 0.01);
    }

    private static Point getPointOutsidePolyShape(PolyShape polyShape, String string, String string2) {
        Object object;
        Point point = polyShape.centroid();
        if (!polyShape.contains(point.getX(), point.getY())) {
            object = ShapeNearShape.makeShapeInsidePoly(polyShape, true);
            if (object == null) {
                return null;
            }
            point = ((Shape)object).getCenter();
        }
        if (((Point)(object = new Point(Alignment.getOffset(string), Alignment.getOffset(string2)))).getX() == 0.0 && ((Point)object).getY() == 0.0) {
            return point;
        }
        return ShapeNearShape.searchForOutside(polyShape, point, (Point)object);
    }

    private static Point searchForOutside(PolyShape polyShape, Point point, Point point2) {
        double d = polyShape.getBounds().getWidth();
        double d2 = polyShape.getBounds().getHeight();
        double d3 = 0.0;
        double d4 = 1.05;
        while ((d4 - d3) * Math.max(d, d2) > 2.0) {
            double d5 = (d3 + d4) / 2.0;
            if (polyShape.contains(point.getX() + point2.getX() * d5 * d, point.getY() + point2.getY() * d5 * d2)) {
                d3 = d5;
                continue;
            }
            d4 = d5;
        }
        return new Point(point.getX() + point2.getX() * d4 * d, point.getY() + point2.getY() * d4 * d2);
    }

    public static Shape makeShapeInsidePoly(PolyShape polyShape, boolean bl) {
        int n;
        boolean[][] blArray;
        Geom geom = polyShape.getGeom();
        if (geom == null) {
            geom = polyShape.getRenderGeom(0.0);
        }
        PolyGeom polyGeom = PolyGeom.makeSegmented(polyShape.getXArray(), polyShape.getYArray(), polyShape.getTypes(), false);
        Rect rect = polyGeom.getBounds();
        if (bl && (rect.getWidth() < 1.0 || rect.getHeight() < 1.0)) {
            return null;
        }
        if (bl && ((rect = rect.inset(1.0)).getWidth() < 1.0 || rect.getHeight() < 1.0)) {
            return null;
        }
        int n2 = (int)Math.round(Math.sqrt(300.0 * rect.getWidth() / rect.getHeight()));
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > 300) {
            n2 = 300;
        }
        if ((blArray = ShapeNearShape.rasterize(n2, n = (int)Math.round(300.0 / (double)n2), rect, polyGeom.getX(), polyGeom.getY())) == null) {
            return null;
        }
        return ShapeNearShape.maximalRectInRaster(n2, n, rect, blArray);
    }

    private static boolean[][] rasterize(int n, int n2, Rect rect, double[] dArray, double[] dArray2) {
        int n3;
        ArrayList<Object> arrayList;
        int n4;
        int n5 = dArray.length - 1;
        boolean[][] blArrayArray = new boolean[n2][];
        int n6 = 0;
        ArrayList arrayList2 = new ArrayList();
        double d = rect.getWidth() / (double)n;
        double d2 = rect.getHeight() / (double)n2;
        double d3 = (dArray[dArray.length - 1] - rect.getX()) / d;
        double d4 = (dArray2[dArray2.length - 1] - rect.getY()) / d2;
        for (n4 = 0; n4 <= n5; ++n4) {
            arrayList = new RasterEdgeData();
            double d5 = (dArray[n4] - rect.getX()) / d;
            double d6 = (dArray2[n4] - rect.getY()) / d2;
            double d7 = d5;
            double d8 = d6;
            if ((d6 += (double)(n4 + 1) * 1.23E-6) < d4 || d6 == d4 && d5 < d3) {
                double d9 = d4;
                d4 = d6;
                d6 = d9;
                d9 = d3;
                d3 = d5;
                d5 = d9;
            }
            ((RasterEdgeData)((Object)arrayList)).i0 = d4 == Math.floor(d4) ? (int)Math.floor(d4) : (int)Math.floor(d4) + 1;
            ((RasterEdgeData)((Object)arrayList)).i1 = d6 == Math.floor(d6) ? (int)(Math.floor(d6) - 1.0) : (int)Math.floor(d6);
            ((RasterEdgeData)((Object)arrayList)).dx = (d5 - d3) / (d6 - d4);
            ((RasterEdgeData)((Object)arrayList)).x = d3 + ((RasterEdgeData)((Object)arrayList)).dx * ((double)((RasterEdgeData)((Object)arrayList)).i0 - d4);
            if (((RasterEdgeData)((Object)arrayList)).i1 >= ((RasterEdgeData)((Object)arrayList)).i0) {
                arrayList2.add(arrayList);
            }
            d3 = d7;
            d4 = d8;
        }
        BasicFactory.sortList(arrayList2, new RasterEdgeDataYComparator());
        n4 = 0;
        arrayList = new ArrayList();
        for (n3 = 0; n3 < blArrayArray.length; ++n3) {
            blArrayArray[n3] = new boolean[n];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (RasterEdgeData rasterEdgeData : arrayList) {
                if (rasterEdgeData.i1 < n3) continue;
                rasterEdgeData.x += rasterEdgeData.dx;
                arrayList3.add(rasterEdgeData);
            }
            arrayList = arrayList3;
            if (n4 < arrayList2.size()) {
                Object object = (RasterEdgeData)arrayList2.get(n4);
                while (((RasterEdgeData)object).i0 == n3) {
                    arrayList.add(object);
                    if (++n4 >= arrayList2.size()) break;
                    object = (RasterEdgeData)arrayList2.get(n4);
                }
            }
            BasicFactory.sortList(arrayList, new RasterEdgeDataXComparator());
            int n7 = 0;
            while (n7 + 1 < arrayList.size()) {
                int n8 = (int)Math.floor(((RasterEdgeData)arrayList.get((int)n7)).x);
                int n9 = (int)Math.floor(((RasterEdgeData)arrayList.get((int)(n7 + 1))).x) + 1;
                for (int i = Math.max(0, n8); i < n9 && i < n; ++i) {
                    blArrayArray[n3][i] = true;
                    ++n6;
                }
                n7 += 2;
            }
        }
        if (n6 == 0) {
            return null;
        }
        return blArrayArray;
    }

    private static Shape maximalRectInRaster(int n, int n2, Rect rect, boolean[][] blArray) {
        int n3;
        PotentialRect[] potentialRectArray = new PotentialRect[n2 + 1];
        for (n3 = 0; n3 < potentialRectArray.length; ++n3) {
            potentialRectArray[n3] = PotentialRect.NONE;
        }
        n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            for (int j = n2 - 1; j >= 0; --j) {
                if (blArray[j][i]) {
                    PotentialRect potentialRect = new PotentialRect(potentialRectArray[j], potentialRectArray[j + 1]);
                    double d2 = Math.sqrt(potentialRect.getBestWidth() * potentialRect.getBestHeight()) + 0.25 * (double)Math.min(potentialRect.getBestWidth(), potentialRect.getBestHeight());
                    if (d2 > d) {
                        n3 = i;
                        n4 = j;
                        n5 = potentialRect.getBestWidth();
                        n6 = potentialRect.getBestHeight();
                        d = d2;
                    }
                    potentialRectArray[j] = potentialRect;
                    continue;
                }
                potentialRectArray[j] = PotentialRect.NONE;
            }
        }
        return ShapeFactory2.CreateRect(rect.getX() + rect.getWidth() * (double)n3 / (double)n, rect.getY() + rect.getHeight() * (double)n4 / (double)n2, rect.getWidth() * (double)n5 / (double)n, rect.getHeight() * (double)n6 / (double)n2);
    }

    private static Shape getBestPartForLabel(Shape shape, String string, String string2) {
        Rect rect = shape.getBounds();
        Point point = new Point(rect.getCenterX() + (double)Alignment.getOffset(string) * rect.getWidth() / 2.0, rect.getCenterY() + (double)Alignment.getOffset(string2) * rect.getHeight() / 2.0);
        Shape shape2 = null;
        for (Shape shape3 : shape.getParts()) {
            if (!ShapeNearShape.betterForLabel(shape3, shape2, point)) continue;
            shape2 = shape3;
        }
        return shape2;
    }

    private static boolean betterForLabel(Shape shape, Shape shape2, Point point) {
        double d;
        if (shape2 == null) {
            return true;
        }
        double d2 = shape.area();
        if (d2 > 2.0 * (d = shape2.area())) {
            return true;
        }
        if (d > 2.0 * d2) {
            return false;
        }
        return point.distance(shape.getCenter()) < point.distance(shape2.getCenter());
    }
}

