/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.geom.GeomBuilder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.PolyPathMaker;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.SmoothPolyPathMaker;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ShapePoly
extends PolyShape {
    private PolyPathMaker pathMaker;
    private int nonTopPointsCount;

    public ShapePoly(double[] dArray, double[] dArray2, boolean bl, PolyPathMaker polyPathMaker) {
        super(dArray, dArray2, bl);
        this.pathMaker = polyPathMaker;
        this.setNonTopPointsCount(0);
        this.geom = new Poly(dArray, dArray2, bl);
    }

    @Override
    public SceneNodeImpl createSceneNode() {
        Shape shape = this.createOutlineShape();
        if (shape != null && this.hasRenderStroke()) {
            return this.createAreaElementSceneNode(shape);
        }
        return super.createSceneNode();
    }

    private SceneNodeImpl createAreaElementSceneNode(Shape shape) {
        String string = this.getID();
        String string2 = this.getKey();
        Stroke stroke = this.getStroke();
        ColorNew colorNew = this.getOutline();
        ShapePoly shapePoly = this;
        shape.copyInfoFrom(this);
        Rect rect = this.getBounds();
        Schema schema = new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), new Shape[]{shapePoly, shape}, this.isFilled());
        schema.copyInfoFrom(this);
        schema.setID(string);
        schema.setKey(string2);
        shapePoly.setKey(string2);
        shape.setKey(string2);
        shapePoly.setStroke(null);
        shapePoly.setOutline(null);
        if (colorNew == null) {
            colorNew = ColorUtil.getDefaultStrokeColor();
        }
        if (stroke == null) {
            stroke = Stroke.DEFAULT_STROKE;
        }
        shape.setFill(Fill.makeSolid(colorNew));
        shape.setOutline(colorNew);
        shape.setStroke(stroke);
        return schema.createSceneNode();
    }

    @Override
    public Geom getGeom() {
        return this.geom;
    }

    @Override
    public Geom getRenderGeom(double d) {
        if (this.x == null || this.x.length == 0) {
            return null;
        }
        if (this.pathMaker != null) {
            return this.pathMaker.makeGeom(this);
        }
        GeomBuilder geomBuilder = new GeomBuilder();
        if (this.getTypes() == null) {
            geomBuilder.moveTo(this.x[0], this.y[0]);
            for (int i = 1; i < this.x.length; ++i) {
                geomBuilder.lineTo(this.x[i], this.y[i]);
            }
            if (this.isFilled()) {
                geomBuilder.closePath();
            }
        } else {
            char[] cArray = this.getTypes();
            int n = 0;
            block8: while (n < this.x.length) {
                switch (cArray[n]) {
                    case 'M': {
                        geomBuilder.moveTo(this.x[n], this.y[n]);
                        ++n;
                        continue block8;
                    }
                    case 'L': {
                        geomBuilder.lineTo(this.x[n], this.y[n]);
                        ++n;
                        continue block8;
                    }
                    case 'Q': {
                        geomBuilder.quadTo(this.x[n], this.y[n], this.x[n + 1], this.y[n + 1]);
                        n += 2;
                        continue block8;
                    }
                    case 'C': {
                        geomBuilder.curveTo(this.x[n], this.y[n], this.x[n + 1], this.y[n + 1], this.x[n + 2], this.y[n + 1]);
                        n += 3;
                        continue block8;
                    }
                    case 'Z': {
                        geomBuilder.closePath();
                        ++n;
                        continue block8;
                    }
                }
                throw new EngineException("Bad path control character '" + cArray[n] + "'", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
            }
        }
        return geomBuilder.getGeom();
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public Shape getLabelShape(String string, String string2, String string3) {
        if (this.isGlyphLike()) {
            Rect rect = this.getBounds();
            double d = (rect.getWidth() + rect.getHeight()) / 4.0;
            return ShapeFactory2.CreateCircle(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getWidth() / 2.0, d);
        }
        return super.getLabelShape(string, string2, string3);
    }

    @Override
    public Shape makeGeometryClone() {
        double[] dArray = new double[this.x.length];
        double[] dArray2 = new double[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            dArray[i] = this.x[i];
            dArray2[i] = this.y[i];
        }
        ShapePoly shapePoly = new ShapePoly(dArray, dArray2, this.isFilled(), this.getPathMaker());
        shapePoly.setSnap(this.getSnap());
        return shapePoly;
    }

    public Shape createOutlineShape() {
        int n;
        double[] dArray;
        double[] dArray2;
        int n2 = this.getNonTopPointsCount();
        if (n2 == 0 || n2 == -1 && this.x.length <= 2 || n2 > 0 && this.x.length <= n2) {
            return null;
        }
        if (this.getNonTopPointsCount() == -1) {
            dArray2 = new double[this.x.length - 2];
            dArray = new double[this.y.length - 2];
            for (n = 0; n < this.x.length - 2; ++n) {
                dArray2[n] = this.x[n + 1];
                dArray[n] = this.y[n + 1];
            }
        } else {
            dArray2 = new double[this.x.length - this.getNonTopPointsCount()];
            dArray = new double[this.y.length - this.getNonTopPointsCount()];
            for (n = 0; n < dArray2.length; ++n) {
                dArray2[n] = this.x[n];
                dArray[n] = this.y[n];
            }
        }
        SmoothPolyPathMaker smoothPolyPathMaker = null;
        if (this.getPathMaker() != null) {
            smoothPolyPathMaker = new SmoothPolyPathMaker();
        }
        ShapePoly shapePoly = new ShapePoly(dArray2, dArray, false, smoothPolyPathMaker);
        shapePoly.setSnap(this.getSnap());
        return shapePoly;
    }

    public final PolyPathMaker getPathMaker() {
        return this.pathMaker;
    }

    public int getNonTopPointsCount() {
        return this.nonTopPointsCount;
    }

    public void setNonTopPointsCount(int n) {
        this.nonTopPointsCount = n;
        this.invalidate();
    }
}

