/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.geom.GeomBuilder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.ArrowGeom;
import com.ibm.vis.engine.internal.struct.PolyPathMaker;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SmoothPolyPathMaker
extends PolyPathMaker {
    @Override
    public Geom makeGeom(ShapePoly shapePoly) {
        double[] dArray;
        double[] dArray2;
        Object object;
        int n = shapePoly.getXArray().length;
        if (n == 0) {
            return null;
        }
        if (shapePoly.getStartArrowGeom() != null || shapePoly.getEndArrowGeom() != null) {
            object = shapePoly.getXArray();
            double[] dArray3 = shapePoly.getYArray();
            dArray2 = new double[n];
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray2[i] = object[i];
                dArray[i] = dArray3[i];
            }
        } else {
            dArray2 = shapePoly.getXArray();
            dArray = shapePoly.getYArray();
        }
        if (!this.makeSmoothGeom((GeomBuilder)(object = (Object)new GeomBuilder()), false, dArray2, dArray, shapePoly.getStartArrowGeom(), shapePoly.getEndArrowGeom())) {
            return null;
        }
        return ((GeomBuilder)object).getGeom();
    }

    protected boolean makeSmoothGeom(GeomBuilder geomBuilder, boolean bl, double[] dArray, double[] dArray2, ArrowGeom arrowGeom, ArrowGeom arrowGeom2) {
        if (!bl) {
            int n = dArray.length;
            PolyShape.setupArrowLocation(arrowGeom, dArray, dArray2, 0, 1);
            PolyShape.setupArrowLocation(arrowGeom2, dArray, dArray2, n - 1, -1);
        }
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList();
        DoublePrimitiveArrayList doublePrimitiveArrayList2 = new DoublePrimitiveArrayList();
        SmoothPolyPathMaker.interpolateSmoothPath(dArray, dArray2, doublePrimitiveArrayList, doublePrimitiveArrayList2);
        if (doublePrimitiveArrayList.size() == 0 || doublePrimitiveArrayList2.size() == 0) {
            return false;
        }
        if (bl) {
            geomBuilder.lineTo(doublePrimitiveArrayList.get(0), doublePrimitiveArrayList2.get(0));
        } else {
            geomBuilder.moveTo(doublePrimitiveArrayList.get(0), doublePrimitiveArrayList2.get(0));
        }
        int n = (int)Math.floor(doublePrimitiveArrayList.size() / 4);
        for (int i = 0; i < n; ++i) {
            int n2 = i * 4;
            geomBuilder.curveTo(doublePrimitiveArrayList.get(n2 + 1), doublePrimitiveArrayList2.get(n2 + 1), doublePrimitiveArrayList.get(n2 + 2), doublePrimitiveArrayList2.get(n2 + 2), doublePrimitiveArrayList.get(n2 + 3), doublePrimitiveArrayList2.get(n2 + 3));
        }
        return true;
    }

    @Override
    public List<Point> getControlPoints(ShapePoly shapePoly) {
        return this.findControlPoints(shapePoly.getXArray(), shapePoly.getYArray());
    }

    protected List<Point> findControlPoints(double[] dArray, double[] dArray2) {
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList();
        DoublePrimitiveArrayList doublePrimitiveArrayList2 = new DoublePrimitiveArrayList();
        SmoothPolyPathMaker.interpolateSmoothPath(dArray, dArray2, doublePrimitiveArrayList, doublePrimitiveArrayList2);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 1; i < doublePrimitiveArrayList.size() - 1; i += 4) {
            arrayList.add(new Point(doublePrimitiveArrayList.get(i), doublePrimitiveArrayList2.get(i)));
            arrayList.add(new Point(doublePrimitiveArrayList.get(i + 1), doublePrimitiveArrayList2.get(i + 1)));
        }
        return arrayList;
    }

    public static void interpolateSmoothPath(double[] dArray, double[] dArray2, DoublePrimitiveArrayList doublePrimitiveArrayList, DoublePrimitiveArrayList doublePrimitiveArrayList2) {
        if (dArray.length > dArray2.length) {
            return;
        }
        int n = dArray.length;
        if (n == 1) {
            doublePrimitiveArrayList.add(dArray[0]);
            doublePrimitiveArrayList2.add(dArray2[0]);
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            double d13;
            double d14;
            if (i == 0) {
                d14 = 0.0;
                d13 = 0.0;
                d12 = dArray[i];
                d11 = dArray[i + 1];
                d10 = dArray2[i];
                d9 = dArray2[i + 1];
                if (SmoothPolyPathMaker.delta(d11, d12) == 0.0) {
                    SmoothPolyPathMaker.addControlPointsForVerticalLine(d12, d10, d11, d9, doublePrimitiveArrayList, doublePrimitiveArrayList2);
                    continue;
                }
                if (i < n - 2) {
                    d14 = dArray[i + 2];
                    d13 = dArray2[i + 2];
                }
                d8 = 0.0;
                if (i != n - 2) {
                    d8 = SmoothPolyPathMaker.fodAtIntermediatePoints(d12, d10, d11, d9, d14, d13);
                }
                d7 = SmoothPolyPathMaker.fodAtStartPoint(d12, d10, d11, d9, d8);
                d6 = SmoothPolyPathMaker.sodAtIntervalStartPoint(d12, d10, d11, d9, d7, d8);
                d5 = SmoothPolyPathMaker.sodAtIntervalEndPoint(d12, d10, d11, d9, d7, d8);
                d4 = SmoothPolyPathMaker.d(d12, d11, d6, d5);
                d3 = SmoothPolyPathMaker.c(d12, d11, d6, d5);
                d2 = SmoothPolyPathMaker.b(d12, d10, d11, d9, d3, d4);
                d = SmoothPolyPathMaker.a(d12, d10, d2, d3, d4);
                SmoothPolyPathMaker.addControlPoints(d, d2, d3, d4, d12, d10, d11, d9, doublePrimitiveArrayList, doublePrimitiveArrayList2);
                continue;
            }
            if (i == n - 2) {
                d14 = 0.0;
                d13 = 0.0;
                d12 = dArray[i];
                d11 = dArray2[i];
                d10 = dArray[i + 1];
                d9 = dArray2[i + 1];
                if (SmoothPolyPathMaker.delta(d10, d12) == 0.0) {
                    SmoothPolyPathMaker.addControlPointsForVerticalLine(d12, d11, d10, d9, doublePrimitiveArrayList, doublePrimitiveArrayList2);
                    continue;
                }
                if (i > 0) {
                    d14 = dArray[i - 1];
                    d13 = dArray2[i - 1];
                }
                d8 = SmoothPolyPathMaker.fodAtIntermediatePoints(d14, d13, d12, d11, d10, d9);
                d7 = SmoothPolyPathMaker.fodAtEndPoint(d12, d11, d10, d9, d8);
                d6 = SmoothPolyPathMaker.sodAtIntervalStartPoint(d12, d11, d10, d9, d8, d7);
                d5 = SmoothPolyPathMaker.sodAtIntervalEndPoint(d12, d11, d10, d9, d8, d7);
                d4 = SmoothPolyPathMaker.d(d12, d10, d6, d5);
                d3 = SmoothPolyPathMaker.c(d12, d10, d6, d5);
                d2 = SmoothPolyPathMaker.b(d12, d11, d10, d9, d3, d4);
                d = SmoothPolyPathMaker.a(d12, d11, d2, d3, d4);
                SmoothPolyPathMaker.addControlPoints(d, d2, d3, d4, d12, d11, d10, d9, doublePrimitiveArrayList, doublePrimitiveArrayList2);
                continue;
            }
            d14 = dArray[i - 1];
            d13 = dArray2[i - 1];
            d12 = dArray[i];
            d11 = dArray2[i];
            d10 = dArray[i + 1];
            d9 = dArray2[i + 1];
            d8 = dArray[i + 2];
            d7 = dArray2[i + 2];
            if (SmoothPolyPathMaker.delta(d10, d12) == 0.0) {
                SmoothPolyPathMaker.addControlPointsForVerticalLine(d12, d11, d10, d9, doublePrimitiveArrayList, doublePrimitiveArrayList2);
                continue;
            }
            d6 = SmoothPolyPathMaker.fodAtIntermediatePoints(d14, d13, d12, d11, d10, d9);
            d5 = SmoothPolyPathMaker.fodAtIntermediatePoints(d12, d11, d10, d9, d8, d7);
            d4 = SmoothPolyPathMaker.sodAtIntervalStartPoint(d12, d11, d10, d9, d6, d5);
            d3 = SmoothPolyPathMaker.sodAtIntervalEndPoint(d12, d11, d10, d9, d6, d5);
            d2 = SmoothPolyPathMaker.d(d12, d10, d4, d3);
            d = SmoothPolyPathMaker.c(d12, d10, d4, d3);
            double d15 = SmoothPolyPathMaker.b(d12, d11, d10, d9, d, d2);
            double d16 = SmoothPolyPathMaker.a(d12, d11, d15, d, d2);
            SmoothPolyPathMaker.addControlPoints(d16, d15, d, d2, d12, d11, d10, d9, doublePrimitiveArrayList, doublePrimitiveArrayList2);
        }
    }

    private static void addControlPoints(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, DoublePrimitiveArrayList doublePrimitiveArrayList, DoublePrimitiveArrayList doublePrimitiveArrayList2) {
        double d9 = d7 - d5;
        double d10 = 0.25;
        double d11 = 0.75;
        double d12 = d5 + d9 * d10;
        double d13 = d + d2 * d12 + d3 * SmoothPolyPathMaker.pow(d12, 2) + d4 * SmoothPolyPathMaker.pow(d12, 3);
        double d14 = d5 + d9 * d11;
        double d15 = d + d2 * d14 + d3 * Math.pow(d14, 2.0) + d4 * Math.pow(d14, 3.0);
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        SmoothPolyPathMaker.calculateControlPoints(d5, d6, d12, d13, d14, d15, d7, d8, d10, d11, dArray, dArray2);
        doublePrimitiveArrayList.add(d5);
        doublePrimitiveArrayList2.add(d6);
        for (int i = 0; i < 2; ++i) {
            doublePrimitiveArrayList.add(dArray[i]);
            doublePrimitiveArrayList2.add(dArray2[i]);
        }
        doublePrimitiveArrayList.add(d7);
        doublePrimitiveArrayList2.add(d8);
    }

    private static void addControlPointsForVerticalLine(double d, double d2, double d3, double d4, DoublePrimitiveArrayList doublePrimitiveArrayList, DoublePrimitiveArrayList doublePrimitiveArrayList2) {
        double d5 = 0.25;
        double d6 = 0.75;
        double d7 = d + (d3 - d) * d5;
        double d8 = d2 + (d4 - d2) * d5;
        double d9 = d + (d3 - d) * d6;
        double d10 = d2 + (d4 - d2) * d6;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        SmoothPolyPathMaker.calculateControlPoints(d, d2, d7, d8, d9, d10, d3, d4, d5, d6, dArray, dArray2);
        doublePrimitiveArrayList.add(d);
        doublePrimitiveArrayList2.add(d2);
        for (int i = 0; i < 2; ++i) {
            doublePrimitiveArrayList.add(dArray[i]);
            doublePrimitiveArrayList2.add(dArray2[i]);
        }
        doublePrimitiveArrayList.add(d3);
        doublePrimitiveArrayList2.add(d4);
    }

    private static void calculateControlPoints(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double[] dArray, double[] dArray2) {
        double d11 = d3 - (SmoothPolyPathMaker.pow(1.0 - d9, 3) * d + SmoothPolyPathMaker.pow(d9, 3) * d7);
        double d12 = d4 - (SmoothPolyPathMaker.pow(1.0 - d9, 3) * d2 + SmoothPolyPathMaker.pow(d9, 3) * d8);
        double d13 = d5 - (SmoothPolyPathMaker.pow(1.0 - d10, 3) * d + SmoothPolyPathMaker.pow(d10, 3) * d7);
        double d14 = d6 - (SmoothPolyPathMaker.pow(1.0 - d10, 3) * d2 + SmoothPolyPathMaker.pow(d10, 3) * d8);
        double d15 = 3.0 * (1.0 - d10) * SmoothPolyPathMaker.pow(d10, 2);
        double d16 = -3.0 * SmoothPolyPathMaker.pow(1.0 - d10, 2) * d10;
        double d17 = -3.0 * (1.0 - d9) * SmoothPolyPathMaker.pow(d9, 2);
        double d18 = 3.0 * SmoothPolyPathMaker.pow(1.0 - d9, 2) * d9;
        double d19 = d15 * d18 - d17 * d16;
        dArray[0] = 1.0 / d19 * (d15 * d11 + d17 * d13);
        dArray2[0] = 1.0 / d19 * (d15 * d12 + d17 * d14);
        dArray[1] = 1.0 / d19 * (d16 * d11 + d18 * d13);
        dArray2[1] = 1.0 / d19 * (d16 * d12 + d18 * d14);
    }

    private static double fodAtIntermediatePoints(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d4 - d2) / (d3 - d);
        double d8 = (d6 - d4) / (d5 - d3);
        if (d7 == 0.0 || d8 == 0.0) {
            return 0.0;
        }
        if (d7 > 0.0 && d8 < 0.0) {
            return 0.0;
        }
        if (d7 < 0.0 && d8 > 0.0) {
            return 0.0;
        }
        return (d6 - d2) / (d5 - d);
    }

    private static double fodAtStartPoint(double d, double d2, double d3, double d4, double d5) {
        return 3.0 * (d4 - d2) / (2.0 * (d3 - d)) - d5 / 2.0;
    }

    private static double fodAtEndPoint(double d, double d2, double d3, double d4, double d5) {
        return 3.0 * (d4 - d2) / (2.0 * (d3 - d)) - d5 / 2.0;
    }

    private static double sodAtIntervalStartPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 2.0 * (d6 + 2.0 * d5);
        double d8 = d3 - d;
        double d9 = 6.0 * (d4 - d2);
        double d10 = SmoothPolyPathMaker.pow(d3 - d, 2);
        return -d7 / d8 + d9 / d10;
    }

    private static double sodAtIntervalEndPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 2.0 * (2.0 * d6 + d5);
        double d8 = d3 - d;
        double d9 = 6.0 * (d4 - d2);
        double d10 = SmoothPolyPathMaker.pow(d3 - d, 2);
        return d7 / d8 - d9 / d10;
    }

    private static double d(double d, double d2, double d3, double d4) {
        return (d4 - d3) / (6.0 * (d2 - d));
    }

    private static double c(double d, double d2, double d3, double d4) {
        double d5 = d2 * d3;
        double d6 = d * d4;
        double d7 = 2.0 * (d2 - d);
        return (d5 - d6) / d7;
    }

    private static double b(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d4 - d2;
        double d8 = d5 * (SmoothPolyPathMaker.pow(d3, 2) - SmoothPolyPathMaker.pow(d, 2));
        double d9 = d6 * (SmoothPolyPathMaker.pow(d3, 3) - SmoothPolyPathMaker.pow(d, 3));
        double d10 = d3 - d;
        return (d7 - d8 - d9) / d10;
    }

    private static double a(double d, double d2, double d3, double d4, double d5) {
        return d2 - d3 * d - d4 * SmoothPolyPathMaker.pow(d, 2) - d5 * SmoothPolyPathMaker.pow(d, 3);
    }

    public static double pow(double d, int n) {
        if (n == 0) {
            return 1.0;
        }
        double d2 = 1.0;
        for (int i = 0; i < n; ++i) {
            d2 *= d;
        }
        return d2;
    }

    public String toString() {
        return "smoothPolyPathMaker";
    }

    private static double delta(double d, double d2) {
        Number number = MathUtil.r3(d);
        Number number2 = MathUtil.r3(d2);
        return number.doubleValue() - number2.doubleValue();
    }

    @Override
    public int getType() {
        return 1000;
    }
}

