/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.FormatInfo;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.globalization.NumericShaper;
import com.ibm.vis.engine.internal.globalization.NumericShapingInfo;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.label.TextContentPart;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.NativeTextMeasure;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHeightMetrics;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.spec.internal.FormatSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Text
extends Shape
implements TextInfo {
    private static final String INSIDE = "inside";
    private static final String FIT = "fit";
    private static final String STRETCH = "stretch";
    private static final String CALLOUT = "callout";
    public static final String POLAR = "polar";
    public static final double COORD_ESTIMATE_ADJUSTMENT = 1.15;
    protected TextContent content;
    protected Dim size;
    protected String text;
    protected String originalText;
    protected boolean createTooltipForTruncated;
    protected String truncatedTooltipText;
    protected boolean tooltipDisabled;
    private static final double DEGREE_TO_RADIAN_CONVERSION = Math.PI / 180;
    private static final double POLAR_ANGLE = 1.5707963267948966;
    protected Font font;
    private Object sizeAestheticValue;
    private boolean needPreciseHeight = false;
    protected Point p;
    public String align;
    public String valign;
    public String clipSymbol;
    public boolean vertical;
    public boolean wasClipped;
    public StyleSpec style;
    protected StyleSpec backgroundStyle;
    private Rect cachedUnpaddedTextBounds = null;
    private Rect cachedUnpaddedTransformedTextBounds = null;
    private boolean usesBackgroundPlaque = false;
    public String tickLabelOrientation;
    private FontHeightMetrics cachedFontHeightMetrics;

    protected Text(TextContent textContent, double d, double d2, String string, String string2, Font font, StyleSpec styleSpec, StyleSpec styleSpec2, String string3, Dim dim, boolean bl) {
        this.shapeType = 1009;
        assert (font != null);
        this.setContent(textContent);
        this.setText(textContent.getText());
        this.originalText = this.getText();
        this.createTooltipForTruncated = bl;
        this.truncatedTooltipText = null;
        this.align = string;
        this.valign = string2;
        this.setPoint(new Point(d, d2));
        this.setFont(font);
        this.style = styleSpec;
        this.backgroundStyle = styleSpec2;
        this.clipSymbol = string3 != null ? string3 : "\u2026";
        this.wasClipped = false;
        this.setSize(dim);
        if (this.style == null) {
            StyleBuilder.setDefaultTextStyle(this);
        } else {
            StyleBuilder.setUnfilled(this, this.style, null);
        }
    }

    @Override
    public Geom getRenderGeom(double d) {
        return null;
    }

    @Override
    public SceneNodeImpl createSceneNode() {
        this.prepareTruncatedTooltipText();
        SceneNodeImpl sceneNodeImpl = SceneNodeFactory.createShapeNode(this);
        return this.createSceneNodeBackgroundPlaque(sceneNodeImpl);
    }

    protected SceneNodeImpl createSceneNodeBackgroundPlaque(SceneNodeImpl sceneNodeImpl) {
        if (!this.getUsesBackgroundPlaque() || this.getBackgroundStyle() == null) {
            return sceneNodeImpl;
        }
        StyleSpec styleSpec = this.getBackgroundStyle();
        Rect rect = this.getTextBounds();
        rect = Text.expandByPadding(rect, styleSpec, this.getSize());
        Shape shape = ItemBuilder.makeRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), styleSpec);
        if (styleSpec.fill == null) {
            shape.setFill(Fill.makeSolid(ColorUtil.getTransparentColor()));
        }
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(null);
        groupSceneNode.setType(SceneNodeType.ELEMENT);
        String[] stringArray = this.getID().split("S");
        if (stringArray.length == 2) {
            shape.setID(stringArray[0] + "LB" + stringArray[1]);
        } else {
            shape.setID(this.getID() + "LB");
        }
        groupSceneNode.addChild(shape.createSceneNode());
        groupSceneNode.addChild(sceneNodeImpl);
        return groupSceneNode;
    }

    public void setUsesBackgroundPlaque(boolean bl) {
        this.usesBackgroundPlaque = bl;
    }

    public boolean getUsesBackgroundPlaque() {
        return this.usesBackgroundPlaque;
    }

    public static Text createTextWithShapedValue(String string, double d, double d2, String string2, String string3, Font font, StyleSpec styleSpec, StyleSpec styleSpec2, String string4, Dim dim, boolean bl) {
        return new Text(TextContent.makeForString(string, font.getMinimumSize()), d, d2, string2, string3, font, styleSpec, styleSpec2, string4, dim, bl);
    }

    public static Text createTextWithUnshapedValue(String string, double d, double d2, String string2, String string3, Font font, StyleSpec styleSpec, StyleSpec styleSpec2, String string4, NumericShapingInfo numericShapingInfo, Dim dim, boolean bl) {
        TextContent textContent = TextContent.makeForString(Text.applyNumericalShaping(string, numericShapingInfo), font.getMinimumSize());
        return new Text(textContent, d, d2, string2, string3, font, styleSpec, styleSpec2, string4, dim, bl);
    }

    @Override
    public String getDisplayTooltip() {
        String string = super.getDisplayTooltip();
        return string != null ? string : this.getTruncatedTooltipText();
    }

    public final String getTruncatedTooltipText() {
        if (this.tooltipDisabled) {
            return null;
        }
        return this.truncatedTooltipText;
    }

    public void prepareTruncatedTooltipText() {
        if (this.createTooltipForTruncated && this.wasClipped) {
            this.setTruncatedTooltipText(this.originalText);
        }
    }

    void setTruncatedTooltipText(String string) {
        if (this.truncatedTooltipText == null) {
            this.tooltipSet = true;
            this.truncatedTooltipText = string;
        }
    }

    @Override
    public int getType() {
        return 1009;
    }

    @Override
    public Rect asBasic() {
        return this.getBounds();
    }

    @Override
    public Double requiredPreciseAscent() {
        if (this.needPreciseHeight) {
            return this.getPreciseAscent();
        }
        return null;
    }

    @Override
    public Geom applyPointTransform(PointTransform pointTransform) {
        this.resetCachedBounds();
        this.setPoint(pointTransform.transform(this.getPoint().getX(), this.getPoint().getY()));
        return null;
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.getBounds().containsPt(d, d2);
    }

    @Override
    public Shape makeGeometryClone() {
        return new Text(TextContent.makeForString(this.text, this.font.getMinimumSize()), this.getPoint().getX(), this.getPoint().getY(), this.align, this.valign, this.font, null, null, this.clipSymbol, this.size, this.createTooltipForTruncated);
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, boolean bl) {
        this.resetCachedBounds();
        if (d != 1.0 || d3 != 1.0) {
            this.cachedFontHeightMetrics = null;
        }
        this.getPoint().affine(d, d2, d3, d4);
        if (BasicFactory.isNumber(this.sizeAestheticValue)) {
            this.setFont(this.font.modifySize(((Number)this.sizeAestheticValue).doubleValue()));
        } else if (bl && d3 != 1.0) {
            this.setFont(this.font.modifySize(this.font.getSize() * d3));
        }
    }

    @Override
    public void setTransform(Affine affine) {
        this.resetCachedBounds();
        this.transform.setAffine(affine);
    }

    public void updateTransform(Affine affine) {
        this.resetCachedBounds();
        this.transform.preMultiply(affine);
    }

    public void clipToFit(double d) {
        this.resetCachedBounds();
        int n = this.font.getAmountThatFits(this.text, d);
        if (n >= this.text.length()) {
            return;
        }
        this.wasClipped = true;
        if (d >= this.getClipSymbolSize()) {
            if (this.clipSymbol.equals("#")) {
                if (d < 3.0 * this.getClipSymbolSize()) {
                    this.setText(this.clipSymbol);
                } else {
                    this.setText(this.clipSymbol + this.clipSymbol + this.clipSymbol);
                }
            } else {
                int n2 = this.font.getAmountThatFits(this.text, d - this.getClipSymbolSize());
                this.setText(this.text.substring(0, n2) + this.clipSymbol);
                int n3 = this.font.getAmountThatFits(this.text, d);
                while (n3 < this.text.length() && n2 > 0) {
                    this.setText(this.text.substring(0, --n2) + this.clipSymbol);
                    n3 = this.font.getAmountThatFits(this.text, d);
                }
            }
        } else {
            this.setText("");
        }
    }

    private double getClipSymbolSize() {
        if (this.clipSymbol.equals("\u2026")) {
            return this.font.getEllipsisSize();
        }
        return this.font.getHashSize();
    }

    @Override
    protected Rect calculateBounds() {
        return this.calculatePaddedTextBounds(true);
    }

    private Rect calculatePaddedTextBounds(boolean bl) {
        Rect rect = this.getUnpaddedTextBounds(bl);
        if (this.usesBackgroundPlaque) {
            rect = Text.expandByPadding(rect, this.style, this.size);
            rect = Text.expandByPadding(rect, this.backgroundStyle, this.size);
            if (bl) {
                rect = this.transformBoundsForAngledText(rect);
            }
        }
        return rect;
    }

    public Rect getTextBounds() {
        return this.getUnpaddedTextBounds(true);
    }

    private Rect getUnpaddedTextBounds(boolean bl) {
        Rect rect = null;
        if (bl) {
            if (this.cachedUnpaddedTransformedTextBounds == null) {
                Rect rect2 = this.calculateUnpaddedTextBounds();
                this.cachedUnpaddedTransformedTextBounds = this.transformBoundsForAngledText(rect2);
            }
            rect = this.cachedUnpaddedTransformedTextBounds;
        } else {
            if (this.cachedUnpaddedTextBounds == null) {
                this.cachedUnpaddedTextBounds = this.calculateUnpaddedTextBounds();
            }
            rect = this.cachedUnpaddedTextBounds;
        }
        return rect;
    }

    private Rect calculateUnpaddedTextBounds() {
        double d;
        double d2 = this.calculateTextWidth();
        double d3 = this.getHeight();
        double d4 = "start".equals(this.align) ? 0.0 : ("end".equals(this.align) ? d2 : d2 / 2.0);
        if ("end".equals(this.valign)) {
            d = 0.0;
        } else if ("start".equals(this.valign)) {
            d = this.font.getHeight() * (double)this.getNumLines();
            if (1007 == this.getType() && this.content != null) {
                d = Math.max(d, d3);
            }
        } else {
            d = (double)this.getNumLines() * this.font.getHeight() / 2.0;
            if (1007 == this.getType() && this.content != null) {
                d = Math.max(d, d3 / 2.0);
            }
        }
        Rect rect = new Rect(this.getPoint().getX() - d4, this.getPoint().getY() - d, d2, d3);
        return rect;
    }

    private Rect transformBoundsForAngledText(Rect rect) {
        Rect rect2 = rect;
        if (this.style != null && this.style.angle != null && BasicFactory.isNumber(this.style.angle)) {
            rect2 = Shape.transformBounds(rect, this.transform.getAffine());
        }
        return rect2;
    }

    @Override
    public Rect getNonTransformedBounds() {
        return this.calculatePaddedTextBounds(false);
    }

    @Override
    public double getWidth() {
        return this.font.getWidth(this);
    }

    public double calculateTextWidth() {
        return this.getWidth();
    }

    @Override
    public Point getCenter() {
        return this.getPoint();
    }

    @Override
    public boolean isFilled() {
        return true;
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        this.resetCachedBounds();
        if (bl) {
            this.p.setY(dim.getHeight() - this.p.getY());
        } else {
            this.p.setX(dim.getWidth() - this.p.getX());
        }
    }

    public int getNumLines() {
        return 1;
    }

    protected double getBaseLine() {
        double d = 0.0;
        d = "start".equals(this.valign) ? this.getPoint().getY() - this.font.getHeight() + this.font.getAscent() : ("end".equals(this.valign) ? (this.needPreciseHeight ? this.getPoint().getY() + this.getFontHeightMetrics().getAscent() : this.getPoint().getY() + this.font.getAscent()) : this.getPoint().getY() - (this.font.getHeight() - this.font.getAscent()) + this.getHeight() / 2.0);
        return d;
    }

    public Text sizeToFit(Dim dim, boolean bl) {
        this.resetCachedBounds();
        if (dim.getWidth() >= this.calculateTextWidth() && dim.getHeight() >= this.getHeight()) {
            return this;
        }
        return this.reduceFontToFit(dim, bl);
    }

    private Text reduceFontToFit(Dim dim, boolean bl) {
        double d = this.font.getSize() * dim.getHeight() / this.getHeight();
        double d2 = this.font.getSize() * dim.getWidth() / this.calculateTextWidth();
        double d3 = Math.min(d, d2);
        this.modifyFontSize(d3);
        while ((MathUtil.r(dim.getWidth()) < MathUtil.r(this.calculateTextWidth()) || MathUtil.r(dim.getHeight()) < MathUtil.r(this.getHeight())) && this.font.getSize() > this.font.getMinimumSize()) {
            this.modifyFontSize(d3 -= 1.0);
        }
        if (d3 < this.font.getMinimumSize() || bl) {
            this.modifyFontSize(this.font.getMinimumSize());
            if (this.getHeight() < 1.01 * this.size.getHeight()) {
                this.clipToFit(this.size.getWidth());
                return this;
            }
            return null;
        }
        return this;
    }

    public void modifyFontSize(double d) {
        this.resetCachedBounds();
        this.setFont(this.font.modifySize(d));
    }

    public Text stretchToFit(Dim dim) {
        this.resetCachedBounds();
        this.setFont(this.font.modifySize(10.0));
        double d = dim.getWidth() / this.font.getWidth(this);
        double d2 = dim.getHeight() / this.font.getHeight();
        this.transform.setAffine(new Affine(d, 0.0, this.p.getX() * (1.0 - d), 0.0, d2, this.p.getY() * (1.0 - d2)));
        return this;
    }

    @Override
    public void transpose(Dim dim) {
        this.resetCachedBounds();
        this.getPoint().transpose(dim);
    }

    public Text fitInside(Dim dim) {
        this.resetCachedBounds();
        if (this.font.getHeight() > 1.15 * dim.getHeight()) {
            return null;
        }
        int n = this.font.getAmountThatFits(this.text, dim.getWidth());
        if (n < 1 && this.text.length() > 0) {
            return null;
        }
        if (dim.getWidth() >= this.font.getWidth(this)) {
            return this;
        }
        this.wasClipped = true;
        this.clipToFit(dim.getWidth());
        return this;
    }

    public void buildParts(Dim dim) {
    }

    @Override
    public double getHeight() {
        if (this.needPreciseHeight) {
            return this.getFontHeightMetrics().getHeight() * (double)this.getNumLines();
        }
        return this.font.getHeight() * (double)this.getNumLines();
    }

    public double getApproximateHeight() {
        return this.font.getHeight() * (double)this.getNumLines();
    }

    @Override
    public void copyInfoFrom(Shape shape) {
        super.copyInfoFrom(shape);
        if (1009 == shape.getType() || 1007 == shape.getType()) {
            Text text = (Text)shape;
            this.clipSymbol = text.clipSymbol;
            this.truncatedTooltipText = text.truncatedTooltipText;
            this.resetCachedBounds();
        }
    }

    public static String applyNumericalShaping(String string, NumericShapingInfo numericShapingInfo) {
        if (numericShapingInfo != null) {
            return NumericShaper.shape(string, numericShapingInfo);
        }
        return string;
    }

    public String toString() {
        return this.text;
    }

    protected void resetCachedBounds() {
        this.invalidate();
        this.cachedUnpaddedTextBounds = null;
        this.cachedUnpaddedTransformedTextBounds = null;
    }

    public static Rect expandByPadding(Rect rect, StyleSpec styleSpec, Dim dim) {
        Rect rect2;
        if (styleSpec != null && styleSpec.padding != null) {
            Insets insets = Insets.makeForStylePadding(styleSpec.padding, new Dim(rect.getWidth(), rect.getHeight()), dim);
            rect2 = insets.expandRect(rect);
        } else {
            rect2 = rect;
        }
        return rect2;
    }

    public boolean isInside() {
        return this.style.location != null && (this.style.location.equals(INSIDE) || this.style.location.equals(FIT) || this.style.location.equals(STRETCH));
    }

    public boolean isCallout() {
        return this.style.location != null && this.style.location.equals(CALLOUT);
    }

    public String getVAlign() {
        if (this.valign != null) {
            return this.valign;
        }
        if (this.style == null || this.style.valign == null) {
            return "middle";
        }
        return this.style.valign;
    }

    @Override
    public String getTextVAlign() {
        if (this.valign == null) {
            return "middle";
        }
        return this.valign;
    }

    public String getAlign() {
        if (this.style == null || this.style.align == null) {
            return "middle";
        }
        return this.style.align;
    }

    @Override
    public String getTextAlign() {
        if (this.align == null) {
            return "start";
        }
        return this.align;
    }

    public void setAlign(String string) {
        this.align = string;
    }

    public boolean isCentered() {
        String string = this.getVAlign();
        String string2 = this.getAlign();
        return "middle".equals(string2) && ("middle".equals(string) || "middleOfFirstLine".equals(string));
    }

    public final Object getSizeAestheticValue() {
        return this.sizeAestheticValue;
    }

    public void setSizeAestheticValue(Object object) {
        this.sizeAestheticValue = object;
    }

    @Override
    public double area() {
        return this.getBounds().area();
    }

    public void setNeedsPreciseHeight(boolean bl) {
        this.needPreciseHeight = bl;
        this.invalidate();
    }

    public double getPreciseAscent() {
        FontHeightMetrics fontHeightMetrics = this.getFontHeightMetrics();
        return fontHeightMetrics.getAscent();
    }

    public double getPreciseDescent() {
        FontHeightMetrics fontHeightMetrics = this.getFontHeightMetrics();
        return fontHeightMetrics.getDescent();
    }

    public double getPreciseHeight() {
        FontHeightMetrics fontHeightMetrics = this.getFontHeightMetrics();
        return fontHeightMetrics.getHeight();
    }

    private FontHeightMetrics getFontHeightMetrics() {
        if (this.cachedFontHeightMetrics == null) {
            this.cachedFontHeightMetrics = NativeTextMeasure.getFontHeightMetrics(this.font, this.text);
        }
        return this.cachedFontHeightMetrics;
    }

    public TextContent reduceToFit(TextContent textContent, VisContext visContext) {
        List<TextContentPart> list = this.getPartsInOrder(textContent);
        boolean bl = true;
        for (TextContentPart textContentPart : list) {
            while (bl) {
                this.wasClipped = false;
                boolean bl2 = textContentPart.reduceToFit(visContext);
                if (!bl2) break;
                bl = this.isReductionNeeded(textContent);
            }
            if (bl = this.isReductionNeeded(textContent)) continue;
            return textContent;
        }
        for (TextContentPart textContentPart : list) {
            while (bl) {
                this.wasClipped = false;
                if (textContentPart.getFormatInfo() != null || textContentPart.getValue() == null) break;
                textContentPart.setValue(null);
                bl = this.isReductionNeeded(textContent);
            }
            if (bl = this.isReductionNeeded(textContent)) continue;
            return textContent;
        }
        for (TextContentPart textContentPart : list) {
            FormatInfo formatInfo = textContentPart.getFormatInfo();
            if (bl) {
                this.wasClipped = false;
                if (formatInfo != null) {
                    RAVEFormatter rAVEFormatter = formatInfo.getSpecifiedFormatter();
                    FormatSpec formatSpec = RAVEFormatter.makeFormatSpecFromRAVEFormatter(rAVEFormatter);
                    if (formatSpec.noSpaceFormat != null && formatSpec.noSpaceFormat.pattern != null) {
                        textContentPart.setValue(formatSpec.noSpaceFormat.pattern);
                    }
                    bl = this.isReductionNeeded(textContent);
                }
            }
            if (bl = this.isReductionNeeded(textContent)) continue;
            return textContent;
        }
        return textContent;
    }

    private List<TextContentPart> getPartsInOrder(TextContent textContent) {
        ArrayList<TextContentPart> arrayList = new ArrayList<TextContentPart>();
        ArrayList<TextContentPart> arrayList2 = new ArrayList<TextContentPart>();
        ArrayList<TextContentPart> arrayList3 = textContent.getContent();
        for (int i = arrayList3.size() - 1; i >= 0; --i) {
            TextContentPart textContentPart = (TextContentPart)arrayList3.get(i);
            if (textContentPart.getValue() instanceof Shape) continue;
            if (textContentPart.getFormatInfo() != null) {
                arrayList.add(textContentPart);
                continue;
            }
            arrayList2.add(textContentPart);
        }
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    public boolean isReductionNeeded(TextContent textContent) {
        this.setText(textContent.getText());
        this.fitInside(this.size);
        return this.wasClipped;
    }

    public Point getPoint() {
        return this.p;
    }

    public void setPoint(Point point) {
        this.p = point;
        this.invalidate();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.invalidate();
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.invalidate();
    }

    public TextContent getContent() {
        return this.content;
    }

    public void setContent(TextContent textContent) {
        this.content = textContent;
        this.invalidate();
    }

    public Dim getSize() {
        return this.size;
    }

    protected void setSize(Dim dim) {
        this.size = dim;
        this.invalidate();
    }

    public void applyTextAngle() {
        Number number;
        if (this.style != null && this.style.angle != null && (number = this.calculateRotationAngle()) != null) {
            double d = number.doubleValue();
            Affine affine = Affine.makeRotation(d, this.getPoint().getX(), this.getPoint().getY());
            this.updateTransform(affine);
        }
    }

    private Number calculateRotationAngle() {
        Object object = this.style.angle;
        if (BasicFactory.isNumber(object)) {
            return ((Number)object).doubleValue() * (Math.PI / 180);
        }
        if (object.equals(POLAR)) {
            return 1.5707963267948966;
        }
        return null;
    }

    public final boolean isCreateTooltipForTruncated() {
        return this.createTooltipForTruncated;
    }

    public final void setOriginalText(String string) {
        this.originalText = string;
    }

    protected final String getOriginalText() {
        return this.originalText;
    }

    public void disableTooltip() {
        this.tooltipDisabled = true;
        this.originalText = this.text;
        this.wasClipped = false;
        this.createTooltipForTruncated = false;
        this.truncatedTooltipText = null;
    }

    @Override
    public TextInfo getTextInfo() {
        return this;
    }

    public final StyleSpec getBackgroundStyle() {
        return this.backgroundStyle;
    }

    public final void setBackgroundStyle(StyleSpec styleSpec) {
        this.backgroundStyle = styleSpec;
    }

    public boolean hasSingleLine() {
        return true;
    }

    public Text getLine(int n) {
        return this;
    }

    public boolean hasSinglePart() {
        return true;
    }

    @Override
    public Point getAnchorPoint() {
        double d = this.getPoint().getX();
        double d2 = this.getBaseLine();
        if (this.getSnap()) {
            d = Math.round(d);
            d2 = Math.round(d2);
        }
        return new Point(d, d2);
    }

    @Override
    public Dim getTextSize() {
        Rect rect = this.getUnpaddedTextBounds(false);
        double d = rect.getWidth();
        double d2 = rect.getHeight();
        if (this.getSnap()) {
            d = Math.round(d);
            d2 = Math.round(d2);
        }
        return new Dim(d, d2);
    }
}

