/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.struct;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Wedge;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class WedgeShape
extends Shape {
    WedgeShape(double d, double d2, double d3, double d4, double d5, double d6) {
        this.shapeType = 1005;
        double d7 = d6 - d5;
        if (d7 < Math.PI * -2) {
            d7 = Math.PI * -2;
        } else if (d7 >= Math.PI * 2) {
            d7 = Math.PI * 2;
        }
        d5 %= Math.PI * 2;
        if (d5 < 0.0) {
            d5 += Math.PI * 2;
        }
        this.geom = new Wedge(new Point(d, d2), Math.max(0.0, d3), Math.max(0.0, d4), d5, d5 + d7);
        this.invalidate();
    }

    @Override
    public int getType() {
        return 1005;
    }

    @Override
    protected Point getScalingAnchor() {
        return ((Wedge)this.geom).getOrigin();
    }

    @Override
    public Shape makeGeometryClone() {
        return ShapeFactory2.createWedge(this.getX(), this.getY(), this.getR1(), this.getR2(), this.getA1(), this.getA2());
    }

    @Override
    public Point getOuterPoint() {
        return ((Wedge)this.geom).getOuterPoint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Shape getLabelShape(String string, String string2, String string3) {
        Shape shape = null;
        if ("inside".equals(string3)) {
            double d = (2.0 * this.getR1() + 3.0 * this.getR2()) / 5.0;
            Point point = ((Wedge)this.geom).getLabelCenter();
            shape = ShapeFactory2.CreateCircle(point.getX(), point.getY(), this.getR2() - d);
        } else {
            double d = (this.getA1() + this.getA2()) / 2.0;
            if ("outside".equals(string3)) {
                if ("start".equals(string2)) {
                    shape = ShapeFactory2.CreateCircle(this.getX() + this.getR1() * Math.cos(d), this.getY() + this.getR1() * Math.sin(d), 1.0);
                } else {
                    if (!"end".equals(string2)) return this;
                    shape = ShapeFactory2.CreateCircle(this.getX() + this.getR2() * Math.cos(d), this.getY() + this.getR2() * Math.sin(d), 1.0);
                }
            } else if ("callout".equals(string3)) {
                double d2 = 1.0;
                double d3 = 0.0;
                if ("start".equals(string2)) {
                    d3 += d2;
                } else if ("end".equals(string2)) {
                    d3 -= d2;
                }
                shape = ShapeFactory2.CreateCircle(this.getX() + (this.getR2() + this.getR2() / 2.0) * Math.cos(d), this.getY() + (this.getR2() + this.getR2() / 2.0) * Math.sin(d) + d3, d2);
            }
        }
        if (shape == null) return shape;
        shape.setGlyphLike();
        return shape;
    }

    @Override
    public double getTangentAngle(String string, String string2) {
        return (this.getA1() + this.getA2()) / 2.0 + 1.5707963267948966;
    }

    @Override
    public final double getX() {
        return ((Wedge)this.geom).getOrigin().getX();
    }

    @Override
    public final void setX(double d) {
        ((Wedge)this.geom).setOriginX(d);
        this.invalidate();
    }

    @Override
    public final double getY() {
        return ((Wedge)this.geom).getOrigin().getY();
    }

    @Override
    public final void setY(double d) {
        ((Wedge)this.geom).setOriginY(d);
        this.invalidate();
    }

    final double getR1() {
        return ((Wedge)this.geom).getR1();
    }

    final double getR2() {
        return ((Wedge)this.geom).getR2();
    }

    double getA1() {
        return ((Wedge)this.geom).getA1();
    }

    double getA2() {
        return ((Wedge)this.geom).getA2();
    }
}

