/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.SymbolShapeSpec;
import com.ibm.vis.spec.internal.SymbolSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class DefenderUtil {
    public static final String MAIN_GRABBER_PART = "mainGrabber";
    public static final String FIRST_GRABBER_PART = "firstGrabber";
    public static final String SECOND_GRABBER_PART = "secondGrabber";
    public static final String MEDIAN_PART = "median";
    public static final String RECT_LEFT_PART = "rectLeft";
    public static final String RECT_RIGHT_PART = "rectRight";

    public static boolean isDefenderJson(SymbolSpec symbolSpec) {
        for (SymbolShapeSpec symbolShapeSpec : symbolSpec.shape) {
            if (symbolShapeSpec.part == null || !symbolShapeSpec.part.equals(MAIN_GRABBER_PART) && !symbolShapeSpec.part.equals(FIRST_GRABBER_PART) && !symbolShapeSpec.part.equals(SECOND_GRABBER_PART) && !symbolShapeSpec.part.equals(MEDIAN_PART)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefenderParts(Shape[] shapeArray) {
        for (int i = 0; i < shapeArray.length; ++i) {
            String string = shapeArray[i].getElementPart();
            if (string == null || !string.equals(MAIN_GRABBER_PART) && !string.equals(FIRST_GRABBER_PART) && !string.equals(SECOND_GRABBER_PART) && !string.equals(MEDIAN_PART)) continue;
            return true;
        }
        return false;
    }

    public static SymbolSpec addTransparentRectangles(SymbolSpec symbolSpec, Dim dim) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        JSONObject jSONObject = null;
        JSONObject jSONObject2 = symbolSpec.toJSON();
        JSONObject jSONObject3 = (JSONObject)BasicFactory.deepClone(jSONObject2);
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem(jSONObject3, "shape");
        for (int i = 0; i < BasicFactory.size(jSONArray); ++i) {
            JSONObject jSONObject4 = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            String string = (String)BasicFactory.getItem(jSONObject4, "part");
            if (MEDIAN_PART.equals(string)) {
                bl = true;
                jSONObject = jSONObject4;
                continue;
            }
            if (FIRST_GRABBER_PART.equals(string)) {
                bl2 = true;
                continue;
            }
            if (SECOND_GRABBER_PART.equals(string)) {
                bl3 = true;
                continue;
            }
            if (!MAIN_GRABBER_PART.equals(string)) continue;
            bl4 = true;
        }
        if (!(bl && bl2 && bl3 && bl4)) {
            throw new IllegalStateException("Bad definition for custom shape for Defender. Please specify all of \"median\", \"firstGrabber\", \"secondGrabber\", and \"mainGrabber\" as its parts.");
        }
        BasicFactory.removeFromArray(jSONArray, jSONObject);
        BasicFactory.addAt(jSONArray, jSONObject, 0);
        BasicFactory.addAt(jSONArray, DefenderUtil.buildLeftRectPart(0.0, 0.0, dim.getWidth(), dim.getHeight()), 1);
        BasicFactory.addAt(jSONArray, DefenderUtil.buildRightRectPart(0.0, 0.0, dim.getWidth(), dim.getHeight()), 2);
        return (SymbolSpec)SpecUtil.createSpecObject(jSONObject3, "SymbolSpec");
    }

    private static JSONObject buildLeftRectPart(double d, double d2, double d3, double d4) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        JSONObject jSONObject2 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject2, "left", d);
        BasicFactory.put(jSONObject2, "top", d2);
        BasicFactory.put(jSONObject2, "width", d3);
        BasicFactory.put(jSONObject2, "height", d4);
        BasicFactory.put(jSONObject, "bounds", jSONObject2);
        BasicFactory.put(jSONObject, "part", RECT_LEFT_PART);
        BasicFactory.put(jSONObject, "type", "rect");
        JSONObject jSONObject3 = BasicFactory.createJSONObject();
        JSONObject jSONObject4 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject4, "r", 255.0);
        BasicFactory.put(jSONObject4, "g", 255.0);
        BasicFactory.put(jSONObject4, "b", 255.0);
        BasicFactory.put(jSONObject4, "a", 0.5);
        BasicFactory.put(jSONObject3, "fill", jSONObject4);
        BasicFactory.put(jSONObject, "style", jSONObject3);
        return jSONObject;
    }

    private static JSONObject buildRightRectPart(double d, double d2, double d3, double d4) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        JSONObject jSONObject2 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject2, "left", d);
        BasicFactory.put(jSONObject2, "top", d2);
        BasicFactory.put(jSONObject2, "width", d3);
        BasicFactory.put(jSONObject2, "height", d4);
        BasicFactory.put(jSONObject, "bounds", jSONObject2);
        BasicFactory.put(jSONObject, "type", "rect");
        BasicFactory.put(jSONObject, "part", RECT_RIGHT_PART);
        JSONObject jSONObject3 = BasicFactory.createJSONObject();
        JSONObject jSONObject4 = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject4, "r", 255.0);
        BasicFactory.put(jSONObject4, "g", 255.0);
        BasicFactory.put(jSONObject4, "b", 255.0);
        BasicFactory.put(jSONObject4, "a", 0.5);
        BasicFactory.put(jSONObject3, "fill", jSONObject4);
        BasicFactory.put(jSONObject, "style", jSONObject3);
        return jSONObject;
    }

    public static boolean isDefenderPart(String string) {
        return string.equals(MAIN_GRABBER_PART) || string.equals(FIRST_GRABBER_PART) || string.equals(SECOND_GRABBER_PART) || string.equals(MEDIAN_PART) || string.equals(RECT_LEFT_PART) || string.equals(RECT_RIGHT_PART);
    }

    public static void affineDefenderPart(Shape shape, double d, double d2, double d3, double d4, Dim dim, Rect rect) {
        String string = shape.getElementPart();
        if (string.equals(RECT_LEFT_PART)) {
            shape.setX(0.0);
            shape.setY(0.0);
            shape.setWidth(rect.getX() - shape.getX());
            shape.setHeight(dim.getHeight());
        } else if (string.equals(RECT_RIGHT_PART)) {
            shape.setX(rect.getX() + rect.getWidth());
            shape.setY(0.0);
            shape.setWidth(dim.getWidth() - shape.getX());
            shape.setHeight(dim.getHeight());
        }
    }
}

