/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.util;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class MathUtil {
    public static final double DOUBLE_TOLERANCE = 1.0E-6;
    public static final double LN10 = Math.log(10.0);

    public static double r(double d) {
        if (Math.abs(d) < 1.0E-6) {
            return 0.0;
        }
        if (Math.abs(d - 1.0) < 1.0E-6) {
            return 1.0;
        }
        return d;
    }

    public static Number r3(double d) {
        double d2 = (double)Math.round(d * 1000.0) / 1000.0;
        int n = (int)d2;
        if ((double)n == d2) {
            return n;
        }
        return d2;
    }

    public static Number s4(double d) {
        if (Math.abs(d) >= 1.0) {
            return MathUtil.r3(d);
        }
        if (d == 0.0) {
            return 0;
        }
        double d2 = Math.ceil(Math.log(Math.abs(d)) / Math.log(10.0));
        double d3 = Math.pow(10.0, 4.0 - d2);
        return (double)Math.round(d * d3) / d3;
    }

    public static boolean deltaEquals(double d, double d2) {
        return Math.abs(d - d2) <= 1.0E-6;
    }
}

