/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SceneIdUtil {
    public static final String STROKE = "stroke";
    public static final String CHILDREN = "children";
    public static final String TYPE = "type";
    public static final String ID = "id";
    public static final String BACK = "ack";
    public static final String UNDERSCORE = "_";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String SHAPE = "shape";
    public static final String LB = "LB";
    public static final String LE = "LE";
    public static final String TITLE = "title";
    public static final String GROUP = "V";
    public static final String COORDS = "Coords";
    public static final String OUT = "Out";
    public static final String INSTROKE = "InStroke";
    public static final String TITLE_PREFIX = "D";
    public static final String LEADER_LINE = "LN";
    public static final String LABEL_BACKGROUND = "LB";
    public static final String LEGEND_BACKGROUND_FILL = "-legendBackgroundFill";
    public static final String LEGEND_BACKGROUND_STROKE = "-legendBackgroundStroke";

    public static boolean isLegendBackgroundId(String string) {
        return string != null && string.startsWith("L") && (string.endsWith(LEGEND_BACKGROUND_FILL) || string.endsWith(LEGEND_BACKGROUND_STROKE));
    }

    public static boolean isPartId(String string) {
        return string == null ? false : string.indexOf(UNDERSCORE, 1) != -1;
    }

    public static boolean isCoordsId(String string) {
        return string != null && string.indexOf(COORDS) > -1;
    }

    public static boolean isOutId(String string) {
        return string != null && string.indexOf(OUT) > -1;
    }

    public static boolean isLeaderLine(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(LEADER_LINE) > -1;
    }

    public static boolean isLabelPlaque(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf("LB") > -1;
    }

    public static boolean isStrokeId(String string) {
        return string != null && string.indexOf(INSTROKE) > -1;
    }

    public static boolean isBackId(String string) {
        return string != null && string.indexOf(BACK) > -1;
    }

    public static String getMainId(String string) {
        int n = string.indexOf(UNDERSCORE, 1);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getBaseIdForSceneItem(Object object) {
        String string = (String)BasicFactory.getItem(object, ID);
        if (string != null) {
            return SceneIdUtil.baseId(string);
        }
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem(object, CHILDREN);
        if (jSONArray == null) {
            return null;
        }
        int n = BasicFactory.size(jSONArray);
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            string = SceneIdUtil.getBaseIdForSceneItem(jSONObject);
            if (string == null) continue;
            return SceneIdUtil.baseId(string);
        }
        return null;
    }

    public static boolean isElementGroup(String string) {
        return string.indexOf(GROUP) > -1;
    }

    public static void addGroupId(ElementGroupSceneNode elementGroupSceneNode, String string) {
        String string2 = elementGroupSceneNode.getId();
        if (string2 != null) {
            return;
        }
        string2 = SceneIdUtil.getFirstIdAvailable(elementGroupSceneNode);
        if (string2 == null) {
            return;
        }
        int n = string2.lastIndexOf(GROUP);
        if (n == -1) {
            String string3 = SceneIdUtil.baseId(string2);
            String string4 = SceneIdUtil.getElementMemberKeyFromId(string2);
            string2 = string3 + GROUP + (string != null ? string : string4);
            elementGroupSceneNode.setId(string2);
        } else {
            String string5 = string2.substring(n);
            string2 = string2 + string5;
            elementGroupSceneNode.setId(string2);
        }
    }

    public static String getFirstIdAvailable(SceneNode sceneNode) {
        String string = sceneNode.getId();
        if (string != null) {
            return string;
        }
        List<SceneNode> list = sceneNode.getChildren();
        if (list == null || list.size() == 0) {
            return null;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode2 = ((CompositeSceneNode)sceneNode).getChild(i);
            string = SceneIdUtil.getFirstIdAvailable(sceneNode2);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static String getBaseIdForSceneNode(SceneNode sceneNode) {
        String string = sceneNode.getId();
        if (string != null) {
            return SceneIdUtil.baseId(string);
        }
        List<SceneNode> list = sceneNode.getChildren();
        if (list == null || list.size() == 0) {
            return null;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode2 = ((CompositeSceneNode)sceneNode).getChild(i);
            string = SceneIdUtil.getBaseIdForSceneNode(sceneNode2);
            if (string == null) continue;
            return SceneIdUtil.baseId(string);
        }
        return null;
    }

    public static String clipLegendIdToNavigableId(String string) {
        if (string == null || string.charAt(0) != 'L') {
            return string;
        }
        int n = string.indexOf("S");
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String baseId(String string) {
        if (string.indexOf("L") == 0) {
            return SceneIdUtil.getLegendBaseId(string);
        }
        int n = string.indexOf("A");
        if (n != -1) {
            return SceneIdUtil.getAxisBaseId(string);
        }
        int n2 = string.indexOf("E");
        if (n2 != -1) {
            return SceneIdUtil.getElementBaseId(string);
        }
        int n3 = string.indexOf(TITLE_PREFIX);
        if (n3 != -1) {
            return SceneIdUtil.getVisTitleBaseid(string);
        }
        return string;
    }

    private static String getVisTitleBaseid(String string) {
        String string2 = string;
        int n = string.indexOf("T");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getFacetIndex(String string) {
        if (string == null || string.indexOf("F") != 0) {
            return null;
        }
        int n = string.indexOf("G");
        return string.substring(1, n);
    }

    public static String stripFacetIndexFromId(String string) {
        if (string == null || string.indexOf("F") != 0) {
            return string;
        }
        int n = string.lastIndexOf("F");
        int n2 = string.indexOf("G");
        if (n2 == -1) {
            n2 = n + 2;
        }
        return string.substring(0, n + 1) + string.substring(n2);
    }

    public static boolean isFaceted(String string) {
        return string != null && string.indexOf("F") == 0;
    }

    public static boolean isAxisID(String string) {
        return string != null && string.indexOf("A") == 0;
    }

    public static boolean isGridBandId(String string) {
        return string != null && string.indexOf("A") > -1 && string.indexOf("B") > -1;
    }

    public static String setFacetIndexInId(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        int n = string.indexOf("FF");
        if (n > -1) {
            return string.substring(0, n + 1) + string2 + string.substring(n + 1);
        }
        int n2 = string.indexOf("FG");
        return n2 == -1 ? string : string.substring(0, n2 + 1) + string2 + string.substring(n2 + 1);
    }

    private static String getElementBaseId(String string) {
        int n = string.indexOf("S");
        if (n != -1) {
            return string.substring(0, n);
        }
        int n2 = string.indexOf("L");
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        int n3 = string.indexOf(GROUP);
        if (n3 != -1) {
            return string.substring(0, n3);
        }
        return string;
    }

    public static String getCoordinateKey(String string) {
        int n = string.indexOf(COORDS);
        if (n > -1) {
            return string.substring(0, n);
        }
        int n2 = string.indexOf("G");
        if (n2 == -1) {
            return null;
        }
        int n3 = string.indexOf("A");
        if (n3 > n2) {
            return string.substring(n2, n3);
        }
        int n4 = string.indexOf("E");
        if (n4 > n2) {
            return string.substring(n2, n4);
        }
        return null;
    }

    public static String getGraphIndex(String string) {
        int n = string.indexOf("G");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf("A");
        if (n2 > n) {
            return string.substring(n, n2);
        }
        int n3 = string.indexOf("E");
        if (n3 > n) {
            return string.substring(n, n3);
        }
        int n4 = string.indexOf(COORDS);
        if (n4 > n) {
            return string.substring(n, n4);
        }
        int n5 = string.indexOf(OUT);
        if (n5 > n) {
            return string.substring(n, n5);
        }
        int n6 = string.indexOf(BACK);
        if (n6 > n) {
            return string.substring(n, n6 - 1);
        }
        return null;
    }

    public static String replaceGrammarIndex(String string, String string2) {
        int n = string.indexOf("G");
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf("A");
        if (n2 > n) {
            return string.substring(0, n) + string2 + string.substring(n2);
        }
        int n3 = string.indexOf("E");
        if (n3 > n) {
            return string.substring(0, n) + string2 + string.substring(n3);
        }
        int n4 = string.indexOf(COORDS);
        if (n4 > n) {
            return string.substring(0, n) + string2 + string.substring(n4);
        }
        int n5 = string.indexOf(OUT);
        if (n5 > n) {
            return string.substring(0, n) + string2 + string.substring(n5);
        }
        return string;
    }

    protected static String getAxisBaseId(String string) {
        int n = string.indexOf("T");
        if (n != -1) {
            return string.substring(0, n);
        }
        int n2 = string.indexOf("L");
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        int n3 = string.indexOf("M");
        if (n3 != -1) {
            return string.substring(0, n3);
        }
        int n4 = string.indexOf("N");
        if (n4 != -1) {
            return string.substring(0, n4);
        }
        int n5 = string.indexOf("B");
        if (n5 != -1) {
            return string.substring(0, n5 + 1);
        }
        int n6 = string.indexOf("G");
        int n7 = string.lastIndexOf("G");
        if (n7 != n6) {
            return string.substring(0, n7 + 1);
        }
        return string;
    }

    private static String getLegendBaseId(String string) {
        if (string.indexOf(BACK) > 0) {
            return null;
        }
        int n = string.indexOf(LE);
        if (n > 0) {
            return string.substring(0, n);
        }
        int n2 = string.indexOf("T");
        if (n2 > 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static boolean isGraphNode(SceneItem sceneItem, Element element) {
        if (element == null || !"element".equals(sceneItem.getType())) {
            return false;
        }
        String string = ((SceneItemImpl)sceneItem).getID();
        if (string != null && (string.indexOf(70) >= 0 || string.indexOf(76) >= 0 || string.indexOf(GROUP) >= 0)) {
            return false;
        }
        return element.layout != null && element.layout.isGraph();
    }

    public static String getElementMemberKeyFromId(String string) {
        int n = string.indexOf("S");
        if (n != -1) {
            string = string.substring(n + 1);
            return SceneIdUtil.getMainId(string);
        }
        int n2 = string.indexOf("L");
        if (n2 == -1) {
            return null;
        }
        if (string.indexOf("LB") != -1 || string.indexOf(LEADER_LINE) != -1) {
            return null;
        }
        int n3 = string.indexOf("P");
        return SceneIdUtil.getMainId(string.substring(n2 + 1, n3));
    }

    public static Integer getIndexFromID(String string, char c) {
        if (string != null) {
            int n = string.indexOf(c) + 1;
            int n2 = string.length();
            if (n > 0) {
                double d = BasicFactory.parseDouble(string.substring(n, n + 1));
                if (Double.isNaN(d)) {
                    return null;
                }
                if (n2 < n + 2) {
                    return (int)Math.round(d);
                }
                double d2 = BasicFactory.parseDouble(string.substring(n, n + 2));
                if (Double.isNaN(d2)) {
                    return (int)Math.round(d);
                }
                if (n2 < n + 3) {
                    return (int)Math.round(d2);
                }
                double d3 = BasicFactory.parseDouble(string.substring(n, n + 3));
                return (int)Math.round(Double.isNaN(d3) ? d2 : d3);
            }
        }
        return null;
    }

    public static boolean identifiesElement(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf("E") > -1) {
            return string.matches("^[FG0-9]*E.*") || SceneIdUtil.isHighlightShape(string);
        }
        return false;
    }

    public static boolean isHighlightShape(String string) {
        return string.indexOf(UNDERSCORE) > -1 && string.indexOf(".XH") > 1;
    }

    public static boolean identifiesElementShape(String string) {
        if (string != null && string.indexOf("E") > -1 && string.indexOf("S") > -1) {
            return string.matches("^[FG0-9]*E.*S.*$") || SceneIdUtil.isHighlightShape(string);
        }
        return false;
    }

    public static boolean isNavigable(String string) {
        int n;
        int n2 = string.indexOf("N");
        if (n2 != -1) {
            return false;
        }
        int n3 = string.indexOf("B");
        if (n3 != -1) {
            return false;
        }
        int n4 = string.indexOf("A");
        return n4 <= 0 || (n = string.indexOf("L")) == -1;
    }
}

