/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.util;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SceneTreeUtil {
    private final List<SceneNode> scene;

    public SceneTreeUtil(List<SceneNode> list) {
        this.scene = list;
    }

    public List<List<SceneNode>> getElementGroups() {
        ArrayList<List<SceneNode>> arrayList = new ArrayList<List<SceneNode>>();
        this.addGroups(this.scene, SceneNodeType.ELEMENT, arrayList);
        return arrayList;
    }

    private void addGroups(List<SceneNode> list, SceneNodeType sceneNodeType, List<List<SceneNode>> list2) {
        for (SceneNode sceneNode : list) {
            List<SceneNode> list3 = sceneNode.getChildren();
            if (sceneNodeType == sceneNode.getType()) {
                list2.add(list3);
            }
            this.addGroups(list3, sceneNodeType, list2);
        }
    }

    public SceneNode[] getGrammarInnerShapes() {
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        int n = this.scene.size();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode = this.scene.get(i);
            String string = sceneNode.getId();
            if (!SceneIdUtil.isCoordsId(string)) continue;
            arrayList.add(sceneNode);
        }
        return arrayList.toArray(new SceneNode[arrayList.size()]);
    }

    public static Rect getBounds(SceneNode sceneNode) {
        if (sceneNode == null || sceneNode.getShape() == null) {
            return null;
        }
        ShapeInfo shapeInfo = sceneNode.getShape();
        Rect rect = shapeInfo.getNodeBounds();
        double d = ((Shape)shapeInfo).getStrokeWidth();
        return new Rect(rect.getX() - d / 2.0, rect.getY() - d / 2.0, rect.getWidth() + d, rect.getHeight() + d);
    }

    public static Point getTransformOffset(SceneNode sceneNode) {
        TransformInfoImpl transformInfoImpl = (TransformInfoImpl)sceneNode.getTransform();
        if (transformInfoImpl == null) {
            return new Point(0.0, 0.0);
        }
        Affine affine = transformInfoImpl.getAffine();
        if (affine == null) {
            return new Point(0.0, 0.0);
        }
        return affine.transform(0.0, 0.0);
    }

    public static void scaleBy(SceneTree sceneTree, double d) {
        Affine affine;
        if (sceneTree == null) {
            return;
        }
        CompositeSceneNode compositeSceneNode = sceneTree.getRoot();
        TransformInfoImpl transformInfoImpl = (TransformInfoImpl)compositeSceneNode.getTransform();
        if (transformInfoImpl == null) {
            transformInfoImpl = new TransformInfoImpl();
            compositeSceneNode.setTransform(transformInfoImpl);
        }
        if ((affine = transformInfoImpl.getAffine()) == null) {
            affine = Affine.identity();
        }
        transformInfoImpl.setAffine(affine.scale(d));
    }
}

