/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.CoreJSONSerializer;

@Deprecated
@OnDemandLoad(value="com/ibm/vis/layers/interactionLayer")
public class SceneUtil {
    private static final String ELLIPSE_NAME = "ellipse";
    private static final String IMAGE_NAME = "image";
    private static final String ASCENT = "ascent";
    private static final String ALIGN = "align";
    private static final String FONT = "font";
    private static final String TRANSFORM = "transform";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String R = "r";
    private static final String X1 = "x1";
    private static final String X2 = "x2";
    private static final String Y1 = "y1";
    private static final String Y2 = "y2";
    private static final String RX = "rx";
    private static final String RY = "ry";
    private static final String CX = "cx";
    private static final String CY = "cy";
    private static final String DX = "dx";
    private static final String DY = "dy";
    private final JSONArray scene;

    public SceneUtil(JSONArray jSONArray) {
        this.scene = jSONArray;
    }

    public Dim getSize() {
        Object object = BasicFactory.getArrayItem(this.scene, 0);
        Object object2 = BasicFactory.getItem(object, "shape");
        Dim dim = Shape.toRect(object2).getExtent();
        Affine affine = SceneUtil.getBackTransform(this.scene);
        return new Dim(dim.getWidth() * Math.abs(affine.m00), dim.getHeight() * Math.abs(affine.m11));
    }

    public static Rect getBounds(JSONObject jSONObject) {
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2 = jSONObject == null ? null : (JSONObject)BasicFactory.getItem(jSONObject, "shape");
        if (jSONObject2 == null) {
            jSONObject2 = jSONObject;
        }
        return SceneUtil.getShapeBounds(jSONObject, jSONObject2);
    }

    private static Rect getShapeBounds(JSONObject jSONObject, JSONObject jSONObject2) {
        Double d;
        String string;
        Rect rect = null;
        if (jSONObject2 != null) {
            string = (String)BasicFactory.getItem(jSONObject2, "type");
            if (string == null) {
                rect = SceneUtil.getDefaultBounds(jSONObject2);
            } else if (string.startsWith("rect")) {
                rect = SceneUtil.getRectBounds(jSONObject2);
            } else if (IMAGE_NAME.equals(string)) {
                rect = SceneUtil.getImageBounds(jSONObject2);
            } else if ("circle".equals(string)) {
                rect = SceneUtil.getCircleBounds(jSONObject2);
            } else if (ELLIPSE_NAME.equals(string)) {
                rect = SceneUtil.getEllipseBounds(jSONObject2);
            } else if ("line".equals(string)) {
                rect = SceneUtil.getLineBounds(jSONObject2);
            } else if ("text".equals(string)) {
                d = (JSONObject)BasicFactory.getItem(jSONObject, FONT);
                rect = SceneUtil.getTextBounds(jSONObject2, (JSONObject)d);
            } else {
                rect = SceneUtil.getDefaultBounds(jSONObject2);
            }
        }
        if (jSONObject != null && (string = (JSONObject)BasicFactory.getItem(jSONObject, "stroke")) != null && rect != null) {
            d = null;
            Object object = BasicFactory.getItem(string, "width");
            if (object != null) {
                d = UnitConverter.convertLength(object, null, null);
            }
            if (d == null) {
                d = 1.0;
            }
            rect = (Rect)rect.expand(d / 2.0);
        }
        return rect;
    }

    private static Rect getTextBounds(JSONObject jSONObject, JSONObject jSONObject2) {
        Number number = (Number)BasicFactory.getItem(jSONObject, X);
        Number number2 = (Number)BasicFactory.getItem(jSONObject, Y);
        Number number3 = (Number)BasicFactory.getItem(jSONObject, "width");
        Number number4 = (Number)BasicFactory.getItem(jSONObject, "height");
        String string = (String)BasicFactory.getItem(jSONObject, ALIGN);
        if (jSONObject2 == null) {
            return null;
        }
        Number number5 = (Number)BasicFactory.getItem(jSONObject2, ASCENT);
        if (number5 == null) {
            return null;
        }
        if (number3 == null) {
            return null;
        }
        if (number4 == null) {
            return null;
        }
        if (number == null) {
            number = 0.0;
        }
        if (number2 == null) {
            number2 = 0.0;
        }
        if (string == null) {
            string = "start";
        }
        Rect rect = new Rect(number.doubleValue(), number2.doubleValue() - number5.doubleValue(), number3.doubleValue(), number4.doubleValue());
        if ("middle".equals(string)) {
            rect.setX(rect.getX() - rect.getWidth() / 2.0);
        } else if ("end".equals(string)) {
            rect.setX(rect.getX() - rect.getWidth());
        } else if ("start".equals(string)) {
            rect.setX(number.doubleValue());
        }
        return rect;
    }

    private static Rect getLineBounds(JSONObject jSONObject) {
        Number number = (Number)BasicFactory.getItem(jSONObject, X1);
        Number number2 = (Number)BasicFactory.getItem(jSONObject, Y1);
        Number number3 = (Number)BasicFactory.getItem(jSONObject, X2);
        Number number4 = (Number)BasicFactory.getItem(jSONObject, Y2);
        double d = number == null ? 0.0 : number.doubleValue();
        double d2 = number2 == null ? 0.0 : number2.doubleValue();
        double d3 = number3 == null ? 100.0 : number3.doubleValue();
        double d4 = number4 == null ? 100.0 : number4.doubleValue();
        return new Rect(Math.min(d, d3), Math.min(d2, d4), Math.abs(d3 - d), Math.abs(d4 - d2));
    }

    private static Rect getEllipseBounds(JSONObject jSONObject) {
        Number number = (Number)BasicFactory.getItem(jSONObject, CX);
        Number number2 = (Number)BasicFactory.getItem(jSONObject, CY);
        Number number3 = (Number)BasicFactory.getItem(jSONObject, RX);
        Number number4 = (Number)BasicFactory.getItem(jSONObject, RY);
        if (number == null) {
            number = 0.0;
        }
        if (number2 == null) {
            number2 = 0.0;
        }
        if (number3 == null) {
            number3 = 200.0;
        }
        if (number4 == null) {
            number4 = 100.0;
        }
        return new Rect(number.doubleValue() - number3.doubleValue(), number2.doubleValue() - number4.doubleValue(), number3.doubleValue() * 2.0, number4.doubleValue() * 2.0);
    }

    private static Rect getCircleBounds(JSONObject jSONObject) {
        Number number = (Number)BasicFactory.getItem(jSONObject, CX);
        Number number2 = (Number)BasicFactory.getItem(jSONObject, CY);
        Number number3 = (Number)BasicFactory.getItem(jSONObject, R);
        if (number == null) {
            number = 0.0;
        }
        if (number2 == null) {
            number2 = 0.0;
        }
        if (number3 == null) {
            number3 = 100.0;
        }
        return new Rect(number.doubleValue() - number3.doubleValue(), number2.doubleValue() - number3.doubleValue(), number3.doubleValue() * 2.0, number3.doubleValue() * 2.0);
    }

    private static Rect getImageBounds(JSONObject jSONObject) {
        Number number = (Number)BasicFactory.getItem(jSONObject, X);
        Number number2 = (Number)BasicFactory.getItem(jSONObject, Y);
        Number number3 = (Number)BasicFactory.getItem(jSONObject, "width");
        Number number4 = (Number)BasicFactory.getItem(jSONObject, "height");
        if (number3 == null) {
            number3 = 0.0;
        }
        if (number4 == null) {
            number4 = 0.0;
        }
        if (number == null) {
            number = 0.0;
        }
        if (number2 == null) {
            number2 = 0.0;
        }
        return new Rect(number.doubleValue(), number2.doubleValue(), number3.doubleValue(), number4.doubleValue());
    }

    private static Rect getRectBounds(JSONObject jSONObject) {
        Number number = (Number)BasicFactory.getItem(jSONObject, X);
        Number number2 = (Number)BasicFactory.getItem(jSONObject, Y);
        Number number3 = (Number)BasicFactory.getItem(jSONObject, "width");
        Number number4 = (Number)BasicFactory.getItem(jSONObject, "height");
        if (number3 == null) {
            number3 = 100.0;
        }
        if (number4 == null) {
            number4 = 100.0;
        }
        if (number == null) {
            number = 0.0;
        }
        if (number2 == null) {
            number2 = 0.0;
        }
        return new Rect(number.doubleValue(), number2.doubleValue(), number3.doubleValue(), number4.doubleValue());
    }

    public static Rect getDefaultBounds(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        Number number = (Number)BasicFactory.getItem(jSONObject, X);
        Number number2 = (Number)BasicFactory.getItem(jSONObject, Y);
        Number number3 = (Number)BasicFactory.getItem(jSONObject, "width");
        Number number4 = (Number)BasicFactory.getItem(jSONObject, "height");
        if (number3 == null || number4 == null || number == null || number2 == null) {
            return null;
        }
        return new Rect(number.doubleValue(), number2.doubleValue(), number3.doubleValue(), number4.doubleValue());
    }

    public static Affine getBackTransform(JSONArray jSONArray) {
        if (jSONArray == null || BasicFactory.size(jSONArray) == 0) {
            return null;
        }
        Object object = BasicFactory.getArrayItem(jSONArray, 0);
        object = BasicFactory.getItem(object, TRANSFORM);
        return CoreJSONSerializer.deserializeAffineNonNull((JSONObject)object);
    }
}

