/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.util;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SimpleRNG {
    static final long[] rng0 = SimpleRNG.makeRNG(262139L, 506L);
    static final long[] rng1 = SimpleRNG.makeRNG(262121L, 533L);
    long state0;
    long state1;

    private static long[] makeRNG(long l, long l2) {
        return new long[]{l, l2, l / l2, l % l2};
    }

    private SimpleRNG(long l) {
        this.state0 = l % (rng0[0] - 1L);
        if (this.state0 == 0L) {
            this.state0 = 1L;
        }
        this.state1 = l % (rng1[0] - 1L);
        if (this.state1 == 0L) {
            this.state1 = 1L;
        }
    }

    private static long next(long[] lArray, long l) {
        long l2 = l % lArray[2];
        long l3 = l / lArray[2];
        long l4 = lArray[1] * l2 - lArray[3] * l3;
        if (l4 <= 0L) {
            l4 += lArray[0];
        }
        return l4;
    }

    public float random() {
        this.state0 = SimpleRNG.next(rng0, this.state0);
        this.state1 = SimpleRNG.next(rng1, this.state1);
        float f = ((float)this.state0 - 1.0f) / ((float)rng0[0] - 1.0f);
        float f2 = ((float)this.state1 - 1.0f) / ((float)rng1[0] - 2.0f);
        return f + f2 / ((float)rng0[0] - 1.0f);
    }

    public static SimpleRNG getSeededRNG(long l) {
        return new SimpleRNG(l);
    }
}

