/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.util;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.IntegerUtil;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class Version {
    private final int major;
    private final int minor;
    private final int micro;

    public Version(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.micro = n3;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getMicro() {
        return this.micro;
    }

    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        int n = this.major - version.major;
        if (n != 0) {
            return n;
        }
        n = this.minor - version.minor;
        if (n != 0) {
            return n;
        }
        n = this.micro - version.micro;
        return n;
    }

    public String toString() {
        return this.major + "." + this.minor + (this.micro == 0 ? "" : "." + this.micro);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.major;
        n = 31 * n + this.micro;
        n = 31 * n + this.minor;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        if (this.major != version.major) {
            return false;
        }
        if (this.micro != version.micro) {
            return false;
        }
        return this.minor == version.minor;
    }

    public static final Version parseVersion(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (string != null && string.length() > 0) {
            String[] stringArray = Version.split(string, '.');
            if (stringArray.length == 0 || stringArray.length > 3) {
                throw new IllegalArgumentException("Invalid version format: " + string);
            }
            n = Version.toInt(stringArray[0], string);
            n2 = stringArray.length > 1 ? Version.toInt(stringArray[1], string) : 0;
            n3 = stringArray.length > 2 ? Version.toInt(stringArray[2], string) : 0;
        }
        return new Version(n, n2, n3);
    }

    private static int toInt(String string, String string2) {
        Number number = IntegerUtil.parseInt(string, 10);
        if (number == null) {
            throw new IllegalArgumentException("Invalid version format: " + string2);
        }
        return number.intValue();
    }

    private static String[] split(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                continue;
            }
            stringBuilder.append(c2);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

