/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisJSONUtil {
    private static final String EMBEDDED_DATA = "embeddedData";
    private static final String $REF = "$ref";
    static final String RESOURCE = "resource";
    private static final String ID = "id";

    public static void expandReferences(JSONObject jSONObject, Map<String, JSONObject> map) {
        VisJSONUtil.replaceReferences(jSONObject, map);
    }

    public static Map<String, JSONObject> getResourceDefinitions(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem(jSONObject, RESOURCE);
        if (jSONArray != null) {
            int n = BasicFactory.getJSONArraySize(jSONArray);
            if (n == 0) {
                return null;
            }
            HashMap<String, JSONObject> hashMap = new HashMap<String, JSONObject>();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
                String string = (String)BasicFactory.getItem(jSONObject2, ID);
                if (string == null) continue;
                JSONObject jSONObject3 = (JSONObject)BasicFactory.clone(jSONObject2);
                BasicFactory.remove(jSONObject3, ID);
                if (BasicFactory.containsKey(jSONObject3, EMBEDDED_DATA)) {
                    BasicFactory.remove(jSONObject3, EMBEDDED_DATA);
                }
                hashMap.put(string, jSONObject3);
            }
            return hashMap;
        }
        return null;
    }

    private static void replaceReferences(JSONObject jSONObject, Map<String, JSONObject> map) {
        String[] stringArray;
        for (String string : stringArray = BasicFactory.keySet(jSONObject)) {
            JSONObject jSONObject2;
            String string2;
            Object object;
            Object object2 = BasicFactory.getItem(jSONObject, string);
            if ($REF.equals(string) && BasicFactory.isString(object2) && (object = map.get(string2 = (String)object2)) != null) {
                VisJSONUtil.expandReference(jSONObject, object);
            }
            if (BasicFactory.isArray(object2)) {
                string2 = (JSONArray)object2;
                VisJSONUtil.replaceReferencesFromArray((JSONArray)string2, map);
            }
            if (!BasicFactory.isObject(object2)) continue;
            string2 = (JSONObject)object2;
            if (VisJSONUtil.containsReferenceKey((JSONObject)string2) && (jSONObject2 = map.get(object = (String)BasicFactory.getItem(string2, $REF))) != null) {
                VisJSONUtil.expandReference((JSONObject)string2, jSONObject2);
            }
            VisJSONUtil.replaceReferences((JSONObject)string2, map);
        }
    }

    private static void expandReference(JSONObject jSONObject, JSONObject jSONObject2) {
        String[] stringArray;
        BasicFactory.remove(jSONObject, $REF);
        for (String string : stringArray = BasicFactory.keySet(jSONObject2)) {
            BasicFactory.put(jSONObject, string, BasicFactory.getItem(jSONObject2, string));
        }
    }

    private static void replaceReferencesFromArray(JSONArray jSONArray, Map<String, JSONObject> map) {
        int n = BasicFactory.getJSONArraySize(jSONArray);
        for (int i = 0; i < n; ++i) {
            Object object = BasicFactory.getArrayItem(jSONArray, i);
            if (BasicFactory.isObject(object)) {
                VisJSONUtil.replaceReferences((JSONObject)object, map);
            }
            if (!BasicFactory.isArray(object)) continue;
            VisJSONUtil.replaceReferencesFromArray((JSONArray)object, map);
        }
    }

    public static boolean containsReferenceKey(JSONObject jSONObject) {
        return jSONObject != null && BasicFactory.containsKey(jSONObject, $REF);
    }

    public static void checkReferenceExpanded(JSONObject jSONObject) {
        if (VisJSONUtil.containsReferenceKey(jSONObject)) {
            String string = (String)BasicFactory.getItem(jSONObject, $REF);
            throw new EngineException("Reference '" + string + "' is undefined", ErrorCode.ENGINE_LOG_INVALID_DATA, null);
        }
    }
}

