/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.exceptions;

import com.ibm.vis.exceptions.ErrorCode;
import java.util.HashMap;
import java.util.Map;

class ErrorCodeDescriptions {
    private static Map<ErrorCode, String> nonLocalizedErrorDescriptionMap = null;

    ErrorCodeDescriptions() {
    }

    static String getDescription(ErrorCode errorCode) {
        if (errorCode == null) {
            return "NULL ERROR CODE";
        }
        String string = nonLocalizedErrorDescriptionMap.get((Object)errorCode);
        return string != null ? string : errorCode.name();
    }

    static String getLocalizedDescription(ErrorCode errorCode, String string) {
        return ErrorCodeDescriptions.getDescription(errorCode);
    }

    static {
        nonLocalizedErrorDescriptionMap = new HashMap<ErrorCode, String>();
        nonLocalizedErrorDescriptionMap.put(ErrorCode.DATA_PROVIDER_NOT_READY, "DATA PROVIDER NOT READY");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.DATA_PROVIDER_FAILED, "DATA PROVIDER SIGNALLED FAILURE");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.DATA_PROVIDER_NOT_FOUND, "DATA PROVIDER NOT FOUND");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.DATA_PROVIDER_CONVERSION, "DATA PROVIDER DATA CONVERSION ERROR");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.EXTENSION_POINT_EXCEPTION, "EXTENSION POINT EXCEPTION");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.EXTENSION_NOT_FOUND, "EXTENSION NOT FOUND");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SWIM_LANE_DATA, "SWIM LANE DATA DOES NOT MATCH GRAPH LAYOUT");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SWIM_LANE_ELEMENT_ORDER, "SWIM LANE WITHOUT PRECEEDING GRAPH");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.DATA_OVERFLOW, "DATA OVERFLOW");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.DATA_CONVERSION, "DATA CONVERSION ERROR");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ERROR_UNKNOWN, "UNKNOWN ERROR");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, "LAYOUT DOES NOT FIT");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_UNMATCHED_KEY_IN_GEO_AUGMENT, "KEY UNMATCHED IN GEO AUGMENT SPECIFICATION");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_UNMATCHED_PROPERTY_IN_GEO_AUGMENT, "GEO AUGMENT PROPERTY NOT FOUND");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_EMPTY_GEO_JSON, "EMPTY GEOJSON FILE");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_TRANSITION_UNSUPPORTED_TARGET, "UNSUPPORTED TARGET FOR EFFECTS");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_TRANSITION_UNSUPPORTED_SIMULTANEOUS_EFFECT, "UNSUPPORTED SIMULTANEOUS EFFECTS");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_COMPOSITE_EFFECT_NO_CHILD, "COMPOSITE EFFECT WITHOUT CHILD");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_FACET_TOO_MANY_FIELDS, "TOO MANY FACET FIELDS");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_FACET_NO_FIELDS, "FACET WITHOUT FIELDS");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_FACET_INVALID_DATA_SOURCE, "FACET INVALID DATA SOURCE");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_FACET_INVALID_DATA, "FACET INVALID DATA");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_ROWS_CREATE_CONFLICTING_LABEL, "ROWS CREATE CONFLICTING LABEL");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_LEGENDS_ERROR, "LEGENDS PROCESSING ERROR");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_LOCALIZATION_ERROR, "LOCALIZATION PROCESSING ERROR");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_ILLEGAL_ARGUMENT, "ILLEGAL ARGUMENT PASSED");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_UNSUPPORTED_OPERATION, "OPERATION UNSUPPORTED");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_LOG_INVALID_DATA, "LOG INVALID DATA");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.ENGINE_FORMATTING_ERROR, "FORMATTING ERROR");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SPEC_PARSE_FAIL, "SPECIFICATION PARSING FAILED");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SPEC_INVALID_VALUE, "INVALID VALUE IN SPECIFICATION");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SPEC_INVALID_LENGTH, "INVALID LENGTH IN SPECIFICATION");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SPEC_IS_EMPTY, "SPECIFICATION IS EMPTY");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SPEC_IS_NULL, "SPECIFICATION IS NULL");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SPEC_DUPLICATE_ID, "DUPLICATE ID IN SPECIFICATION");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SPEC_INVALID_VERSION, "INVALID VERSION OF SPECIFICATION");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.RENDERER_UNSUPPORTED, "SELECTED RENDERER UNSUPPORTED");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.RENDERER_UNAVAILABLE, "SELECTED RENDERER UNAVAILABLE");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.MIGRATION_INVALID_PATH_EXPRESSION, "MIGRATION PATH IS INVALID");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.JSONPATH_INVALID_PATH, "INVALID JSON PATH");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.JSONPATH_UNSUPPORTED_FEATURE, "UNSUPPORTED FEATURE");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.JSONPATH_BAD_ARRAY_INDEX, "BAD ARRAY INDEX");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.JSONPATH_OBJECT_DOES_NOT_EXIST, "OBJECT DOES NOT EXIST");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.TEMPLATE_INVALID_JSON, "TEMPLATE JSON INVALID");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.TEMPLATE_CANNOT_BE_RESOLVED, "TEMPLATE CANNOT BE RESOLVED");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.PARAMETER_NOT_FOUND, "PARAMETER NOT FOUND");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.PARAMETER_DEFAULT_VALUE_TYPE_MISMATCH, "PARAMETER TYPE DEFAULT VALUE TYPE MISMATCH");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.PARAMETER_VALUE_TYPE_MISMATCH, "PARAMETER VALUE TYPE MISMATCH");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.PARAMETER_ID_INVALID_TYPE, "PARAMETER ID INVALID");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SERIALIZE_ERROR, "ERROR IN SERIALIZE");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SCENE_TREE_FAIL, "FAILED TO MAKE THE SCENE TREE");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.SET_SPEC_FAIL, "FAILED TO SET THE SPEC");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.INTERACTIVITY_FAIL, "INTERACTIVITY REQUEST FAILED");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.RENDER_FAIL, "ERROR MAKING IMAGE");
        nonLocalizedErrorDescriptionMap.put(ErrorCode.EFFECTS_FAIL, "ERROR PROCESSING EFFECTS CHANGE");
    }
}

