/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.exceptions;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.ErrorCodeDescriptions;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class VisException
extends RuntimeException {
    private static final String[] NO_KEYS = new String[0];
    private String message;
    private ErrorCode errorCode;
    private String context;

    protected VisException(String string, ErrorCode errorCode, String string2) {
        super(string);
        this.message = string;
        this.errorCode = errorCode;
        this.context = string2;
    }

    @Override
    public String getMessage() {
        return this.message == null ? this.getErrorDescription() : this.message;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getLocalizedMessageForLocale(String string) {
        return this.getMessage();
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return ErrorCodeDescriptions.getDescription(this.errorCode);
    }

    public String getLocalizedErrorDescription() {
        return ErrorCodeDescriptions.getLocalizedDescription(this.errorCode, null);
    }

    public String getLocalizedErrorDescriptionForLocale(String string) {
        return ErrorCodeDescriptions.getLocalizedDescription(this.errorCode, string);
    }

    public String getContext() {
        return this.context;
    }

    public String[] getParameterKeys() {
        return NO_KEYS;
    }

    public Object getParameterValue(String string) {
        return null;
    }
}

