/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Circle
extends BasicGeom {
    private double x;
    private double y;
    private double r;

    public Circle(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.r = d3;
    }

    @Override
    public Circle copy() {
        return new Circle(this.x, this.y, this.r);
    }

    @Override
    public final Rect getBounds() {
        return new Rect(this.x - this.r, this.y - this.r, this.r * 2.0, this.r * 2.0);
    }

    @Override
    public final Circle getEnclosingCircle() {
        return this;
    }

    @Override
    public final boolean containsPt(double d, double d2) {
        return (d - this.x) * (d - this.x) + (d2 - this.y) * (d2 - this.y) - this.r * this.r < 0.0;
    }

    @Override
    public final double distanceToPt(double d, double d2) {
        return Math.sqrt((d - this.x) * (d - this.x) + (d2 - this.y) * (d2 - this.y)) - this.r;
    }

    @Override
    public final Point getCenter() {
        return new Point(this.x, this.y);
    }

    @Override
    public final void transform(double d, double d2, double d3, double d4) {
        this.x = d * this.x + d2;
        this.y = d3 * this.y + d4;
        this.r *= Math.sqrt(d * d3);
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, Rect rect, int n) {
        if (rect != null) {
            this.setX(rect.getCenterX());
            this.setY(rect.getCenterY());
            this.setR(Math.min(rect.getWidth(), rect.getHeight()) / 2.0);
        } else {
            this.setX(this.x * d + d2);
            this.setY(this.y * d3 + d4);
            if (n == 3) {
                this.setR(this.r * Math.min(d, d3));
            }
        }
    }

    @Override
    public final boolean filled() {
        return true;
    }

    @Override
    public final double area() {
        return Math.PI * this.r * this.r;
    }

    @Override
    public final Poly asPoly() {
        int n = this.getPolygonalApproximationSideCount();
        double d = this.r * Math.sqrt(Math.PI * 2 / (double)n / Math.sin(Math.PI * 2 / (double)n));
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double d2 = 3.9269908169872414;
        for (int i = 0; i < n; ++i) {
            double d3 = d2 + Math.PI * 2 * (double)i / (double)n;
            dArray[i] = this.x + d * Math.cos(d3);
            dArray2[i] = this.y + d * Math.sin(d3);
        }
        return new Poly(dArray, dArray2, true);
    }

    private int getPolygonalApproximationSideCount() {
        if (this.r < 3.25) {
            return 8;
        }
        double d = 2.0 * Math.acos(1.0 - 0.25 / this.r);
        return (int)Math.round(Math.PI * 2 / d);
    }

    @Override
    public final boolean containsBasic(BasicGeom basicGeom) {
        int n = basicGeom.type();
        if (n == 1001) {
            Circle circle = (Circle)basicGeom;
            return (this.x - circle.getX()) * (this.x - circle.getX()) + (this.y - circle.getY()) * (this.y - circle.getY()) <= (circle.getR() - this.r) * (circle.getR() - this.r);
        }
        if (n == 1002) {
            return this.getInsideDistanceRect((Rect)basicGeom) <= 0.0;
        }
        return this.getInsideDistancePoly((Poly)basicGeom) <= 0.0;
    }

    @Override
    public final double distanceToBasic(BasicGeom basicGeom) {
        int n = basicGeom.type();
        if (n == 1001) {
            Circle circle = (Circle)basicGeom;
            double d = Math.sqrt((this.x - circle.getX()) * (this.x - circle.getX()) + (this.y - circle.getY()) * (this.y - circle.getY()));
            if (d > circle.getR() + this.r) {
                return d - circle.getR() - this.r;
            }
            if (d < Math.abs(circle.getR() - this.r)) {
                return d - Math.abs(circle.getR() - this.r);
            }
            return 0.0;
        }
        if (n == 1000) {
            return basicGeom.distanceToBasic(this);
        }
        if (n == 1002) {
            Rect rect = (Rect)basicGeom;
            double d = this.getInsideDistanceRect(rect);
            if (d < 0.0) {
                return d;
            }
            double d2 = rect.distanceToPt(this.x, this.y);
            if (d2 < 0.0) {
                return Math.min(d2 + this.r, 0.0);
            }
            return Math.max(d2 - this.r, 0.0);
        }
        Poly poly = (Poly)basicGeom;
        double d = this.getInsideDistancePoly(poly);
        if (d < 0.0) {
            return d;
        }
        double d3 = poly.distanceToPt(this.x, this.y);
        if (d3 < 0.0) {
            return Math.min(d3 + this.r, 0.0);
        }
        return Math.max(d3 - this.r, 0.0);
    }

    private double getInsideDistanceRect(Rect rect) {
        double d = this.distanceToPt(rect.getX(), rect.getY());
        if (d >= 0.0) {
            return d;
        }
        if ((d = Math.max(d, this.distanceToPt(rect.getX() + rect.getWidth(), rect.getY()))) >= 0.0) {
            return d;
        }
        if ((d = Math.max(d, this.distanceToPt(rect.getX(), rect.getY() + rect.getHeight()))) >= 0.0) {
            return d;
        }
        return Math.max(d, this.distanceToPt(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight()));
    }

    private double getInsideDistancePoly(Poly poly) {
        double d = this.distanceToPt(poly.getX()[0], poly.getY()[0]);
        for (int i = 0; i < poly.getX().length && !(d >= 0.0); ++i) {
            d = Math.max(d, this.distanceToPt(poly.getX()[i], poly.getY()[i]));
        }
        return d;
    }

    @Override
    public final boolean similar(Geom geom) {
        if (geom == this) {
            return true;
        }
        if (geom.type() != this.type()) {
            return false;
        }
        Circle circle = (Circle)geom;
        return Math.abs(this.x - circle.getX()) < 0.001 && Math.abs(this.y - circle.getY()) < 0.001 && Math.abs(this.r - circle.getR()) < 0.001;
    }

    public void unionWithCircle(Circle circle) {
        double d;
        double d2 = circle.getX() - this.x;
        double d3 = d2 * d2 + (d = circle.getY() - this.y) * d;
        if (d3 <= (circle.getR() - this.r) * (circle.getR() - this.r)) {
            if (circle.getR() > this.r) {
                this.x = circle.x;
                this.y = circle.y;
                this.r = circle.r;
            }
        } else {
            double d4 = Math.sqrt(d3);
            double d5 = (this.r + circle.getR() + d4) / 2.0;
            this.x += (d5 - this.r) * d2 / d4;
            this.y += (d5 - this.r) * d / d4;
            this.r = d5;
        }
    }

    @Override
    public final int type() {
        return 1001;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getR() {
        return this.r;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final void setR(double d) {
        this.r = d;
    }

    @Override
    public int transpose(Dim dim, int n) {
        double d = dim.getWidth() - dim.getWidth() * this.y / dim.getHeight();
        this.y = dim.getHeight() * (1.0 - this.x / dim.getWidth());
        this.x = d;
        return n;
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        if (bl) {
            this.y = dim.getHeight() - this.y;
        } else {
            this.x = dim.getWidth() - this.x;
        }
    }

    @Override
    public Geom applyPointTransform(PointTransform pointTransform) {
        if (pointTransform.preservesLines()) {
            Point point = pointTransform.transform(this.x, this.y);
            this.x = point.getX();
            this.y = point.getY();
            return this;
        }
        return Curve.makeFromCircle(this).applyPointTransform(pointTransform);
    }

    @Override
    public Circle inset(double d) {
        return Math.abs(d) < 0.001 ? this : new Circle(this.x, this.y, Math.max(0.0, this.r - d));
    }

    @Override
    public Point boundaryPoint(double d, double d2) {
        double d3 = Point.distancePtPt(this.x, this.y, d, d2);
        return new Point(this.x + (d - this.x) / d3 * this.r, this.y + (d2 - this.y) / d3 * this.r);
    }
}

