/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CompositeGeom
extends Geom {
    private Geom[] parts;
    private String[] partNames;
    private boolean oddEven;
    private Rect calculatedBounds;
    private final boolean partFilled;

    public CompositeGeom(Geom[] geomArray, boolean bl, String[] stringArray) {
        if (geomArray.length == 0) {
            throw new IllegalArgumentException("Parts must have at least one item");
        }
        this.parts = new Geom[geomArray.length];
        this.partNames = stringArray != null ? new String[geomArray.length] : null;
        for (int i = 0; i < geomArray.length; ++i) {
            this.parts[i] = geomArray[i].copy();
            if (stringArray == null) continue;
            this.partNames[i] = stringArray[i];
        }
        this.oddEven = bl;
        this.partFilled = CompositeGeom.anyFilled(geomArray);
    }

    @Override
    public CompositeGeom copy() {
        return new CompositeGeom(this.parts, this.oddEven, this.partNames);
    }

    public Geom getImmutable() {
        return this;
    }

    public final Geom[] getParts() {
        return this.parts;
    }

    public final String[] getPartNames() {
        return this.partNames;
    }

    public final boolean getOddEven() {
        return this.oddEven;
    }

    private static boolean anyFilled(Geom[] geomArray) {
        for (Geom geom : geomArray) {
            if (!geom.filled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Rect getBounds() {
        if (this.calculatedBounds == null) {
            this.calculatedBounds = this.parts[0].getBounds().copy();
            for (int i = 0; i < this.parts.length; ++i) {
                this.calculatedBounds.extendToRect(this.parts[i].getBounds());
            }
        }
        return this.calculatedBounds;
    }

    @Override
    public final Circle getEnclosingCircle() {
        Circle circle = this.parts[0].getEnclosingCircle().copy();
        for (int i = 0; i < this.parts.length; ++i) {
            circle.unionWithCircle(this.parts[i].getEnclosingCircle());
        }
        return circle;
    }

    @Override
    public final Point getCenter() {
        return this.getBounds().getCenter();
    }

    @Override
    public final double area() {
        return this.partFilled ? this.getBounds().area() : 0.0;
    }

    @Override
    public final boolean containsPt(double d, double d2) {
        boolean bl = false;
        for (Geom geom : this.parts) {
            if (!geom.containsPt(d, d2)) continue;
            if (this.oddEven) {
                bl = !bl;
                continue;
            }
            return true;
        }
        return bl;
    }

    @Override
    public double distanceToPt(double d, double d2) {
        double[] dArray = new double[this.parts.length];
        for (int i = 0; i < this.parts.length; ++i) {
            dArray[i] = this.parts[i].distanceToPt(d, d2);
            if (!(Math.abs(dArray[i]) < 0.001)) continue;
            return 0.0;
        }
        return this.partDistancesToTotalDistance(dArray);
    }

    @Override
    public boolean containsGeom(Geom geom) {
        if (!this.getBounds().containsGeom(geom.getBounds())) {
            return false;
        }
        if (this.oddEven) {
            return this.distanceToGeom(geom) < 0.0;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            if (!this.parts[i].containsGeom(geom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double distanceToGeom(Geom geom) {
        double[] dArray = new double[this.parts.length];
        for (int i = 0; i < this.parts.length; ++i) {
            dArray[i] = this.parts[i].distanceToGeom(geom);
            if (!this.oddEven || !(Math.abs(dArray[i]) < 0.001)) continue;
            return 0.0;
        }
        return this.partDistancesToTotalDistance(dArray);
    }

    private double partDistancesToTotalDistance(double[] dArray) {
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        boolean bl = false;
        for (int i = 0; i < this.parts.length; ++i) {
            double d4 = dArray[i];
            if (d4 < 0.0) {
                bl = this.oddEven ? !bl : true;
                d = Math.min(-d4, d);
                d2 = Math.max(-d4, d2);
                continue;
            }
            d3 = Math.min(d4, d3);
        }
        if (this.oddEven) {
            double d5 = Math.min(d, d3);
            return bl ? -d5 : d5;
        }
        return bl ? -d2 : d3;
    }

    @Override
    public final int type() {
        return 1007;
    }

    @Override
    public void transform(double d, double d2, double d3, double d4) {
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].transform(d, d2, d3, d4);
        }
    }

    @Override
    public final boolean filled() {
        return this.partFilled;
    }

    @Override
    public final BasicGeom asBasic() {
        throw new EngineException("A composite geom cannot be converted to a basic one", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
    }

    @Override
    public boolean isBasic() {
        return false;
    }

    @Override
    public boolean similar(Geom geom) {
        if (geom == this) {
            return true;
        }
        if (geom.type() != this.type()) {
            return false;
        }
        CompositeGeom compositeGeom = (CompositeGeom)geom;
        if (this.oddEven != compositeGeom.getOddEven()) {
            return false;
        }
        if (this.parts.length != compositeGeom.getParts().length) {
            return false;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].similar(compositeGeom.getParts()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, Rect rect, int n) {
        throw new IllegalStateException("A composite geom cannot be modified through affine");
    }

    @Override
    public int transpose(Dim dim, int n) {
        throw new IllegalStateException("A composite geom cannot be modified through transpose");
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        throw new IllegalStateException("A composite geom cannot be modified through reflect");
    }

    @Override
    public Geom applyPointTransform(PointTransform pointTransform) {
        Geom[] geomArray = this.parts;
        for (int i = 0; i < geomArray.length; ++i) {
            geomArray[i] = this.parts[i].applyPointTransform(pointTransform);
        }
        return new CompositeGeom(this.parts, this.filled(), this.partNames);
    }

    @Override
    public CompositeGeom inset(double d) {
        if (Math.abs(d) < 0.001) {
            return this;
        }
        Rect rect = this.getBounds();
        Rect rect2 = rect.inset(d);
        if (rect.area() < 0.001) {
            return this;
        }
        double d2 = rect2.getWidth() / rect.getWidth();
        double d3 = rect2.getHeight() / rect.getHeight();
        double d4 = rect2.getX() - rect.getX() * d2;
        double d5 = rect2.getY() - rect.getY() * d3;
        CompositeGeom compositeGeom = this.copy();
        compositeGeom.transform(d2, d4, d3, d5);
        return compositeGeom;
    }
}

