/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.geom.CurveToPoly;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.NonBasicGeom;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import java.util.Arrays;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Curve
extends NonBasicGeom {
    private final Poly base;
    private boolean[] controls;
    public static final double PIXEL_APPROXIMATION = 0.25;
    private static Curve UNIT_CIRCLE;

    public static Curve makeFromCircle(Circle circle) {
        if (UNIT_CIRCLE == null) {
            UNIT_CIRCLE = new Curve(new double[]{-1.0, -1.0, -0.5522875, 0.0, 0.5522875, 1.0, 1.0, 1.0, 0.5522875, 0.0, -0.5522875, -1.0, -1.0}, new double[]{0.0, 0.5522875, 1.0, 1.0, 1.0, 0.5522875, 0.0, -0.5522875, -1.0, -1.0, -1.0, -0.5522875, 0.0}, new boolean[]{false, true, true, false, true, true, false, true, true, false, true, true, false}, circle.filled());
        }
        Curve curve = UNIT_CIRCLE.copy();
        curve.transform(circle.getR(), circle.getX(), circle.getR(), circle.getY());
        return curve;
    }

    public Curve(double[] dArray, double[] dArray2, boolean[] blArray, boolean bl) {
        this.base = new Poly(dArray, dArray2, bl);
        this.controls = blArray;
    }

    public boolean sameStructure(Curve curve) {
        if (this.controls.length != curve.getControls().length) {
            return false;
        }
        for (int i = 0; i < this.controls.length; ++i) {
            if (this.controls[i] == curve.getControls()[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Curve copy() {
        int n = this.controls.length;
        return new Curve(Arrays.copyOf(this.base.getX(), n), Arrays.copyOf(this.base.getY(), n), Arrays.copyOf(this.controls, n), this.base.isClosed());
    }

    @Override
    public final int type() {
        return 1004;
    }

    @Override
    public final boolean filled() {
        return this.base.filled();
    }

    @Override
    public boolean similar(Geom geom) {
        if (geom == this) {
            return true;
        }
        if (geom.type() != this.type()) {
            return false;
        }
        Curve curve = (Curve)geom;
        return this.base.similar(curve.base) && this.sameStructure(curve);
    }

    @Override
    public Geom simplify() {
        return CurveToPoly.linearize(this);
    }

    public final double[] getX() {
        return this.base.getX();
    }

    public final double[] getY() {
        return this.base.getY();
    }

    public final boolean[] getControls() {
        return this.controls;
    }

    public final boolean isClosed() {
        return this.base.isClosed();
    }

    @Override
    public final void transform(double d, double d2, double d3, double d4) {
        this.base.transform(d, d2, d3, d4);
        this.invalidate();
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, Rect rect, int n) {
        this.base.affine(d, d2, d3, d4, rect, n);
        this.invalidate();
    }

    @Override
    public int transpose(Dim dim, int n) {
        this.invalidate();
        return this.base.transpose(dim, n);
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        this.base.reflect(dim, bl);
        this.invalidate();
    }

    @Override
    public Curve inset(double d) {
        if (Math.abs(d) < 0.001) {
            return this;
        }
        Poly poly = this.base.inset(d);
        return new Curve(poly.getX(), poly.getY(), this.controls, this.base.isClosed());
    }
}

