/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class Geom {
    public static final double PIXEL_EPSILON = 0.001;
    public static final double PIXEL_EPSILON_SQ = 1.0E-6;

    public abstract int type();

    public abstract boolean isBasic();

    public abstract Geom copy();

    public abstract Rect getBounds();

    public abstract Circle getEnclosingCircle();

    public abstract Point getCenter();

    public abstract BasicGeom asBasic();

    public abstract boolean containsGeom(Geom var1);

    public abstract double distanceToGeom(Geom var1);

    public abstract boolean filled();

    public abstract double area();

    public abstract boolean containsPt(double var1, double var3);

    public final boolean containsPoint(Point point) {
        return this.containsPt(point.getX(), point.getY());
    }

    public abstract double distanceToPt(double var1, double var3);

    public final double distanceToPoint(Point point) {
        return this.distanceToPt(point.getX(), point.getY());
    }

    public abstract boolean similar(Geom var1);

    public abstract void transform(double var1, double var3, double var5, double var7);

    public abstract void affine(double var1, double var3, double var5, double var7, Rect var9, int var10);

    public abstract int transpose(Dim var1, int var2);

    public abstract void reflect(Dim var1, boolean var2);

    public abstract Geom applyPointTransform(PointTransform var1);

    public abstract Geom inset(double var1);

    public final Geom expand(double d) {
        return this.inset(-d);
    }

    public Point boundaryPoint(double d, double d2) {
        Circle circle = this.getEnclosingCircle();
        if (!this.filled()) {
            return circle.boundaryPoint(d, d2);
        }
        double d3 = Point.distancePtPt(d, d2, circle.getX(), circle.getY());
        double d4 = (d - circle.getX()) / d3;
        double d5 = (d2 - circle.getY()) / d3;
        double d6 = 0.0;
        double d7 = circle.getR();
        while (d7 - d6 > 0.001) {
            double d8 = (d6 + d7) / 2.0;
            if (this.containsPt(circle.getX() + d8 * d4, circle.getY() + d8 * d5)) {
                d6 = d8;
                continue;
            }
            d7 = d8;
        }
        return new Point(circle.getX() + d7 * d4, circle.getY() + d7 * d5);
    }
}

