/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Line
extends BasicGeom {
    private double x1;
    private double y1;
    private double x2;
    private double y2;

    public Line(double d, double d2, double d3, double d4) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
    }

    @Override
    public Line copy() {
        return new Line(this.x1, this.y1, this.x2, this.y2);
    }

    @Override
    public final int type() {
        return 1000;
    }

    @Override
    public final Rect getBounds() {
        return new Rect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
    }

    @Override
    public final Circle getEnclosingCircle() {
        return new Circle((this.x1 + this.x2) / 2.0, (this.y1 + this.y2) / 2.0, Point.distancePtPt(this.x1, this.y1, this.x2, this.y2) / 2.0);
    }

    @Override
    public final Point getCenter() {
        return new Point((this.x1 + this.x2) / 2.0, (this.y1 + this.y2) / 2.0);
    }

    @Override
    public final void transform(double d, double d2, double d3, double d4) {
        this.x1 = this.x1 * d + d2;
        this.y1 = this.y1 * d3 + d4;
        this.x2 = this.x2 * d + d2;
        this.y2 = this.y2 * d3 + d4;
    }

    @Override
    public final boolean filled() {
        return false;
    }

    @Override
    public final double area() {
        return 0.0;
    }

    @Override
    public final Poly asPoly() {
        return new Poly(new double[]{this.x1, this.x2}, new double[]{this.y1, this.y2}, false);
    }

    @Override
    public final boolean containsBasic(BasicGeom basicGeom) {
        return false;
    }

    @Override
    public final double distanceToBasic(BasicGeom basicGeom) {
        int n = basicGeom.type();
        if (n == 1000) {
            Line line = (Line)basicGeom;
            if (Line.segmentsIntersect(this.x1, this.y1, this.x2, this.y2, line.getX1(), line.getY1(), line.getX2(), line.getY2(), false)) {
                return 0.0;
            }
            return Math.min(Math.min(this.distanceToPt(line.getX1(), line.getY1()), this.distanceToPt(line.getX2(), line.getY2())), Math.min(line.distanceToPt(this.x1, this.y1), line.distanceToPt(this.x2, this.y2)));
        }
        if (n == 1001) {
            Circle circle = (Circle)basicGeom;
            double d = this.distanceToPt(circle.getX(), circle.getY());
            return Math.max(0.0, d - circle.getR());
        }
        return this.asPoly().distanceToBasic(basicGeom);
    }

    @Override
    public final boolean containsPt(double d, double d2) {
        return false;
    }

    @Override
    public double distanceToPt(double d, double d2) {
        double d3 = (this.y2 - this.y1) * (this.y2 - this.y1) + (this.x2 - this.x1) * (this.x2 - this.x1);
        if (d3 < 1.0E-6) {
            return Point.distancePtPt(d, d2, this.x1, this.y1);
        }
        double d4 = ((d - this.x1) * (this.x2 - this.x1) + (d2 - this.y1) * (this.y2 - this.y1)) / d3;
        if (d4 < 0.0) {
            return Point.distancePtPt(d, d2, this.x1, this.y1);
        }
        if (d4 > 1.0) {
            return Point.distancePtPt(d, d2, this.x2, this.y2);
        }
        double d5 = this.x1 + d4 * (this.x2 - this.x1);
        double d6 = this.y1 + d4 * (this.y2 - this.y1);
        return Math.sqrt((d5 - d) * (d5 - d) + (d6 - d2) * (d6 - d2));
    }

    @Override
    public boolean similar(Geom geom) {
        if (geom == this) {
            return true;
        }
        if (geom.type() != this.type()) {
            return false;
        }
        Line line = (Line)geom;
        return Math.abs(this.x1 - line.getX1()) < 0.001 && Math.abs(this.y1 - line.getY1()) < 0.001 && Math.abs(this.x2 - line.getX2()) < 0.001 && Math.abs(this.y2 - line.getY2()) < 0.001;
    }

    @Override
    public Geom applyPointTransform(PointTransform pointTransform) {
        if (pointTransform.preservesLines()) {
            Point point = pointTransform.transform(this.x1, this.y1);
            this.x1 = point.getX();
            this.y1 = point.getY();
            point = pointTransform.transform(this.x2, this.y2);
            this.x2 = point.getX();
            this.y2 = point.getY();
            return this;
        }
        return this.asPoly().applyPointTransform(pointTransform);
    }

    public static final double segmentPerpendicularDistanceSquared(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d4 - d2) * (d4 - d2) + (d3 - d) * (d3 - d);
        if (d7 < 1.0E-6) {
            return Double.MAX_VALUE;
        }
        double d8 = ((d5 - d) * (d3 - d) + (d6 - d2) * (d4 - d2)) / d7;
        if (d8 < 0.0 || d8 > 1.0) {
            return Double.MAX_VALUE;
        }
        double d9 = d + d8 * (d3 - d);
        double d10 = d2 + d8 * (d4 - d2);
        return (d9 - d5) * (d9 - d5) + (d10 - d6) * (d10 - d6);
    }

    public static final double extendedLineDistanceToPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d4 - d2) * (d4 - d2) + (d3 - d) * (d3 - d);
        if (d7 < 1.0E-6) {
            return Point.distancePtPt(d, d2, d5, d6);
        }
        double d8 = ((d5 - d) * (d3 - d) + (d6 - d2) * (d4 - d2)) / d7;
        double d9 = d + d8 * (d3 - d);
        double d10 = d2 + d8 * (d4 - d2);
        return Math.sqrt((d9 - d5) * (d9 - d5) + (d10 - d6) * (d10 - d6));
    }

    public static final boolean segmentsIntersect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        double d9 = (d8 - d6) * (d3 - d) - (d7 - d5) * (d4 - d2);
        if (Math.abs(d9) < 1.0E-6) {
            return false;
        }
        double d10 = ((d7 - d5) * (d2 - d6) - (d8 - d6) * (d - d5)) / d9;
        double d11 = bl ? 1.0E-6 : -1.0E-6;
        if (d10 < d11 || d10 > 1.0 - d11) {
            return false;
        }
        double d12 = ((d3 - d) * (d2 - d6) - (d4 - d2) * (d - d5)) / d9;
        return d12 > d11 && d12 < 1.0 - d11;
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, Rect rect, int n) {
        this.x1 = this.x1 * d + d2;
        this.x2 = this.x2 * d + d2;
        this.y1 = this.y1 * d + d2;
        this.y2 = this.y2 * d + d2;
    }

    @Override
    public int transpose(Dim dim, int n) {
        Point point = new Point(this.x1, this.y1);
        point.transpose(dim);
        Point point2 = new Point(this.x2, this.y2);
        point2.transpose(dim);
        this.x1 = point.getX();
        this.y1 = point.getY();
        this.x2 = point2.getX();
        this.y2 = point2.getY();
        return n;
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        if (bl) {
            this.y1 = dim.getHeight() - this.y1;
            this.y2 = dim.getHeight() - this.y2;
        } else {
            this.x1 = dim.getWidth() - this.x1;
            this.x2 = dim.getWidth() - this.x2;
        }
    }

    @Override
    public Geom inset(double d) {
        double d2 = this.getLength();
        if (d2 < 0.001 || Math.abs(d) < 0.001) {
            return this;
        }
        d = Math.min(d, d2 / 2.0);
        double d3 = (this.x2 - this.x1) * d / d2;
        double d4 = (this.y2 - this.y1) * d / d2;
        return new Line(this.x1 + d3, this.y1 + d4, this.x2 - d3, this.y2 - d4);
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getY1() {
        return this.y1;
    }

    public final double getX2() {
        return this.x2;
    }

    public final double getY2() {
        return this.y2;
    }

    public final double getLength() {
        return Math.sqrt((this.x1 - this.x2) * (this.x1 - this.x2) + (this.y1 - this.y2) * (this.y1 - this.y2));
    }

    public boolean intersects(Rect rect) {
        if (Line.segmentsIntersect(this.x1, this.y1, this.x2, this.y2, rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMinY(), false)) {
            return true;
        }
        if (Line.segmentsIntersect(this.x1, this.y1, this.x2, this.y2, rect.getMinX(), rect.getMinY(), rect.getMinX(), rect.getMaxY(), false)) {
            return true;
        }
        if (Line.segmentsIntersect(this.x1, this.y1, this.x2, this.y2, rect.getMinX(), rect.getMaxY(), rect.getMaxX(), rect.getMaxY(), false)) {
            return true;
        }
        if (Line.segmentsIntersect(this.x1, this.y1, this.x2, this.y2, rect.getMaxX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY(), false)) {
            return true;
        }
        return rect.containsPt(this.x1, this.y1);
    }
}

