/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Dim;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Point {
    private double x;
    private double y;

    public static final double distancePtPt(double d, double d2, double d3, double d4) {
        return Math.hypot(d - d3, d2 - d4);
    }

    public Point(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public final double distanceToBasic(BasicGeom basicGeom) {
        return basicGeom.distanceToPt(this.x, this.y);
    }

    public final double distance(Point point) {
        return Math.hypot(this.x - point.x, this.y - point.y);
    }

    public final double distanceToPt(double d, double d2) {
        return Math.hypot(this.x - d, this.y - d2);
    }

    public final Point transform(double d, double d2, double d3, double d4) {
        return new Point(d * this.x + d2, d3 * this.y + d4);
    }

    public final boolean similar(Point point) {
        return Math.abs(this.x - point.x) < 0.001 && Math.abs(this.y - point.y) < 0.001;
    }

    public final Point add(double d, double d2) {
        return new Point(this.x + d, this.y + d2);
    }

    public final void affine(double d, double d2, double d3, double d4) {
        this.x = this.x * d + d2;
        this.y = this.y * d3 + d4;
    }

    public final void transpose(Dim dim) {
        double d = this.x / dim.getWidth();
        this.x = dim.getWidth() - dim.getWidth() * this.y / dim.getHeight();
        this.y = dim.getHeight() - dim.getHeight() * d;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public final double angle(Point point) {
        return Math.atan2(point.y - this.y, point.x - this.x);
    }

    public Point interpolateTo(Point point, double d) {
        return new Point(this.x + (point.x - this.x) * d, this.y + (point.y - this.y) * d);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Point) {
            Point point = (Point)object;
            return this.x == point.x && this.y == point.y;
        }
        return false;
    }

    public final void snapPosition() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final Point copy() {
        return new Point(this.x, this.y);
    }

    public Point negate() {
        return new Point(-this.getX(), -this.getY());
    }
}

