/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Point;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class PointTransform {
    public abstract Point transform(double var1, double var3);

    public abstract boolean preservesLines();

    public final void addTransformedSegment(double d, double d2, double d3, double d4, List<Point> list) {
        this.recursiveAdd(d, d2, this.transform(d, d2), d3, d4, this.transform(d3, d4), list);
    }

    private void recursiveAdd(double d, double d2, Point point, double d3, double d4, Point point2, List<Point> list) {
        double d5 = (d + d3) / 2.0;
        double d6 = (d2 + d4) / 2.0;
        Point point3 = this.transform(d5, d6);
        if (Line.extendedLineDistanceToPoint(point.getX(), point.getY(), point2.getX(), point2.getY(), point3.getX(), point3.getY()) > 0.25) {
            this.recursiveAdd(d, d2, point, d5, d6, point3, list);
            this.recursiveAdd(d5, d6, point3, d3, d4, point2, list);
        } else {
            list.add(point);
        }
    }
}

