/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.geom.GeomInternalUtilities;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.Arrays;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Poly
extends BasicGeom {
    public static final double SLOPE_EPSILON = 1.0E-7;
    public static final double INVERSE_SLOPE_EPSILON = 1.0E7;
    private double[] x;
    private double[] y;
    private boolean closed;
    private Point center;
    private Rect bounds;
    private double signedArea;

    public Poly(double[] dArray, double[] dArray2, boolean bl) {
        this.x = Arrays.copyOf(dArray, dArray.length);
        this.y = Arrays.copyOf(dArray2, dArray2.length);
        this.closed = bl;
        this.buildCalculatedValues();
    }

    @Override
    public Geom copy() {
        return new Poly(Arrays.copyOf(this.x, this.x.length), Arrays.copyOf(this.y, this.y.length), this.closed);
    }

    @Override
    public final int type() {
        return 1003;
    }

    @Override
    public final Rect getBounds() {
        return this.bounds;
    }

    public final int getPointCount() {
        return this.x.length;
    }

    @Override
    public final Circle getEnclosingCircle() {
        Circle circle = this.x.length < 10 ? this.getEnclosingByAllPairs() : this.getEnclosingByBounds();
        double d = circle.getR() * circle.getR();
        for (int i = 0; i < this.x.length; ++i) {
            double d2;
            double d3 = this.x[i] - circle.getX();
            double d4 = d3 * d3 + (d2 = this.y[i] - circle.getY()) * d2;
            if (!(d4 > d)) continue;
            double d5 = Math.sqrt(d4);
            double d6 = (d5 - circle.getR()) / 2.0;
            circle = new Circle(circle.getX() + d3 * d6 / d5, circle.getY() + d2 * d6 / d5, d6 + circle.getR());
            d = circle.getR() * circle.getR();
        }
        return circle;
    }

    private Circle getEnclosingByAllPairs() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        for (int i = 1; i < this.x.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double d2 = (this.x[i] - this.x[j]) * (this.x[i] - this.x[j]) + (this.y[i] - this.y[j]) * (this.y[i] - this.y[j]);
                if (!(d2 > d)) continue;
                d = d2;
                n = i;
                n2 = j;
            }
        }
        return new Circle((this.x[n] + this.x[n2]) / 2.0, (this.y[n] + this.y[n2]) / 2.0, Math.sqrt(d) / 2.0);
    }

    private Circle getEnclosingByBounds() {
        double d;
        Point point = null;
        Point point2 = null;
        Point point3 = null;
        Point point4 = null;
        Rect rect = this.bounds.copy();
        rect.inset(0.001);
        for (int i = 0; i < this.x.length; ++i) {
            if (this.x[i] <= rect.getX()) {
                point = new Point(this.x[i], this.y[i]);
            }
            if (this.x[i] >= rect.getX() + rect.getWidth()) {
                point2 = new Point(this.x[i], this.y[i]);
            }
            if (this.y[i] <= rect.getY()) {
                point3 = new Point(this.x[i], this.y[i]);
            }
            if (!(this.y[i] >= rect.getY() + rect.getHeight())) continue;
            point4 = new Point(this.x[i], this.y[i]);
        }
        double d2 = point.distance(point2);
        if (d2 > (d = point3.distance(point4))) {
            return new Circle((point.getX() + point2.getX()) / 2.0, (point.getY() + point2.getY()) / 2.0, d2 / 2.0);
        }
        return new Circle((point3.getX() + point4.getX()) / 2.0, (point3.getY() + point4.getY()) / 2.0, d / 2.0);
    }

    private void buildCalculatedValues() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.x.length > 0) {
            double d4 = this.x[0];
            double d5 = this.y[0];
            double d6 = this.x[0];
            double d7 = this.y[0];
            int n = this.x.length - 1;
            int n2 = 0;
            while (n2 < this.x.length) {
                double d8 = this.x[n2] * this.y[n] - this.x[n] * this.y[n2];
                d += d8;
                d2 += (this.x[n2] + this.x[n]) * d8;
                d3 += (this.y[n2] + this.y[n]) * d8;
                d4 = Math.min(d4, this.x[n2]);
                d6 = Math.max(d6, this.x[n2]);
                d5 = Math.min(d5, this.y[n2]);
                d7 = Math.max(d7, this.y[n2]);
                n = n2++;
            }
            this.bounds = new Rect(d4, d5, d6 - d4, d7 - d5);
            this.signedArea = d / 2.0;
            this.center = Math.abs(d) < 0.001 ? new Point((d4 + d6) / 2.0, (d5 + d7) / 2.0) : new Point(d2 / d / 3.0, d3 / d / 3.0);
        }
    }

    @Override
    public final Point getCenter() {
        return this.center;
    }

    @Override
    public final boolean filled() {
        return this.closed;
    }

    @Override
    public final double area() {
        return this.closed ? Math.abs(this.signedArea) : 0.0;
    }

    @Override
    public final Poly asPoly() {
        return this;
    }

    @Override
    public final boolean containsBasic(BasicGeom basicGeom) {
        if (!this.closed) {
            return false;
        }
        if (basicGeom.type() == 1001) {
            Circle circle = (Circle)basicGeom;
            return this.containsPt(circle.getX(), circle.getY()) && this.distanceToBoundary(circle.getX(), circle.getY()) >= circle.getR();
        }
        if (!this.bounds.containsRect(basicGeom.getBounds())) {
            return false;
        }
        return this.distanceToPoly(basicGeom.asPoly()) < 0.0;
    }

    @Override
    public final double distanceToBasic(BasicGeom basicGeom) {
        int n = basicGeom.type();
        if (n == 1003) {
            return this.distanceToPoly((Poly)basicGeom);
        }
        return basicGeom.distanceToBasic(this);
    }

    @Override
    public final boolean containsPt(double d, double d2) {
        if (!this.closed) {
            return false;
        }
        if (!this.bounds.containsPt(d, d2)) {
            return false;
        }
        int n = 0;
        int n2 = this.x.length - 1;
        int n3 = 0;
        while (n3 < this.x.length) {
            double d3 = (this.y[n2] - this.y[n3]) / (this.x[n2] - this.x[n3]);
            if (!Double.isNaN(d3) && !(Math.abs(d3) < 1.0E-7)) {
                double d4;
                double d5;
                if (Math.abs(d3) > 1.0E7) {
                    d5 = this.x[n3];
                    d4 = d2;
                    if ((d4 > this.y[n3] - 0.001 && d4 < this.y[n2] + 0.001 || d4 > this.y[n2] - 0.001 && d4 < this.y[n3] + 0.001) && d5 < d) {
                        if (Math.abs(d4 - this.y[n3]) < 0.001) {
                            if (this.y[n2] > d2) {
                                ++n;
                            }
                        } else if (Math.abs(d4 - this.y[n2]) <= 0.001) {
                            if (this.y[n3] > d2) {
                                ++n;
                            }
                        } else {
                            ++n;
                        }
                    }
                } else {
                    d5 = this.y[n3] - d3 * this.x[n3];
                    d4 = (d2 - d5) / d3;
                    if ((d4 > this.x[n3] - 0.001 && d4 < this.x[n2] + 0.001 || d4 > this.x[n2] - 0.001 && d4 < this.x[n3] + 0.001) && d4 < d) {
                        if (Math.abs(d2 - this.y[n3]) <= 0.001) {
                            if (this.y[n2] > d2) {
                                ++n;
                            }
                        } else if (Math.abs(d2 - this.y[n2]) <= 0.0) {
                            if (this.y[n3] > d2) {
                                ++n;
                            }
                        } else {
                            ++n;
                        }
                    }
                }
            }
            n2 = n3++;
        }
        return n % 2 != 0;
    }

    @Override
    public double distanceToPt(double d, double d2) {
        double d3 = this.distanceToBoundary(d, d2);
        return this.containsPt(d, d2) ? -d3 : d3;
    }

    public double distanceToBoundsRect(double d, double d2) {
        return this.bounds.distanceToPt(d, d2);
    }

    public double distanceToBoundary(double d, double d2) {
        int n;
        double d3 = (d - this.x[0]) * (d - this.x[0]) + (d2 - this.y[0]) * (d2 - this.y[0]);
        for (n = 1; n < this.x.length; ++n) {
            d3 = Math.min(d3, (d - this.x[n]) * (d - this.x[n]) + (d2 - this.y[n]) * (d2 - this.y[n]));
        }
        if (d3 < 1.0E-6) {
            return 0.0;
        }
        n = this.closed ? this.x.length - 1 : 0;
        int n2 = 0;
        while (n2 < this.x.length) {
            double d4 = Line.segmentPerpendicularDistanceSquared(this.x[n], this.y[n], this.x[n2], this.y[n2], d, d2);
            if (d4 < d3 && (d3 = d4) < 1.0E-6) {
                return 0.0;
            }
            n = n2++;
        }
        return Math.sqrt(d3);
    }

    @Override
    public boolean similar(Geom geom) {
        if (geom == this) {
            return true;
        }
        if (geom.type() != this.type()) {
            return false;
        }
        Poly poly = (Poly)geom;
        if (this.x.length != poly.getPointCount() || this.closed != poly.closed) {
            return false;
        }
        for (int i = 0; i < this.x.length; ++i) {
            if (!((this.x[i] - poly.x[i]) * (this.x[i] - poly.x[i]) + (this.y[i] - poly.y[i]) * (this.y[i] - poly.y[i]) > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    public double distanceToPoly(Poly poly) {
        double d;
        int n;
        if (this.boundariesIntersect(poly)) {
            return 0.0;
        }
        double d2 = Double.MAX_VALUE;
        for (n = 0; n < poly.getPointCount(); ++n) {
            d = this.bounds.distanceToPt(poly.x[n], poly.y[n]);
            if (!(d < d2)) continue;
            d2 = Math.min(d2, this.distanceToBoundary(poly.x[n], poly.y[n]));
        }
        for (n = 0; n < this.x.length; ++n) {
            d = poly.getBounds().distanceToPt(this.x[n], this.y[n]);
            if (!(d < d2)) continue;
            d2 = Math.min(d2, poly.distanceToBoundary(this.x[n], this.y[n]));
        }
        if (this.closed && this.containsPt(poly.x[0], poly.y[0]) || poly.closed && poly.containsPt(this.x[0], this.y[0])) {
            return -d2;
        }
        return d2;
    }

    private boolean boundariesIntersect(Poly poly) {
        if (this.bounds.distance(poly.getBounds()) > 0.0) {
            return false;
        }
        int n = poly.getPointCount();
        for (int i = 1; i < n; ++i) {
            if (!this.segmentIntersectsBoundary(poly.x[i - 1], poly.y[i - 1], poly.x[i], poly.y[i])) continue;
            return true;
        }
        return poly.isClosed() && this.segmentIntersectsBoundary(poly.getX()[n - 1], poly.getY()[n - 1], poly.getX()[0], poly.getY()[0]);
    }

    private boolean segmentIntersectsBoundary(double d, double d2, double d3, double d4) {
        for (int i = 1; i < this.x.length; ++i) {
            if (!Line.segmentsIntersect(d, d2, d3, d4, this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], false)) continue;
            return true;
        }
        return this.closed && Line.segmentsIntersect(d, d2, d3, d4, this.x[this.x.length - 1], this.y[this.x.length - 1], this.x[0], this.y[0], false);
    }

    public final double[] getX() {
        return this.x;
    }

    public final double[] getY() {
        return this.y;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public Poly asClockwise() {
        if (this.signedArea < 0.0 && this.closed) {
            int n = this.x.length;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.x[n - 1 - i];
                dArray2[i] = this.y[n - 1 - i];
            }
            return new Poly(dArray, dArray2, this.closed);
        }
        return this;
    }

    @Override
    public final void transform(double d, double d2, double d3, double d4) {
        for (int i = 0; i < this.x.length; ++i) {
            this.x[i] = this.x[i] * d + d2;
            this.y[i] = this.y[i] * d3 + d4;
        }
        this.buildCalculatedValues();
    }

    @Override
    public int transpose(Dim dim, int n) {
        for (int i = 0; i < this.x.length; ++i) {
            double d = dim.getWidth() - dim.getWidth() * this.y[i] / dim.getHeight();
            this.y[i] = dim.getHeight() * (1.0 - this.x[i] / dim.getWidth());
            this.x[i] = d;
        }
        this.buildCalculatedValues();
        return n;
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        for (int i = 0; i < this.x.length; ++i) {
            if (bl) {
                this.y[i] = dim.getHeight() - this.y[i];
                continue;
            }
            this.x[i] = dim.getWidth() - this.x[i];
        }
        this.buildCalculatedValues();
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, Rect rect, int n) {
        double d5 = 0.0;
        double d6 = 0.0;
        if (rect != null) {
            Rect rect2 = this.getBounds();
            d = rect.getWidth() / rect2.getWidth();
            d3 = rect.getHeight() / rect2.getHeight();
            d2 = rect.getX() - rect2.getX();
            d4 = rect.getY() - rect2.getY();
            d5 = rect2.getX();
            d6 = rect2.getY();
        }
        double d7 = d;
        double d8 = d3;
        if ((n & 1) == 0) {
            d7 = 1.0;
        }
        if ((n & 2) == 0) {
            d8 = 1.0;
        }
        d5 *= 1.0 - d7;
        d6 *= 1.0 - d8;
        for (int i = 0; i < this.x.length; ++i) {
            this.x[i] = this.x[i] * d7 + d2 + d5;
            this.y[i] = this.y[i] * d8 + d4 + d6;
        }
        this.buildCalculatedValues();
    }

    @Override
    public Geom applyPointTransform(PointTransform pointTransform) {
        int n = this.x.length;
        if (pointTransform.preservesLines()) {
            for (int i = 0; i < n; ++i) {
                Point point = pointTransform.transform(this.x[i], this.y[i]);
                this.x[i] = point.getX();
                this.y[i] = point.getY();
            }
            return this;
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 1; i < n; ++i) {
            pointTransform.addTransformedSegment(this.x[i - 1], this.y[i - 1], this.x[i], this.y[i], arrayList);
        }
        if (this.closed) {
            pointTransform.addTransformedSegment(this.x[n - 1], this.y[n - 1], this.x[0], this.y[0], arrayList);
        } else {
            arrayList.add(pointTransform.transform(this.x[n - 1], this.y[n - 1]));
        }
        return GeomInternalUtilities.makeFromPoints(arrayList, this.closed);
    }

    @Override
    public Poly inset(double d) {
        if (Math.abs(d) < 0.001) {
            return this;
        }
        double[] dArray = new double[this.x.length];
        double[] dArray2 = new double[this.y.length];
        for (int i = 0; i < this.x.length; ++i) {
            double d2 = this.center.distanceToPt(this.x[i], this.y[i]);
            double d3 = Math.min(d / d2, 1.0);
            dArray[i] = this.x[i] + d3 * (this.center.getX() - this.x[i]);
            dArray2[i] = this.y[i] + d3 * (this.center.getY() - this.y[i]);
        }
        return new Poly(dArray, dArray2, this.closed);
    }
}

