/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Poly;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Rect
extends BasicGeom {
    private double x;
    private double y;
    private double width;
    private double height;

    public Rect(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    @Override
    public Rect copy() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    @Override
    public int type() {
        return 1002;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getCenterX() {
        return this.x + this.width / 2.0;
    }

    public final double getCenterY() {
        return this.y + this.height / 2.0;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getMinX() {
        return Math.min(this.x, this.x + this.width);
    }

    public final double getMinY() {
        return Math.min(this.y, this.y + this.height);
    }

    public final double getMaxX() {
        return Math.max(this.x, this.x + this.width);
    }

    public final double getMaxY() {
        return Math.max(this.y, this.y + this.height);
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final Dim getExtent() {
        return new Dim(this.width, this.height);
    }

    @Override
    public final Rect getBounds() {
        return this;
    }

    @Override
    public final boolean filled() {
        return true;
    }

    @Override
    public final double area() {
        return Math.abs(this.width * this.height);
    }

    @Override
    public Circle getEnclosingCircle() {
        double d = Math.sqrt(this.width * this.width + this.height * this.height) / 2.0;
        return new Circle(this.x + this.width / 2.0, this.y + this.height / 2.0, d);
    }

    @Override
    public Point getCenter() {
        return new Point(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public final boolean containsRect(Rect rect) {
        return rect.x >= this.x && rect.x + rect.width <= this.x + this.width && rect.y >= this.y && rect.y + rect.height <= this.y + this.height;
    }

    @Override
    public final boolean containsPt(double d, double d2) {
        return d >= this.x && d2 >= this.y && d <= this.x + this.width && d2 <= this.y + this.height;
    }

    public final boolean intersectsRect(Rect rect) {
        return this.y + this.height >= rect.y && this.y <= rect.getY() + rect.height && this.x + this.width >= rect.x && this.x <= rect.x + rect.width;
    }

    @Override
    public final Poly asPoly() {
        return new Poly(new double[]{this.x, this.x, this.x + this.width, this.x + this.width}, new double[]{this.y, this.y + this.height, this.y + this.height, this.y}, true);
    }

    @Override
    public Rect inset(double d) {
        if (Math.abs(d) < 0.001) {
            return this;
        }
        d = Math.min(d, Math.min(this.width / 2.0, this.height / 2.0));
        return new Rect(this.getMinX() + d, this.getMinY() + d, this.width - 2.0 * d, this.height - 2.0 * d);
    }

    @Override
    public boolean similar(Geom geom) {
        if (geom == this) {
            return true;
        }
        if (geom.type() != this.type()) {
            return false;
        }
        Rect rect = (Rect)geom;
        return Math.abs(this.x - rect.getX()) < 0.001 && Math.abs(this.y - rect.getY()) < 0.001 && Math.abs(this.width - rect.getWidth()) < 0.001 && Math.abs(this.height - rect.getHeight()) < 0.001;
    }

    @Override
    public Geom applyPointTransform(PointTransform pointTransform) {
        if (pointTransform.preservesLines() || this.width < 20.0 && this.height < 20.0) {
            Point point = pointTransform.transform(this.x, this.y);
            Point point2 = pointTransform.transform(this.x + this.width, this.y + this.height);
            this.x = point.getX();
            this.y = point.getY();
            this.width = point2.getX() - point.getX();
            this.height = point2.getY() - point.getY();
            return this;
        }
        return this.asPoly().applyPointTransform(pointTransform);
    }

    @Override
    public final double distanceToPt(double d, double d2) {
        if (d2 < this.y) {
            if (d < this.x) {
                return Math.sqrt((d - this.x) * (d - this.x) + (d2 - this.y) * (d2 - this.y));
            }
            if (d > this.x + this.width) {
                return Math.sqrt((d - this.x - this.width) * (d - this.x - this.width) + (d2 - this.y) * (d2 - this.y));
            }
            return this.y - d2;
        }
        if (d2 > this.y + this.height) {
            if (d < this.x) {
                return Math.sqrt((d - this.x) * (d - this.x) + (d2 - this.y - this.height) * (d2 - this.y - this.height));
            }
            if (d > this.x + this.width) {
                return Math.sqrt((d - this.x - this.width) * (d - this.x - this.width) + (d2 - this.y - this.height) * (d2 - this.y - this.height));
            }
            return d2 - this.y - this.height;
        }
        if (d < this.x) {
            return this.x - d;
        }
        if (d > this.x + this.width) {
            return d - this.x - this.width;
        }
        return -Math.min(Math.min(d - this.x, this.x + this.width - d), Math.min(d2 - this.y, this.y + this.height - d2));
    }

    @Override
    public final boolean containsBasic(BasicGeom basicGeom) {
        int n = basicGeom.type();
        if (n == 1001) {
            Circle circle = (Circle)basicGeom;
            if (circle.getY() < this.y || circle.getY() > this.y + this.height || circle.getX() < this.x || circle.getX() > this.x + this.width) {
                return false;
            }
            return Math.min(Math.min(circle.getX() - this.x, this.x + this.width - circle.getX()), Math.min(circle.getY() - this.y, this.y + this.height - circle.getY())) >= circle.getR();
        }
        if (n == 1002) {
            return this.containsRect((Rect)basicGeom);
        }
        Poly poly = (Poly)basicGeom;
        for (int i = 0; i < poly.getPointCount(); ++i) {
            if (this.containsPt(poly.getX()[i], poly.getY()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final double distanceToBasic(BasicGeom basicGeom) {
        int n = basicGeom.type();
        if (n == 1002) {
            return this.distance((Rect)basicGeom);
        }
        if (n == 1001) {
            Circle circle = (Circle)basicGeom;
            return circle.distanceToGeom(this);
        }
        if (n == 1000) {
            return basicGeom.distanceToBasic(this);
        }
        return this.asPoly().distanceToPoly((Poly)basicGeom);
    }

    public final double distance(Rect rect) {
        if (rect.getX() + rect.getWidth() < this.x) {
            if (rect.getY() > this.y + this.height) {
                return Point.distancePtPt(rect.getX() + rect.getWidth(), rect.getY(), this.x, this.y + this.height);
            }
            if (rect.getY() + rect.getHeight() < this.y) {
                return Point.distancePtPt(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight(), this.x, this.y);
            }
            return this.x - rect.getX() - rect.getWidth();
        }
        if (rect.getX() > this.x + this.width) {
            if (rect.getY() > this.y + this.height) {
                return Point.distancePtPt(rect.getX(), rect.getY(), this.x + this.width, this.y + this.height);
            }
            if (rect.getY() + rect.getHeight() < this.y) {
                return Point.distancePtPt(rect.getX(), rect.getY() + rect.getHeight(), this.x + this.width, this.y);
            }
            return rect.getX() - this.x - this.width;
        }
        if (rect.getY() > this.y + this.height) {
            return rect.getY() - this.y - this.height;
        }
        if (rect.getY() + rect.getHeight() < this.y) {
            return this.y - rect.getY() - rect.getHeight();
        }
        if (this.containsRect(rect) || rect.containsRect(this)) {
            double d = Math.min(Math.abs(this.x - rect.getX()), Math.abs(this.x + this.width - rect.getX() - rect.getWidth()));
            double d2 = Math.min(Math.abs(this.y - rect.getY()), Math.abs(this.y + this.height - rect.getY() - rect.getHeight()));
            return -Math.min(d, d2);
        }
        return 0.0;
    }

    public Rect makeIntersection(Rect rect) {
        if (!this.intersectsRect(rect)) {
            return null;
        }
        double d = Math.max(this.getMinX(), rect.getMinX());
        double d2 = Math.max(this.getMinY(), rect.getMinY());
        double d3 = Math.min(this.getMaxX(), rect.getMaxX()) - d;
        double d4 = Math.min(this.getMaxY(), rect.getMaxY()) - d2;
        return new Rect(d, d2, d3, d4);
    }

    public final double getX2() {
        return this.x + this.width;
    }

    public final double getY2() {
        return this.y + this.height;
    }

    public void extendToRect(Rect rect) {
        this.extendTo(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
    }

    public void extendTo(double d, double d2, double d3, double d4) {
        double d5;
        if (d < this.getMinX()) {
            d5 = this.getMaxX();
            this.x = d;
            this.width = d5 - this.x;
        }
        if (d3 > this.getMaxX()) {
            this.width = d3 - this.x;
        }
        if (d2 < this.y) {
            d5 = this.getMaxY();
            this.y = d2;
            this.height = d5 - this.y;
        }
        if (d4 > this.getMaxY()) {
            this.height = d4 - this.y;
        }
    }

    public boolean interiorsIntersect(Rect rect) {
        if (this.intersectsRect(rect)) {
            double d = Math.min(this.getMaxX(), rect.getMaxX()) - Math.max(this.getMinX(), rect.getMinX());
            double d2 = Math.min(this.getMaxY(), rect.getMaxY()) - Math.max(this.getMinY(), rect.getMinY());
            return d > 0.0 && d2 > 0.0;
        }
        return false;
    }

    public void normalize() {
        if (this.width < 0.0) {
            this.x += this.width;
            this.width = -this.width;
        }
        if (this.height < 0.0) {
            this.y += this.height;
            this.height = -this.height;
        }
    }

    public Rect makeGeometryClone() {
        return new Rect(this.x, this.y, this.getWidth(), this.getHeight());
    }

    public static Rect makeRectFromDim(Dim dim) {
        return new Rect(0.0, 0.0, dim.getWidth(), dim.getHeight());
    }

    public final void setWidth(double d) {
        this.width = d;
    }

    public final void setHeight(double d) {
        this.height = d;
    }

    public Point getTopLeft() {
        return new Point(this.getMinX(), this.getMinY());
    }

    public void extendToPoint(double d, double d2) {
        double d3;
        if (d < this.x) {
            d3 = this.getX2();
            this.setX(d);
            this.setWidth(d3 - this.x);
        } else if (d > this.getX2()) {
            this.setWidth(d - this.x);
        }
        if (d2 < this.y) {
            d3 = this.getY2();
            this.setY(d2);
            this.setHeight(d3 - this.y);
        } else if (d2 > this.getY2()) {
            this.setHeight(d2 - this.y);
        }
    }

    public boolean hasExtent() {
        return this.getWidth() > 0.0 && this.getHeight() > 0.0;
    }

    @Override
    public void transform(double d, double d2, double d3, double d4) {
        this.x = d * this.x + d2;
        this.y = d3 * this.y + d4;
        this.width = d * this.width;
        this.height = d3 * this.height;
        this.normalize();
    }

    @Override
    public int transpose(Dim dim, int n) {
        int n2 = n;
        if (n == 0) {
            Point point = this.getCenter();
            point.transpose(dim);
            this.x = point.getX() - this.width / 2.0;
            this.y = point.getY() - this.height / 2.0;
        } else {
            double d = this.width;
            double d2 = this.height;
            double d3 = dim.getWidth() - dim.getWidth() * (this.y + this.height) / dim.getHeight();
            this.y = dim.getHeight() * (1.0 - this.x / dim.getWidth());
            this.x = d3;
            d3 = dim.getWidth() * this.height / dim.getHeight();
            this.height = dim.getHeight() * this.width / dim.getWidth();
            this.width = d3;
            this.y -= this.height;
            if ((n & 2) == 0) {
                this.x -= (d2 - this.getWidth()) / 2.0;
                this.width = d2;
                n2 = 2;
            } else if ((n & 1) == 0) {
                this.y -= (d - this.getHeight()) / 2.0;
                this.height = d;
                n2 = 1;
            }
        }
        return n2;
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        if (bl) {
            this.y = dim.getHeight() - (this.y + this.getHeight());
        } else {
            this.x = dim.getWidth() - (this.x + this.getWidth());
        }
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, Rect rect, int n) {
        if (rect != null) {
            this.x = rect.getX();
            this.y = rect.getY();
            this.width = rect.getWidth();
            this.height = rect.getHeight();
        } else {
            this.x = this.x * d + d2;
            if ((n & 1) != 0) {
                this.width *= d;
            } else {
                this.x += (d - 1.0) * this.width / 2.0;
            }
            this.y = this.y * d3 + d4;
            if ((n & 2) != 0) {
                this.height *= d3;
            } else {
                this.y += (d3 - 1.0) * this.height / 2.0;
            }
        }
        this.normalize();
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }
}

