/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.geom.GeomBuilder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.NonBasicGeom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.PointTransform;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class RoundedRect
extends NonBasicGeom {
    private Rect rect;
    private double radius;
    private boolean radiusFixed;

    public RoundedRect(double d, double d2, double d3, double d4, double d5) {
        this.rect = new Rect(d, d2, d3, d4);
        this.radius = d5;
        this.setRadiusFixed(true);
    }

    public void setRadiusFixed(boolean bl) {
        this.radiusFixed = bl;
        this.invalidate();
    }

    public boolean getRadiusFixed() {
        return this.radiusFixed;
    }

    public void setCornerRadius(double d) {
        this.radius = d;
        this.invalidate();
    }

    public double getCornerRadius() {
        return this.radiusFixed ? this.radius : this.radius * Math.min(this.getWidth() / 2.0, this.getHeight() / 2.0);
    }

    public double getX() {
        return this.rect.getX();
    }

    public double getY() {
        return this.rect.getY();
    }

    public double getMinX() {
        return this.rect.getMinX();
    }

    public double getMinY() {
        return this.rect.getMinY();
    }

    public double getMaxX() {
        return this.rect.getMaxX();
    }

    public double getMaxY() {
        return this.rect.getMaxY();
    }

    public double getWidth() {
        return this.rect.getWidth();
    }

    public double getHeight() {
        return this.rect.getHeight();
    }

    public Point getTopLeft() {
        return this.rect.getTopLeft();
    }

    public Dim getExtent() {
        return this.rect.getExtent();
    }

    public void setX(double d) {
        this.rect.setX(d);
        this.invalidate();
    }

    public void setY(double d) {
        this.rect.setY(d);
        this.invalidate();
    }

    public void setWidth(double d) {
        this.rect.setWidth(d);
        this.invalidate();
    }

    public void setHeight(double d) {
        this.rect.setHeight(d);
        this.invalidate();
    }

    @Override
    public int type() {
        return 1005;
    }

    @Override
    public Geom copy() {
        RoundedRect roundedRect = new RoundedRect(this.rect.getX(), this.rect.getY(), this.rect.getWidth(), this.rect.getHeight(), this.radius);
        roundedRect.setRadiusFixed(this.radiusFixed);
        return roundedRect;
    }

    @Override
    protected Geom simplify() {
        double d = Math.min(this.getCornerRadius(), Math.min(this.rect.getWidth() / 2.0, this.rect.getHeight() / 2.0));
        if (d < 0.001) {
            return this.rect;
        }
        double d2 = this.rect.getX();
        double d3 = this.rect.getY();
        double d4 = this.rect.getWidth();
        double d5 = this.rect.getHeight();
        GeomBuilder geomBuilder = new GeomBuilder();
        double d6 = d2 + d4;
        double d7 = d3 + d5;
        geomBuilder.moveTo(d2, d3 + d);
        if (d > 0.001) {
            geomBuilder.arcTo(d2 + d, d3 + d, d, Math.PI, 4.71238898038469);
        }
        geomBuilder.lineTo(d6 - d, d3);
        if (d > 0.001) {
            geomBuilder.arcTo(d6 - d, d3 + d, d, 4.71238898038469, Math.PI * 2);
        }
        geomBuilder.lineTo(d6, d7 - d);
        if (d > 0.001) {
            geomBuilder.arcTo(d6 - d, d7 - d, d, 0.0, 1.5707963267948966);
        }
        geomBuilder.lineTo(d2 + d, d7);
        if (d > 0.001) {
            geomBuilder.arcTo(d2 + d, d7 - d, d, 1.5707963267948966, Math.PI);
        }
        geomBuilder.closePath();
        return geomBuilder.getGeom();
    }

    @Override
    public Rect getBounds() {
        return this.rect.getBounds();
    }

    @Override
    public Circle getEnclosingCircle() {
        return this.rect.getEnclosingCircle();
    }

    @Override
    public Point getCenter() {
        return this.rect.getCenter();
    }

    @Override
    public boolean containsGeom(Geom geom) {
        return this.rect.containsGeom(geom);
    }

    @Override
    public double distanceToGeom(Geom geom) {
        return this.rect.distanceToGeom(geom);
    }

    @Override
    public boolean filled() {
        return this.rect.filled();
    }

    @Override
    public double area() {
        return this.rect.area();
    }

    @Override
    public boolean containsPt(double d, double d2) {
        return this.rect.containsPt(d, d2);
    }

    @Override
    public double distanceToPt(double d, double d2) {
        return this.rect.distanceToPt(d, d2);
    }

    @Override
    public boolean similar(Geom geom) {
        if (geom == this) {
            return true;
        }
        if (geom.type() != this.type()) {
            return false;
        }
        RoundedRect roundedRect = (RoundedRect)geom;
        return Math.abs(roundedRect.radius - this.radius) < 0.001 && roundedRect.rect.similar(this.rect);
    }

    @Override
    public void transform(double d, double d2, double d3, double d4) {
        this.rect.transform(d, d2, d3, d4);
        this.invalidate();
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, Rect rect, int n) {
        this.rect.affine(d, d2, d3, d4, rect, n);
        this.invalidate();
    }

    @Override
    public int transpose(Dim dim, int n) {
        this.invalidate();
        return this.rect.transpose(dim, n);
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        this.rect.reflect(dim, bl);
        this.invalidate();
    }

    @Override
    public Geom applyPointTransform(PointTransform pointTransform) {
        this.invalidate();
        return this.rect.applyPointTransform(pointTransform);
    }

    @Override
    public RoundedRect inset(double d) {
        Rect rect = this.rect.inset(d);
        if (rect == this.rect) {
            return this;
        }
        return new RoundedRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), this.radius);
    }
}

