/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.geom;

import com.ibm.vis.engine.internal.geom.GeomBuilder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.NonBasicGeom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Wedge
extends NonBasicGeom {
    private Point origin;
    private double r1;
    private double r2;
    private double a1;
    private double a2;

    public Wedge(Point point, double d, double d2, double d3, double d4) {
        this.origin = point;
        this.r1 = d;
        this.r2 = d2;
        double d5 = d4 - d3;
        if (d5 < Math.PI * -2) {
            d5 = Math.PI * -2;
        } else if (d5 >= Math.PI * 2) {
            d5 = Math.PI * 2;
        }
        d3 %= Math.PI * 2;
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        this.a1 = d3;
        this.a2 = d3 + d5;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public double getR1() {
        return this.r1;
    }

    public double getR2() {
        return this.r2;
    }

    public double getA1() {
        return this.a1;
    }

    public double getA2() {
        return this.a2;
    }

    public void setOrigin(Point point) {
        this.origin = point;
        this.invalidate();
    }

    public void setR1(double d) {
        this.r1 = d;
        this.invalidate();
    }

    public void setR2(double d) {
        this.r2 = d;
        this.invalidate();
    }

    public void setA1(double d) {
        this.a1 = d;
        this.invalidate();
    }

    public void setA2(double d) {
        this.a2 = d;
        this.invalidate();
    }

    @Override
    public double area() {
        if (this.filled()) {
            double d = Math.abs(this.a2 - this.a1) * this.r2 * this.r2 / 2.0;
            double d2 = Math.abs(this.a2 - this.a1) * this.r1 * this.r1 / 2.0;
            return d - d2;
        }
        return 0.0;
    }

    public final boolean isCircle() {
        return Math.abs(this.a2 - this.a1) >= 6.282185307179586;
    }

    @Override
    public Point getCenter() {
        if (this.isCircle()) {
            return this.origin;
        }
        return this.getLabelCenter();
    }

    public Point getLabelCenter() {
        if (this.isCircle() && (this.r1 == 0.0 || this.r2 == 0.0)) {
            return this.origin;
        }
        double d = (2.0 * this.r1 + 3.0 * this.r2) / 5.0;
        double d2 = (this.a1 + this.a2) / 2.0;
        if (Double.isNaN(d)) {
            d = this.r2;
        }
        return new Point(this.origin.getX() + d * Math.cos(d2), this.origin.getY() + d * Math.sin(d2));
    }

    @Override
    public boolean filled() {
        return !Double.isNaN(this.r1);
    }

    @Override
    public Geom simplify() {
        if (!this.filled()) {
            GeomBuilder geomBuilder = new GeomBuilder();
            geomBuilder.makeArcPath(this.origin.getX(), this.origin.getY(), this.r2, this.a1, this.a2);
            return geomBuilder.getGeom();
        }
        if (this.isCircle() && this.r1 < 0.001) {
            return new Circle(this.origin.getX(), this.origin.getY(), this.r2);
        }
        GeomBuilder geomBuilder = new GeomBuilder();
        geomBuilder.setOddEven(true);
        geomBuilder.makeToroidPath(this.origin.getX(), this.origin.getY(), this.r1, this.r2, this.a1, this.a2);
        return geomBuilder.getGeom();
    }

    @Override
    public int type() {
        return 1006;
    }

    @Override
    public Wedge copy() {
        return new Wedge(this.origin.copy(), this.r1, this.r2, this.a1, this.a2);
    }

    @Override
    public boolean similar(Geom geom) {
        if (geom == this) {
            return true;
        }
        if (geom.type() != this.type()) {
            return false;
        }
        Wedge wedge = (Wedge)geom;
        return this.origin.distance(wedge.origin) < 0.001 && Math.abs(this.r1 - wedge.r1) < 0.001 && Math.abs(this.r2 - wedge.r2) < 0.001 && Math.abs(this.a1 - wedge.a1) < 0.001 && Math.abs(this.a2 - wedge.a2) < 0.001;
    }

    @Override
    public void transform(double d, double d2, double d3, double d4) {
        this.origin.affine(d, d2, d3, d4);
        this.r1 *= Math.min(d, d3);
        this.r2 *= Math.min(d, d3);
    }

    @Override
    public void affine(double d, double d2, double d3, double d4, Rect rect, int n) {
        this.transform(d, d2, d3, d4);
    }

    @Override
    public int transpose(Dim dim, int n) {
        throw new UnsupportedOperationException("Cannot transform a wedge");
    }

    @Override
    public void reflect(Dim dim, boolean bl) {
        throw new UnsupportedOperationException("Cannot transform a wedge");
    }

    @Override
    public boolean containsPt(double d, double d2) {
        if (!this.filled()) {
            return false;
        }
        double d3 = this.origin.distanceToPt(d, d2);
        if (d3 < this.r1 || d3 > this.r2) {
            return false;
        }
        if (d3 == 0.0) {
            return true;
        }
        if (this.isCircle()) {
            return true;
        }
        return Wedge.angleIsWithin(Math.atan2(d2 - this.origin.getY(), d - this.origin.getX()), this.a1, this.a2);
    }

    private static boolean angleIsWithin(double d, double d2, double d3) {
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        if (d2 < d3) {
            if (d < d2) {
                d += Math.PI * 2;
            }
            return d <= d3;
        }
        if (d > d2) {
            d -= Math.PI * 2;
        }
        return d3 <= d && d <= d2;
    }

    @Override
    public Geom inset(double d) {
        if (!this.filled() || Math.abs(d) < 0.001) {
            return this;
        }
        GeomBuilder geomBuilder = new GeomBuilder();
        geomBuilder.makeInsetToroidPath(this.origin.getX(), this.origin.getY(), this.r1, this.r2, this.a1, this.a2, d);
        return geomBuilder.getGeom();
    }

    public Point getOuterPoint() {
        double d = (this.a1 + this.a2) / 2.0;
        return new Point(this.origin.getX() + this.r2 * Math.cos(d), this.origin.getY() + this.r2 * Math.sin(d));
    }

    public void setOriginX(double d) {
        this.origin.setX(d);
        this.invalidate();
    }

    public void setOriginY(double d) {
        this.origin.setY(d);
        this.invalidate();
    }
}

