/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/interactionLayer")
public final class EffectTarget {
    public static final String FACET = "F";
    public static final String GRAMMAR = "G";
    public static final String ELEMENT = "E";
    public static final String LEGEND = "L";
    public static final int ANY = -1;
    private final Map<String, IntPrimitiveArrayList> targets = new HashMap<String, IntPrimitiveArrayList>(4);
    private final Set<String> targetedIDs = new HashSet<String>();

    public void setTarget(String string, int n) {
        if (!EffectTarget.validType(string)) {
            return;
        }
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList(1);
        intPrimitiveArrayList.add(n);
        this.targets.put(string, intPrimitiveArrayList);
    }

    public void setTargets(String string, int[] nArray) {
        if (!EffectTarget.validType(string)) {
            return;
        }
        if (nArray == null) {
            this.targets.remove(string);
        } else {
            IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList(1);
            for (int n : nArray) {
                intPrimitiveArrayList.add(n);
            }
            this.targets.put(string, intPrimitiveArrayList);
        }
    }

    public void addTargetedShape(SceneItem sceneItem) {
        if (sceneItem != null) {
            this.targetedIDs.add(((SceneItemImpl)sceneItem).getID());
            if (sceneItem.getHitChildren() != null) {
                for (SceneItem sceneItem2 : sceneItem.getHitChildren()) {
                    this.addTargetedShape(sceneItem2);
                }
            }
        }
    }

    public void addTargetedShapes(SceneItem[] sceneItemArray) {
        if (sceneItemArray != null) {
            for (SceneItem sceneItem : sceneItemArray) {
                this.addTargetedShape(sceneItem);
            }
        }
    }

    public void clearTargetedShapes() {
        this.targetedIDs.clear();
    }

    public boolean affectsId(String string) {
        if (this.targetedIDs.size() > 0 && !this.targetedIDs.contains(string)) {
            return false;
        }
        for (String string2 : this.targets.keySet()) {
            int n = EffectTarget.getItemIndex(string, string2);
            if (n == -1) {
                return false;
            }
            boolean bl = false;
            IntPrimitiveArrayList intPrimitiveArrayList = this.targets.get(string2);
            int n2 = intPrimitiveArrayList.size();
            for (int i = 0; !bl && i < n2; ++i) {
                int n3 = intPrimitiveArrayList.get(i);
                if (n3 != -1 && n3 != n) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean validType(String string) {
        return GRAMMAR.equals(string) || ELEMENT.equals(string) || FACET.equals(string) || LEGEND.equals(string);
    }

    private static int getItemIndex(String string, String string2) {
        if (LEGEND.equals(string2) && string.charAt(0) != 'L') {
            return -1;
        }
        Integer n = SceneIdUtil.getIndexFromID(string, string2.charAt(0));
        if (n == null) {
            return -1;
        }
        return n;
    }
}

