/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.interaction.events;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.interaction.defender.ScrollUnitRenderer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.interaction.events.DefenderViewPortEvent;
import com.ibm.vis.interaction.events.InteractivityEvent;
import com.ibm.vis.interaction.events.RaveEvent;
import com.ibm.vis.interaction.events.RaveListener;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.spec.internal.VisJSONSpec;
import com.ibm.vis.ui.VisController;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/interactionLayer")
public class DefenderInteractivityListener
implements RaveListener {
    public static final String VIEWPORT_SELECT_EVENT = "viewport_select";
    public static final String VIEWPORT_MOVE_EVENT = "viewport_move";

    @Override
    public void update(RaveEvent raveEvent, VisController visController) {
        InteractivityEvent interactivityEvent = (InteractivityEvent)raveEvent;
        if (VIEWPORT_SELECT_EVENT.equals(interactivityEvent.getType())) {
            DefenderViewPortEvent defenderViewPortEvent = (DefenderViewPortEvent)interactivityEvent;
            InteractivityImpl interactivityImpl = (InteractivityImpl)defenderViewPortEvent.getInteractivity();
            interactivityImpl.setScrollUnitStartPoint(defenderViewPortEvent.getX(), defenderViewPortEvent.getY());
        } else if (VIEWPORT_MOVE_EVENT.equals(interactivityEvent.getType())) {
            DefenderViewPortEvent defenderViewPortEvent = (DefenderViewPortEvent)interactivityEvent;
            InteractivityImpl interactivityImpl = (InteractivityImpl)defenderViewPortEvent.getInteractivity();
            ScrollUnitRenderer scrollUnitRenderer = interactivityImpl.getScrollUnitRenderer();
            Shape shape = scrollUnitRenderer.getFirstGrabber();
            Shape shape2 = scrollUnitRenderer.getSecondGrabber();
            Shape shape3 = scrollUnitRenderer.getMainGrabber();
            Shape shape4 = scrollUnitRenderer.getMedian();
            double[] dArray = interactivityImpl.updateScrollUnit(defenderViewPortEvent.getX(), shape, shape2, shape3, shape4, true);
            VisJSONSpec visJSONSpec = interactivityImpl.getZoomChartSpec(dArray);
            interactivityImpl.getDefenderTargetInteractivity().setUpdatedDefenderSpec(visJSONSpec);
        }
    }
}

